/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.KeyedCipherProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESKeyedCipherProvider
extends KeyedCipherProvider {
    private static final Logger logger = LoggerFactory.getLogger(AESKeyedCipherProvider.class);
    private static final int IV_LENGTH = 16;
    private static final List<Integer> VALID_KEY_LENGTHS = Arrays.asList(128, 192, 256);

    @Override
    public Cipher getCipher(EncryptionMethod encryptionMethod, SecretKey key, byte[] iv, boolean encryptMode) throws Exception {
        try {
            return this.getInitializedCipher(encryptionMethod, key, iv, encryptMode);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessException("Error initializing the cipher", (Throwable)e);
        }
    }

    @Override
    public Cipher getCipher(EncryptionMethod encryptionMethod, SecretKey key, boolean encryptMode) throws Exception {
        return this.getCipher(encryptionMethod, key, new byte[0], encryptMode);
    }

    protected Cipher getInitializedCipher(EncryptionMethod encryptionMethod, SecretKey key, byte[] iv, boolean encryptMode) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        byte[] emptyIv;
        if (encryptionMethod == null) {
            throw new IllegalArgumentException("The encryption method must be specified");
        }
        if (!encryptionMethod.isKeyedCipher()) {
            throw new IllegalArgumentException(encryptionMethod.name() + " requires a PBECipherProvider");
        }
        String algorithm = encryptionMethod.getAlgorithm();
        String provider = encryptionMethod.getProvider();
        if (key == null) {
            throw new IllegalArgumentException("The key must be specified");
        }
        if (!this.isValidKeyLength(key)) {
            throw new IllegalArgumentException("The key must be of length [" + StringUtils.join(VALID_KEY_LENGTHS, (String)", ") + "]");
        }
        Cipher cipher = Cipher.getInstance(algorithm, provider);
        String operation = encryptMode ? "encrypt" : "decrypt";
        boolean ivIsInvalid = false;
        int ivLength = cipher.getBlockSize();
        if (iv.length != ivLength) {
            logger.warn("An IV was provided of length {} bytes for {}ion but should be {} bytes", new Object[]{iv.length, operation, ivLength});
            ivIsInvalid = true;
        }
        if (Arrays.equals(iv, emptyIv = new byte[ivLength])) {
            logger.warn("An empty IV was provided of length {} for {}ion", (Object)iv.length, (Object)operation);
            ivIsInvalid = true;
        }
        if (ivIsInvalid) {
            if (encryptMode) {
                logger.warn("Generating new IV. The value can be obtained in the calling code by invoking 'cipher.getIV()';");
                iv = this.generateIV();
            } else {
                throw new IllegalArgumentException("Cannot decrypt without a valid IV");
            }
        }
        cipher.init(encryptMode ? 1 : 2, (Key)key, new IvParameterSpec(iv));
        return cipher;
    }

    private boolean isValidKeyLength(SecretKey key) {
        return VALID_KEY_LENGTHS.contains(key.getEncoded().length * 8);
    }

    @Override
    public byte[] generateIV() {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        return iv;
    }
}

