/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.krb;

import org.apache.nifi.util.StringUtils;

public class KerberosPrincipalParser {
    public static String getRealm(String principal) {
        if (StringUtils.isBlank((String)principal)) {
            throw new IllegalArgumentException("principal can not be null or empty");
        }
        char previousChar = '\u0000';
        int realmDelimiterIndex = -1;
        boolean realmDelimiterFound = false;
        int principalLength = principal.length();
        for (int i = 0; i < principalLength; ++i) {
            char currentChar = principal.charAt(i);
            if (currentChar == '@' && previousChar != '\\') {
                realmDelimiterIndex = i;
                realmDelimiterFound = true;
            }
            previousChar = currentChar;
        }
        String principalAfterLastRealmDelimiter = principal.substring(realmDelimiterIndex + 1);
        return realmDelimiterFound && realmDelimiterIndex + 1 < principalLength ? principalAfterLastRealmDelimiter : null;
    }
}

