/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreUtils {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreUtils.class);
    public static final String SUN_PROVIDER_NAME = "SUN";

    public static String getKeyStoreProvider(String keyStoreType) {
        if (KeystoreType.PKCS12.toString().equalsIgnoreCase(keyStoreType)) {
            return "BC";
        }
        if (KeystoreType.JKS.toString().equalsIgnoreCase(keyStoreType)) {
            return SUN_PROVIDER_NAME;
        }
        return null;
    }

    public static KeyStore getKeyStore(String keyStoreType) throws KeyStoreException {
        String keyStoreProvider = KeyStoreUtils.getKeyStoreProvider(keyStoreType);
        if (StringUtils.isNotEmpty((CharSequence)keyStoreProvider)) {
            try {
                return KeyStore.getInstance(keyStoreType, keyStoreProvider);
            }
            catch (Exception e) {
                logger.error("Unable to load " + keyStoreProvider + " " + keyStoreType + " keystore.  This may cause issues getting trusted CA certificates as well as Certificate Chains for use in TLS.", (Throwable)e);
            }
        }
        return KeyStore.getInstance(keyStoreType);
    }

    public static KeyStore getTrustStore(String trustStoreType) throws KeyStoreException {
        if (KeystoreType.PKCS12.toString().equalsIgnoreCase(trustStoreType)) {
            logger.warn(trustStoreType + " truststores are deprecated.  " + KeystoreType.JKS.toString() + " is preferred.");
        }
        return KeyStoreUtils.getKeyStore(trustStoreType);
    }

    public static KeyStore loadKeyStore(String keystorePath, char[] keystorePassword, String keystoreType) throws TlsException {
        try {
            KeyStore keyStore = KeyStoreUtils.getKeyStore(keystoreType);
            try (FileInputStream keyStoreStream = new FileInputStream(keystorePath);){
                keyStore.load(keyStoreStream, keystorePassword);
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Encountered an error loading keystore: {}", (Object)e.getLocalizedMessage());
            throw new TlsException("Error loading keystore", e);
        }
    }

    public static KeyManagerFactory getKeyManagerFactoryFromKeyStore(KeyStore keyStore, char[] keystorePassword, char[] keyPassword) throws TlsException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (keyPassword == null) {
                keyManagerFactory.init(keyStore, keystorePassword);
            } else {
                keyManagerFactory.init(keyStore, keyPassword);
            }
            return keyManagerFactory;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            logger.error("Encountered an error loading keystore: {}", (Object)e.getLocalizedMessage());
            throw new TlsException("Error loading keystore", e);
        }
    }

    public static KeyManagerFactory loadKeyManagerFactory(TlsConfiguration tlsConfiguration) throws TlsException {
        return KeyStoreUtils.loadKeyManagerFactory(tlsConfiguration.getKeystorePath(), tlsConfiguration.getKeystorePassword(), tlsConfiguration.getFunctionalKeyPassword(), tlsConfiguration.getKeystoreType().getType());
    }

    public static KeyManagerFactory loadKeyManagerFactory(String keystorePath, String keystorePassword, String keyPassword, String keystoreType) throws TlsException {
        if (StringUtils.isEmpty((CharSequence)keystorePassword)) {
            throw new IllegalArgumentException("The keystore password cannot be null or empty");
        }
        char[] keystorePasswordChars = keystorePassword.toCharArray();
        char[] keyPasswordChars = StringUtils.isNotEmpty((CharSequence)keyPassword) ? keyPassword.toCharArray() : keystorePasswordChars;
        KeyStore keyStore = KeyStoreUtils.loadKeyStore(keystorePath, keystorePasswordChars, keystoreType);
        return KeyStoreUtils.getKeyManagerFactoryFromKeyStore(keyStore, keystorePasswordChars, keyPasswordChars);
    }

    public static KeyStore loadTrustStore(String truststorePath, char[] truststorePassword, String truststoreType) throws TlsException {
        try {
            KeyStore trustStore = KeyStoreUtils.getTrustStore(truststoreType);
            try (FileInputStream trustStoreStream = new FileInputStream(truststorePath);){
                trustStore.load(trustStoreStream, truststorePassword);
            }
            return trustStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Encountered an error loading truststore: {}", (Object)e.getLocalizedMessage());
            throw new TlsException("Error loading truststore", e);
        }
    }

    public static TrustManagerFactory getTrustManagerFactoryFromTrustStore(KeyStore trustStore) throws TlsException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return trustManagerFactory;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            logger.error("Encountered an error loading truststore: {}", (Object)e.getLocalizedMessage());
            throw new TlsException("Error loading truststore", e);
        }
    }

    public static TrustManagerFactory loadTrustManagerFactory(TlsConfiguration tlsConfiguration) throws TlsException {
        return KeyStoreUtils.loadTrustManagerFactory(tlsConfiguration.getTruststorePath(), tlsConfiguration.getTruststorePassword(), tlsConfiguration.getTruststoreType().getType());
    }

    public static TrustManagerFactory loadTrustManagerFactory(String truststorePath, String truststorePassword, String truststoreType) throws TlsException {
        char[] truststorePasswordChars = StringUtils.isNotBlank((CharSequence)truststorePassword) ? truststorePassword.toCharArray() : null;
        KeyStore trustStore = KeyStoreUtils.loadTrustStore(truststorePath, truststorePasswordChars, truststoreType);
        return KeyStoreUtils.getTrustManagerFactoryFromTrustStore(trustStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStoreValid(URL keystore, KeystoreType keystoreType, char[] password) {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        if (keystoreType == null) {
            throw new IllegalArgumentException("Keystore type may not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password may not be null");
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(keystore.openStream());
            KeyStore ks = KeyStoreUtils.getKeyStore(keystoreType.name());
            ks.load(bis, password);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close input stream", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isKeyPasswordCorrect(URL keystore, KeystoreType keystoreType, char[] password, char[] keyPassword) {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        if (keystoreType == null) {
            throw new IllegalArgumentException("Keystore type may not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password may not be null");
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(keystore.openStream());
            KeyStore ks = KeyStoreUtils.getKeyStore(keystoreType.name());
            ks.load(bis, password);
            String alias = ks.aliases().nextElement();
            try {
                Key privateKeyEntry = ks.getKey(alias, keyPassword);
                boolean bl = true;
                return bl;
            }
            catch (UnrecoverableKeyException e) {
                boolean bl;
                block20: {
                    logger.warn("Tried to access a key in keystore " + keystore + " with a key password that failed");
                    bl = false;
                    if (bis == null) break block20;
                    try {
                        bis.close();
                    }
                    catch (IOException ioe) {
                        logger.warn("Failed to close input stream", (Throwable)ioe);
                    }
                }
                return bl;
                catch (Exception e2) {
                    boolean bl2 = false;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close input stream", (Throwable)ioe);
                }
            }
        }
    }

    public static String sslContextToString(SSLContext sslContext) {
        return new ToStringBuilder((Object)sslContext).append("protocol", (Object)sslContext.getProtocol()).append("provider", (Object)sslContext.getProvider().toString()).toString();
    }

    public static String sslParametersToString(SSLParameters sslParameters) {
        return new ToStringBuilder((Object)sslParameters).append("protocols", (Object[])sslParameters.getProtocols()).append("wantClientAuth", sslParameters.getWantClientAuth()).append("needClientAuth", sslParameters.getNeedClientAuth()).toString();
    }

    public static String sslServerSocketToString(SSLServerSocket sslServerSocket) {
        return new ToStringBuilder((Object)sslServerSocket).append("enabledProtocols", (Object[])sslServerSocket.getEnabledProtocols()).append("needClientAuth", sslServerSocket.getNeedClientAuth()).append("wantClientAuth", sslServerSocket.getWantClientAuth()).append("useClientMode", sslServerSocket.getUseClientMode()).toString();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

