/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.nifi.util.StringUtils;

public enum KeystoreType {
    PKCS12("PKCS12", "A PKCS12 Keystore"),
    JKS("JKS", "A Java Keystore");

    private final String type;
    private final String description;

    private KeystoreType(String type, String description) {
        this.type = type;
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getType();
    }

    public static boolean isValidKeystoreType(String type) {
        if (StringUtils.isBlank((String)type)) {
            return false;
        }
        return Arrays.stream(KeystoreType.values()).map(kt -> kt.getType().toLowerCase()).collect(Collectors.toList()).contains(type.toLowerCase());
    }
}

