/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Objects;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTlsConfiguration
implements TlsConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(StandardTlsConfiguration.class);
    private static final String TLS_PROTOCOL_VERSION = TlsConfiguration.getHighestCurrentSupportedTlsProtocolVersion();
    private static final String MASKED_PASSWORD_LOG = "********";
    private static final String NULL_LOG = "null";
    private final String keystorePath;
    private final String keystorePassword;
    private final String keyPassword;
    private final KeystoreType keystoreType;
    private final String truststorePath;
    private final String truststorePassword;
    private final KeystoreType truststoreType;
    private final String protocol;

    public StandardTlsConfiguration() {
        this(null, null, null, "", null, null, "", null);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, KeystoreType keystoreType, String truststorePath, String truststorePassword, KeystoreType truststoreType) {
        this(keystorePath, keystorePassword, keystorePassword, keystoreType, truststorePath, truststorePassword, truststoreType, TLS_PROTOCOL_VERSION);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, String keyPassword, KeystoreType keystoreType, String truststorePath, String truststorePassword, KeystoreType truststoreType) {
        this(keystorePath, keystorePassword, keyPassword, keystoreType, truststorePath, truststorePassword, truststoreType, TLS_PROTOCOL_VERSION);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, String keyPassword, String keystoreType, String truststorePath, String truststorePassword, String truststoreType) {
        this(keystorePath, keystorePassword, keyPassword, KeystoreType.isValidKeystoreType((String)keystoreType) ? KeystoreType.valueOf((String)keystoreType.toUpperCase()) : null, truststorePath, truststorePassword, KeystoreType.isValidKeystoreType((String)truststoreType) ? KeystoreType.valueOf((String)truststoreType.toUpperCase()) : null, TLS_PROTOCOL_VERSION);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, String keyPassword, String keystoreType, String truststorePath, String truststorePassword, String truststoreType, String protocol) {
        this(keystorePath, keystorePassword, keyPassword, KeystoreType.isValidKeystoreType((String)keystoreType) ? KeystoreType.valueOf((String)keystoreType.toUpperCase()) : null, truststorePath, truststorePassword, KeystoreType.isValidKeystoreType((String)truststoreType) ? KeystoreType.valueOf((String)truststoreType.toUpperCase()) : null, protocol);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, String keyPassword, KeystoreType keystoreType, String truststorePath, String truststorePassword, KeystoreType truststoreType, String protocol) {
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
        this.keystoreType = keystoreType;
        this.truststorePath = truststorePath;
        this.truststorePassword = truststorePassword;
        this.truststoreType = truststoreType;
        this.protocol = protocol;
    }

    public StandardTlsConfiguration(TlsConfiguration other) {
        this.keystorePath = other.getKeystorePath();
        this.keystorePassword = other.getKeystorePassword();
        this.keyPassword = other.getKeyPassword();
        this.keystoreType = other.getKeystoreType();
        this.truststorePath = other.getTruststorePath();
        this.truststorePassword = other.getTruststorePassword();
        this.truststoreType = other.getTruststoreType();
        this.protocol = other.getProtocol();
    }

    public static StandardTlsConfiguration fromNiFiProperties(NiFiProperties niFiProperties) {
        if (niFiProperties == null) {
            throw new IllegalArgumentException("The NiFi properties cannot be null");
        }
        String keystorePath = niFiProperties.getProperty("nifi.security.keystore");
        String keystorePassword = niFiProperties.getProperty("nifi.security.keystorePasswd");
        String keyPassword = niFiProperties.getProperty("nifi.security.keyPasswd");
        String keystoreType = niFiProperties.getProperty("nifi.security.keystoreType");
        String truststorePath = niFiProperties.getProperty("nifi.security.truststore");
        String truststorePassword = niFiProperties.getProperty("nifi.security.truststorePasswd");
        String truststoreType = niFiProperties.getProperty("nifi.security.truststoreType");
        String protocol = TLS_PROTOCOL_VERSION;
        StandardTlsConfiguration tlsConfiguration = new StandardTlsConfiguration(keystorePath, keystorePassword, keyPassword, keystoreType, truststorePath, truststorePassword, truststoreType, protocol);
        if (logger.isDebugEnabled()) {
            logger.debug("Instantiating TlsConfiguration from NiFi properties: {}, {}, {}, {}, {}, {}, {}, {}", new Object[]{keystorePath, tlsConfiguration.getKeystorePasswordForLogging(), tlsConfiguration.getKeyPasswordForLogging(), keystoreType, truststorePath, tlsConfiguration.getTruststorePasswordForLogging(), truststoreType, protocol});
        }
        return tlsConfiguration;
    }

    public static StandardTlsConfiguration fromNiFiPropertiesTruststoreOnly(NiFiProperties niFiProperties) {
        if (niFiProperties == null) {
            throw new IllegalArgumentException("The NiFi properties cannot be null");
        }
        String truststorePath = niFiProperties.getProperty("nifi.security.truststore");
        String truststorePassword = niFiProperties.getProperty("nifi.security.truststorePasswd");
        String truststoreType = niFiProperties.getProperty("nifi.security.truststoreType");
        String protocol = TLS_PROTOCOL_VERSION;
        StandardTlsConfiguration tlsConfiguration = new StandardTlsConfiguration(null, null, null, null, truststorePath, truststorePassword, truststoreType, protocol);
        if (logger.isDebugEnabled()) {
            logger.debug("Instantiating TlsConfiguration from NiFi properties: null x4, {}, {}, {}, {}", new Object[]{truststorePath, tlsConfiguration.getTruststorePasswordForLogging(), truststoreType, protocol});
        }
        return tlsConfiguration;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystorePasswordForLogging() {
        return StandardTlsConfiguration.maskPasswordForLog(this.keystorePassword);
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyPasswordForLogging() {
        return StandardTlsConfiguration.maskPasswordForLog(this.keyPassword);
    }

    public String getFunctionalKeyPassword() {
        return StringUtils.isNotBlank((String)this.keyPassword) ? this.keyPassword : this.keystorePassword;
    }

    public String getFunctionalKeyPasswordForLogging() {
        return StandardTlsConfiguration.maskPasswordForLog(this.getFunctionalKeyPassword());
    }

    public KeystoreType getKeystoreType() {
        return this.keystoreType;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getTruststorePasswordForLogging() {
        return StandardTlsConfiguration.maskPasswordForLog(this.truststorePassword);
    }

    public KeystoreType getTruststoreType() {
        return this.truststoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isKeystorePopulated() {
        return this.isStorePopulated(this.keystorePath, this.keystorePassword, this.keystoreType, "keystore");
    }

    public boolean isAnyKeystorePopulated() {
        return this.isAnyPopulated(this.keystorePath, this.keystorePassword, this.keystoreType);
    }

    public boolean isKeystoreValid() {
        boolean simpleCheck = this.isStoreValid(this.keystorePath, this.keystorePassword, this.keystoreType, "keystore");
        if (simpleCheck) {
            return true;
        }
        if (StringUtils.isNotBlank((String)this.keyPassword) && !this.keystorePassword.equals(this.keyPassword)) {
            logger.debug("Simple keystore validity check failed; trying with separate key password");
            try {
                return this.isKeystorePopulated() && KeyStoreUtils.isKeyPasswordCorrect(new File(this.keystorePath).toURI().toURL(), this.keystoreType, this.keystorePassword.toCharArray(), this.getFunctionalKeyPassword().toCharArray());
            }
            catch (MalformedURLException e) {
                logger.error("Encountered an error validating the keystore: " + e.getLocalizedMessage());
                return false;
            }
        }
        return false;
    }

    public boolean isTruststorePopulated() {
        return this.isStorePopulated(this.truststorePath, this.truststorePassword, this.truststoreType, "truststore");
    }

    public boolean isAnyTruststorePopulated() {
        return this.isAnyPopulated(this.truststorePath, this.truststorePassword, this.truststoreType);
    }

    public boolean isTruststoreValid() {
        return this.isStoreValid(this.truststorePath, this.truststorePassword, this.truststoreType, "truststore");
    }

    public String[] getKeystorePropertiesForLogging() {
        return new String[]{this.getKeystorePath(), this.getKeystorePasswordForLogging(), this.getFunctionalKeyPasswordForLogging(), this.getKeystoreType() != null ? this.getKeystoreType().getType() : NULL_LOG};
    }

    public String[] getTruststorePropertiesForLogging() {
        return new String[]{this.getTruststorePath(), this.getTruststorePasswordForLogging(), this.getKeystoreType() != null ? this.getTruststoreType().getType() : NULL_LOG};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[TlsConfiguration]");
        sb.append("keystorePath=").append(this.keystorePath);
        sb.append(",keystorePassword=").append(this.getKeystorePasswordForLogging());
        sb.append(",keyPassword=").append(this.getKeyPasswordForLogging());
        sb.append(",keystoreType=").append(this.keystoreType);
        sb.append(",truststorePath=").append(this.truststorePath);
        sb.append(",truststorePassword=").append(this.getTruststorePasswordForLogging());
        sb.append(",truststoreType=").append(this.truststoreType);
        sb.append(",protocol=").append(this.protocol);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TlsConfiguration that = (TlsConfiguration)o;
        return Objects.equals(this.keystorePath, that.getKeystorePath()) && Objects.equals(this.keystorePassword, that.getKeystorePassword()) && Objects.equals(this.keyPassword, that.getKeyPassword()) && this.keystoreType == that.getKeystoreType() && Objects.equals(this.truststorePath, that.getTruststorePath()) && Objects.equals(this.truststorePassword, that.getTruststorePassword()) && this.truststoreType == that.getTruststoreType() && Objects.equals(this.protocol, that.getProtocol());
    }

    public int hashCode() {
        return Objects.hash(this.keystorePath, this.keystorePassword, this.keyPassword, this.keystoreType, this.truststorePath, this.truststorePassword, this.truststoreType, this.protocol);
    }

    private static String maskPasswordForLog(String password) {
        return StringUtils.isNotBlank((String)password) ? MASKED_PASSWORD_LOG : NULL_LOG;
    }

    private boolean isAnyPopulated(String path, String password, KeystoreType type) {
        return StringUtils.isNotBlank((String)path) || StringUtils.isNotBlank((String)password) || type != null;
    }

    private boolean isStorePopulated(String path, String password, KeystoreType type, String label) {
        String passwordForLogging;
        boolean isPopulated;
        boolean bl = isPopulated = StringUtils.isNotBlank((String)path) && type != null;
        if ("truststore".equalsIgnoreCase(label)) {
            passwordForLogging = this.getTruststorePasswordForLogging();
        } else {
            isPopulated = isPopulated && StringUtils.isNotBlank((String)password);
            passwordForLogging = this.getKeystorePasswordForLogging();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TLS config {} is {}: {}, {}, {}", new Object[]{label, isPopulated ? "populated" : "not populated", path, passwordForLogging, type});
        }
        return isPopulated;
    }

    private boolean isStoreValid(String path, String password, KeystoreType type, String label) {
        try {
            return this.isStorePopulated(path, password, type, label) && KeyStoreUtils.isStoreValid(new File(path).toURI().toURL(), type, password.toCharArray());
        }
        catch (MalformedURLException e) {
            logger.error("Encountered an error validating the " + label + ": " + e.getLocalizedMessage());
            return false;
        }
    }
}

