/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.security.krb.KerberosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKerberosUser
implements KerberosUser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKerberosUser.class);
    static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final float TICKET_RENEW_WINDOW = 0.8f;
    protected final String principal;
    protected final AtomicBoolean loggedIn = new AtomicBoolean(false);
    protected Subject subject;
    protected LoginContext loginContext;

    public AbstractKerberosUser(String principal) {
        this.principal = principal;
        Validate.notBlank((CharSequence)this.principal);
    }

    @Override
    public synchronized void login() throws LoginException {
        if (this.isLoggedIn()) {
            return;
        }
        try {
            if (this.loginContext == null) {
                LOGGER.debug("Initializing new login context...");
                if (this.subject == null) {
                    this.subject = new Subject();
                }
                this.loginContext = this.createLoginContext(this.subject);
            }
            this.loginContext.login();
            this.loggedIn.set(true);
            LOGGER.debug("Successful login for {}", new Object[]{this.principal});
        }
        catch (LoginException le) {
            LoginException loginException = new LoginException("Unable to login with " + this.principal + " due to: " + le.getMessage());
            loginException.setStackTrace(le.getStackTrace());
            throw loginException;
        }
    }

    protected abstract LoginContext createLoginContext(Subject var1) throws LoginException;

    @Override
    public synchronized void logout() throws LoginException {
        if (!this.isLoggedIn()) {
            return;
        }
        try {
            this.loginContext.logout();
            this.loggedIn.set(false);
            LOGGER.debug("Successful logout for {}", new Object[]{this.principal});
            this.loginContext = null;
        }
        catch (LoginException e) {
            throw new LoginException("Logout failed due to: " + e.getMessage());
        }
    }

    @Override
    public <T> T doAs(PrivilegedAction<T> action) throws IllegalStateException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("Must login before executing actions");
        }
        return Subject.doAs(this.subject, action);
    }

    @Override
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws IllegalStateException, PrivilegedActionException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("Must login before executing actions");
        }
        return Subject.doAs(this.subject, action);
    }

    @Override
    public synchronized boolean checkTGTAndRelogin() throws LoginException {
        KerberosTicket tgt = this.getTGT();
        if (tgt == null) {
            LOGGER.debug("TGT was not found");
        }
        if (tgt != null && System.currentTimeMillis() < this.getRefreshTime(tgt)) {
            LOGGER.debug("TGT was found, but has not reached expiration window");
            return false;
        }
        LOGGER.debug("Performing relogin for {}", new Object[]{this.principal});
        this.logout();
        this.login();
        return true;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!this.isTGSPrincipal(ticket.getServer())) continue;
            return ticket;
        }
        return null;
    }

    private boolean isTGSPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        if (principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm())) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Found TGT principal: " + principal.getName());
            }
            return true;
        }
        return false;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        if (LOGGER.isTraceEnabled()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            String startDate = dateFormat.format(new Date(start));
            String endDate = dateFormat.format(new Date(end));
            LOGGER.trace("TGT valid starting at: " + startDate);
            LOGGER.trace("TGT expires at: " + endDate);
        }
        return start + (long)((float)(end - start) * 0.8f);
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn.get();
    }

    @Override
    public String getPrincipal() {
        return this.principal;
    }

    Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "KerberosUser{principal='" + this.principal + '\'' + ", loggedIn=" + this.loggedIn + '}';
    }
}

