/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.security.ssl.StandardKeyManagerFactoryBuilder;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardTrustManagerFactoryBuilder;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(SslContextFactory.class);

    public static SSLContext createSslContext(TlsConfiguration tlsConfiguration) throws TlsException {
        if (TlsConfiguration.isEmpty((TlsConfiguration)tlsConfiguration)) {
            logger.debug("Cannot create SSLContext from empty TLS configuration; returning null");
            return null;
        }
        if (tlsConfiguration.isKeystorePopulated() && !tlsConfiguration.isTruststorePopulated()) {
            logger.error("The TLS config keystore properties were populated but the truststore properties were not");
            if (logger.isDebugEnabled()) {
                logger.debug("Provided TLS config: {}", (Object)tlsConfiguration);
            }
            throw new TlsException("Truststore properties are required if keystore properties are present");
        }
        TrustManager[] trustManagers = SslContextFactory.getTrustManagers(tlsConfiguration);
        return SslContextFactory.createSslContext(tlsConfiguration, trustManagers);
    }

    public static SSLContext createSslContext(TlsConfiguration tlsConfiguration, TrustManager[] trustManagers) throws TlsException {
        if (TlsConfiguration.isEmpty((TlsConfiguration)tlsConfiguration)) {
            logger.debug("Cannot create SSLContext from empty TLS configuration; returning null");
            return null;
        }
        KeyManager[] keyManagers = SslContextFactory.getKeyManagers(tlsConfiguration);
        return SslContextFactory.initializeSSLContext(tlsConfiguration, keyManagers, trustManagers);
    }

    public static X509TrustManager getX509TrustManager(TlsConfiguration tlsConfiguration) throws TlsException {
        TrustManager[] trustManagers = SslContextFactory.getTrustManagers(tlsConfiguration);
        if (trustManagers == null) {
            return null;
        }
        Optional<X509TrustManager> x509TrustManager = Arrays.stream(trustManagers).filter(tm -> tm instanceof X509TrustManager).map(tm -> (X509TrustManager)tm).findFirst();
        return x509TrustManager.orElse(null);
    }

    public static SSLSocketFactory createSSLSocketFactory(TlsConfiguration tlsConfiguration) throws TlsException {
        SSLContext sslContext = SslContextFactory.createSslContext(tlsConfiguration);
        if (sslContext == null) {
            if (!TlsConfiguration.isEmpty((TlsConfiguration)tlsConfiguration)) {
                logger.error("The SSLContext could not be formed from the provided TLS configuration. Check the provided keystore and truststore properties");
            }
            return null;
        }
        return sslContext.getSocketFactory();
    }

    protected static KeyManager[] getKeyManagers(TlsConfiguration tlsConfiguration) throws TlsException {
        KeyManager[] keyManagers;
        block9: {
            keyManagers = null;
            String keystorePath = tlsConfiguration.getKeystorePath();
            KeystoreType keystoreType = tlsConfiguration.getKeystoreType();
            if (tlsConfiguration.isKeystorePopulated()) {
                try (FileInputStream inputStream = new FileInputStream(keystorePath);){
                    KeyStore keyStore = new StandardKeyStoreBuilder().inputStream((InputStream)inputStream).type(keystoreType.getType()).password(tlsConfiguration.getKeystorePassword().toCharArray()).build();
                    keyManagers = new StandardKeyManagerFactoryBuilder().keyStore(keyStore).keyPassword(tlsConfiguration.getFunctionalKeyPassword().toCharArray()).build().getKeyManagers();
                    break block9;
                }
                catch (IOException e) {
                    String message = "Key Store [%s] Type [%s] loading failed".formatted(keystorePath, keystoreType);
                    throw new TlsException(message, (Throwable)e);
                }
            }
            if (tlsConfiguration.isAnyKeystorePopulated()) {
                throw new TlsException("Key Store properties missing: Set Path [%s] Type [%s]".formatted(keystorePath, keystoreType));
            }
        }
        return keyManagers;
    }

    public static TrustManager[] getTrustManagers(TlsConfiguration tlsConfiguration) throws TlsException {
        TrustManager[] trustManagers;
        block10: {
            Objects.requireNonNull(tlsConfiguration, "TLS Configuration required");
            String truststorePath = tlsConfiguration.getTruststorePath();
            KeystoreType truststoreType = tlsConfiguration.getTruststoreType();
            trustManagers = null;
            if (tlsConfiguration.isTruststorePopulated()) {
                try (FileInputStream inputStream = new FileInputStream(truststorePath);){
                    StandardKeyStoreBuilder keyStoreBuilder = new StandardKeyStoreBuilder().inputStream((InputStream)inputStream).type(truststoreType.getType());
                    String truststorePassword = tlsConfiguration.getTruststorePassword();
                    if (truststorePassword != null) {
                        keyStoreBuilder.password(truststorePassword.toCharArray());
                    }
                    KeyStore trustStore = keyStoreBuilder.build();
                    trustManagers = new StandardTrustManagerFactoryBuilder().trustStore(trustStore).build().getTrustManagers();
                    break block10;
                }
                catch (IOException e) {
                    String message = "Trust Store [%s] Type [%s] loading failed".formatted(truststorePath, truststoreType);
                    throw new TlsException(message, (Throwable)e);
                }
            }
            if (tlsConfiguration.isAnyTruststorePopulated()) {
                throw new TlsException("Trust Store properties missing: Set Path [%s] Type [%s]".formatted(truststorePath, truststoreType));
            }
        }
        return trustManagers;
    }

    private static SSLContext initializeSSLContext(TlsConfiguration tlsConfiguration, KeyManager[] keyManagers, TrustManager[] trustManagers) throws TlsException {
        try {
            SSLContext sslContext = SSLContext.getInstance(tlsConfiguration.getProtocol());
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error("Encountered an error creating SSLContext from TLS configuration ({}): {}", (Object)tlsConfiguration, (Object)e.getLocalizedMessage());
            throw new TlsException("Error creating SSL context", (Throwable)e);
        }
    }
}

