/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.json.JsonArray;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.client.SiteToSiteClient;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.remote.protocol.http.HttpProxy;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SerializedForm;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;

public abstract class AbstractSiteToSiteReportingTask
extends AbstractReportingTask {
    protected static final String LAST_EVENT_ID_KEY = "last_event_id";
    protected static final String DESTINATION_URL_PATH = "/nifi";
    protected static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    static final PropertyDescriptor DESTINATION_URL = new PropertyDescriptor.Builder().name("Destination URL").displayName("Destination URL").description("The URL of the destination NiFi instance or, if clustered, a comma-separated list of address in the format of http(s)://host:port/nifi. This destination URL will only be used to initiate the Site-to-Site connection. The data sent by this reporting task will be load-balanced on all the nodes of the destination (if clustered).").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator((Validator)new NiFiUrlValidator()).build();
    static final PropertyDescriptor PORT_NAME = new PropertyDescriptor.Builder().name("Input Port Name").displayName("Input Port Name").description("The name of the Input Port to deliver data to.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor SSL_CONTEXT = new PropertyDescriptor.Builder().name("SSL Context Service").displayName("SSL Context Service").description("The SSL Context Service to use when communicating with the destination. If not specified, communications will not be secure.").required(false).identifiesControllerService(RestrictedSSLContextService.class).build();
    static final PropertyDescriptor INSTANCE_URL = new PropertyDescriptor.Builder().name("Instance URL").displayName("Instance URL").description("The URL of this instance to use in the Content URI of each event.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("http://${hostname(true)}:8080/nifi").addValidator((Validator)new NiFiUrlValidator()).build();
    static final PropertyDescriptor COMPRESS = new PropertyDescriptor.Builder().name("Compress Events").displayName("Compress Events").description("Indicates whether or not to compress the data being sent.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    static final PropertyDescriptor TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").displayName("Communications Timeout").description("Specifies how long to wait to a response from the destination before deciding that an error has occurred and canceling the transaction").required(true).defaultValue("30 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").displayName("Batch Size").description("Specifies how many records to send in a single batch, at most.").required(true).defaultValue("1000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor TRANSPORT_PROTOCOL = new PropertyDescriptor.Builder().name("s2s-transport-protocol").displayName("Transport Protocol").description("Specifies which transport protocol to use for Site-to-Site communication.").required(true).allowableValues((Enum[])SiteToSiteTransportProtocol.values()).defaultValue(SiteToSiteTransportProtocol.RAW.name()).build();
    static final PropertyDescriptor HTTP_PROXY_HOSTNAME = new PropertyDescriptor.Builder().name("s2s-http-proxy-hostname").displayName("HTTP Proxy hostname").description("Specify the proxy server's hostname to use. If not specified, HTTP traffics are sent directly to the target NiFi instance.").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor HTTP_PROXY_PORT = new PropertyDescriptor.Builder().name("s2s-http-proxy-port").displayName("HTTP Proxy port").description("Specify the proxy server's port number, optional. If not specified, default port 80 will be used.").required(false).addValidator(StandardValidators.PORT_VALIDATOR).build();
    static final PropertyDescriptor HTTP_PROXY_USERNAME = new PropertyDescriptor.Builder().name("s2s-http-proxy-username").displayName("HTTP Proxy username").description("Specify an user name to connect to the proxy server, optional.").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor HTTP_PROXY_PASSWORD = new PropertyDescriptor.Builder().name("s2s-http-proxy-password").displayName("HTTP Proxy password").description("Specify an user password to connect to the proxy server, optional.").required(false).sensitive(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("record-writer").displayName("Record Writer").description("Specifies the Controller Service to use for writing out the records.").identifiesControllerService(RecordSetWriterFactory.class).required(false).build();
    protected volatile SiteToSiteClient siteToSiteClient;
    protected volatile RecordSchema recordSchema;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(DESTINATION_URL);
        properties.add(PORT_NAME);
        properties.add(SSL_CONTEXT);
        properties.add(INSTANCE_URL);
        properties.add(COMPRESS);
        properties.add(TIMEOUT);
        properties.add(BATCH_SIZE);
        properties.add(TRANSPORT_PROTOCOL);
        properties.add(HTTP_PROXY_HOSTNAME);
        properties.add(HTTP_PROXY_PORT);
        properties.add(HTTP_PROXY_USERNAME);
        properties.add(HTTP_PROXY_PASSWORD);
        properties.add(RECORD_WRITER);
        return properties;
    }

    @OnScheduled
    public void setup(ConfigurationContext context) throws IOException {
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT).asControllerService(SSLContextService.class);
        SSLContext sslContext = sslContextService == null ? null : sslContextService.createSSLContext(SSLContextService.ClientAuth.REQUIRED);
        final ComponentLog logger = this.getLogger();
        EventReporter eventReporter = new EventReporter(){

            public void reportEvent(Severity severity, String category, String message) {
                switch (severity) {
                    case WARNING: {
                        logger.warn(message);
                        break;
                    }
                    case ERROR: {
                        logger.error(message);
                        break;
                    }
                }
            }
        };
        String destinationUrl = context.getProperty(DESTINATION_URL).evaluateAttributeExpressions().getValue();
        SiteToSiteTransportProtocol mode = SiteToSiteTransportProtocol.valueOf((String)context.getProperty(TRANSPORT_PROTOCOL).getValue());
        HttpProxy httpProxy = mode.equals((Object)SiteToSiteTransportProtocol.RAW) || StringUtils.isEmpty((String)context.getProperty(HTTP_PROXY_HOSTNAME).getValue()) ? null : new HttpProxy(context.getProperty(HTTP_PROXY_HOSTNAME).getValue(), context.getProperty(HTTP_PROXY_PORT).asInteger(), context.getProperty(HTTP_PROXY_USERNAME).getValue(), context.getProperty(HTTP_PROXY_PASSWORD).getValue());
        this.siteToSiteClient = new SiteToSiteClient.Builder().urls(SiteToSiteRestApiClient.parseClusterUrls((String)destinationUrl)).portName(context.getProperty(PORT_NAME).getValue()).useCompression(context.getProperty(COMPRESS).asBoolean().booleanValue()).eventReporter(eventReporter).sslContext(sslContext).timeout(context.getProperty(TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).longValue(), TimeUnit.MILLISECONDS).transportProtocol(mode).httpProxy(httpProxy).build();
    }

    @OnStopped
    public void shutdown() throws IOException {
        SiteToSiteClient client = this.getClient();
        if (client != null) {
            client.close();
        }
    }

    protected SiteToSiteClient getClient() {
        return this.siteToSiteClient;
    }

    protected void sendData(ReportingContext context, Transaction transaction, Map<String, String> attributes, JsonArray jsonArray) throws IOException {
        if (context.getProperty(RECORD_WRITER).isSet()) {
            transaction.send(this.getData(context, new ByteArrayInputStream(jsonArray.toString().getBytes(StandardCharsets.UTF_8)), attributes), attributes);
        } else {
            transaction.send(jsonArray.toString().getBytes(StandardCharsets.UTF_8), attributes);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getData(ReportingContext context, InputStream in, Map<String, String> attributes) {
        try (JsonRecordReader reader = new JsonRecordReader(in, this.recordSchema);){
            RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER).asControllerService(RecordSetWriterFactory.class);
            RecordSchema writeSchema = writerFactory.getSchema(null, this.recordSchema);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (RecordSetWriter writer = writerFactory.createWriter(this.getLogger(), writeSchema, (OutputStream)out);){
                Record record;
                writer.beginRecordSet();
                while ((record = reader.nextRecord()) != null) {
                    writer.write(record);
                }
                WriteResult writeResult = writer.finishRecordSet();
                attributes.put(CoreAttributes.MIME_TYPE.key(), writer.getMimeType());
                attributes.putAll(writeResult.getAttributes());
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException | SchemaNotFoundException | MalformedRecordException e) {
            throw new ProcessException("Failed to write metrics using record writer: " + e.getMessage(), e);
        }
    }

    protected void addField(JsonObjectBuilder builder, String key, Long value) {
        if (value != null) {
            builder.add(key, value.longValue());
        }
    }

    protected void addField(JsonObjectBuilder builder, String key, Integer value) {
        if (value != null) {
            builder.add(key, value.intValue());
        }
    }

    protected void addField(JsonObjectBuilder builder, String key, String value) {
        if (value == null) {
            return;
        }
        builder.add(key, value);
    }

    protected void addField(JsonObjectBuilder builder, String key, String value, boolean allowNullValues) {
        if (value == null) {
            if (allowNullValues) {
                builder.add(key, JsonValue.NULL);
            }
        } else {
            builder.add(key, value);
        }
    }

    private class JsonRecordReader
    implements RecordReader {
        private RecordSchema recordSchema;
        private final JsonParser jsonParser;
        private final boolean array;
        private final JsonNode firstJsonNode;
        private boolean firstObjectConsumed = false;
        private final Supplier<DateFormat> dateFormat = () -> DataTypeUtils.getDateFormat((String)RecordFieldType.DATE.getDefaultFormat());
        private final Supplier<DateFormat> timeFormat = () -> DataTypeUtils.getDateFormat((String)RecordFieldType.TIME.getDefaultFormat());
        private final Supplier<DateFormat> timestampFormat = () -> DataTypeUtils.getDateFormat((String)RecordFieldType.TIMESTAMP.getDefaultFormat());

        public JsonRecordReader(InputStream in, RecordSchema recordSchema) throws IOException, MalformedRecordException {
            this.recordSchema = recordSchema;
            try {
                this.jsonParser = new JsonFactory().createJsonParser(in);
                this.jsonParser.setCodec((ObjectCodec)new ObjectMapper());
                JsonToken token = this.jsonParser.nextToken();
                if (token == JsonToken.START_ARRAY) {
                    this.array = true;
                    token = this.jsonParser.nextToken();
                } else {
                    this.array = false;
                }
                this.firstJsonNode = token == JsonToken.START_OBJECT ? this.jsonParser.readValueAsTree() : null;
            }
            catch (JsonParseException e) {
                throw new MalformedRecordException("Could not parse data as JSON", (Throwable)e);
            }
        }

        public void close() throws IOException {
            this.jsonParser.close();
        }

        public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
            if (this.firstObjectConsumed && !this.array) {
                return null;
            }
            JsonNode nextNode = this.getNextJsonNode();
            if (nextNode == null) {
                return null;
            }
            try {
                return this.convertJsonNodeToRecord(nextNode, this.getSchema(), null, coerceTypes, dropUnknownFields);
            }
            catch (MalformedRecordException mre) {
                throw mre;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new MalformedRecordException("Failed to convert data into a Record object with the given schema", (Throwable)e);
            }
        }

        public RecordSchema getSchema() throws MalformedRecordException {
            return this.recordSchema;
        }

        private JsonNode getNextJsonNode() throws JsonParseException, IOException, MalformedRecordException {
            JsonToken token;
            if (!this.firstObjectConsumed) {
                this.firstObjectConsumed = true;
                return this.firstJsonNode;
            }
            block5: while (true) {
                if ((token = this.jsonParser.nextToken()) == null) {
                    return null;
                }
                switch (token) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case START_OBJECT: {
                        return this.jsonParser.readValueAsTree();
                    }
                    case END_ARRAY: 
                    case START_ARRAY: {
                        return null;
                    }
                }
                break;
            }
            throw new MalformedRecordException("Expected to get a JSON Object but got a token of type " + token.name());
        }

        private Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, String fieldNamePrefix, boolean coerceTypes, boolean dropUnknown) throws IOException, MalformedRecordException {
            HashMap<String, Object> values = new HashMap<String, Object>(schema.getFieldCount() * 2);
            if (dropUnknown) {
                for (RecordField recordField : schema.getFields()) {
                    Object value;
                    JsonNode childNode = this.getChildNode(jsonNode, recordField);
                    if (childNode == null) continue;
                    String fieldName = recordField.getFieldName();
                    if (coerceTypes) {
                        DataType desiredType = recordField.getDataType();
                        String fullFieldName = fieldNamePrefix == null ? fieldName : fieldNamePrefix + fieldName;
                        value = this.convertField(childNode, fullFieldName, desiredType, dropUnknown);
                    } else {
                        value = this.getRawNodeValue(childNode, recordField == null ? null : recordField.getDataType());
                    }
                    values.put(fieldName, value);
                }
            } else {
                Iterator fieldNames = jsonNode.getFieldNames();
                while (fieldNames.hasNext()) {
                    Object value;
                    String fieldName = (String)fieldNames.next();
                    JsonNode childNode = jsonNode.get(fieldName);
                    RecordField recordField = schema.getField(fieldName).orElse(null);
                    if (coerceTypes && recordField != null) {
                        DataType desiredType = recordField.getDataType();
                        String fullFieldName = fieldNamePrefix == null ? fieldName : fieldNamePrefix + fieldName;
                        value = this.convertField(childNode, fullFieldName, desiredType, dropUnknown);
                    } else {
                        value = this.getRawNodeValue(childNode, recordField == null ? null : recordField.getDataType());
                    }
                    values.put(fieldName, value);
                }
            }
            Supplier<String> supplier = () -> jsonNode.toString();
            return new MapRecord(schema, values, SerializedForm.of(supplier, (String)"application/json"), false, dropUnknown);
        }

        private JsonNode getChildNode(JsonNode jsonNode, RecordField field) {
            if (jsonNode.has(field.getFieldName())) {
                return jsonNode.get(field.getFieldName());
            }
            for (String alias : field.getAliases()) {
                if (!jsonNode.has(alias)) continue;
                return jsonNode.get(alias);
            }
            return null;
        }

        protected Object convertField(JsonNode fieldNode, String fieldName, DataType desiredType, boolean dropUnknown) throws IOException, MalformedRecordException {
            if (fieldNode == null || fieldNode.isNull()) {
                return null;
            }
            switch (desiredType.getFieldType()) {
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case BIGINT: 
                case LONG: 
                case SHORT: 
                case STRING: 
                case DATE: 
                case TIME: 
                case TIMESTAMP: {
                    Object rawValue = this.getRawNodeValue(fieldNode, null);
                    Object converted = DataTypeUtils.convertType((Object)rawValue, (DataType)desiredType, this.dateFormat, this.timeFormat, this.timestampFormat, (String)fieldName);
                    return converted;
                }
                case MAP: {
                    DataType valueType = ((MapDataType)desiredType).getValueType();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Iterator fieldNameItr = fieldNode.getFieldNames();
                    while (fieldNameItr.hasNext()) {
                        String childName = (String)fieldNameItr.next();
                        JsonNode childNode = fieldNode.get(childName);
                        Object childValue = this.convertField(childNode, fieldName, valueType, dropUnknown);
                        map.put(childName, childValue);
                    }
                    return map;
                }
                case ARRAY: {
                    ArrayNode arrayNode = (ArrayNode)fieldNode;
                    int numElements = arrayNode.size();
                    Object[] arrayElements = new Object[numElements];
                    int count = 0;
                    for (JsonNode node : arrayNode) {
                        DataType elementType = ((ArrayDataType)desiredType).getElementType();
                        Object converted = this.convertField(node, fieldName, elementType, dropUnknown);
                        arrayElements[count++] = converted;
                    }
                    return arrayElements;
                }
                case RECORD: {
                    if (fieldNode.isObject()) {
                        if (!(desiredType instanceof RecordDataType)) {
                            return null;
                        }
                        RecordSchema childSchema = ((RecordDataType)desiredType).getChildSchema();
                        if (childSchema == null) {
                            ArrayList<RecordField> fields = new ArrayList<RecordField>();
                            Iterator fieldNameItr = fieldNode.getFieldNames();
                            while (fieldNameItr.hasNext()) {
                                fields.add(new RecordField((String)fieldNameItr.next(), RecordFieldType.STRING.getDataType()));
                            }
                            childSchema = new SimpleRecordSchema(fields);
                        }
                        return this.convertJsonNodeToRecord(fieldNode, childSchema, fieldName + ".", true, dropUnknown);
                    }
                    return null;
                }
                case CHOICE: {
                    return DataTypeUtils.convertType((Object)this.getRawNodeValue(fieldNode, null), (DataType)desiredType, (String)fieldName);
                }
            }
            return null;
        }

        protected Object getRawNodeValue(JsonNode fieldNode, DataType dataType) throws IOException {
            if (fieldNode == null || fieldNode.isNull()) {
                return null;
            }
            if (fieldNode.isNumber()) {
                return fieldNode.getNumberValue();
            }
            if (fieldNode.isBinary()) {
                return fieldNode.getBinaryValue();
            }
            if (fieldNode.isBoolean()) {
                return fieldNode.getBooleanValue();
            }
            if (fieldNode.isTextual()) {
                return fieldNode.getTextValue();
            }
            if (fieldNode.isArray()) {
                DataType elementDataType;
                ArrayNode arrayNode = (ArrayNode)fieldNode;
                int numElements = arrayNode.size();
                Object[] arrayElements = new Object[numElements];
                int count = 0;
                if (dataType != null && dataType.getFieldType() == RecordFieldType.ARRAY) {
                    ArrayDataType arrayDataType = (ArrayDataType)dataType;
                    elementDataType = arrayDataType.getElementType();
                } else {
                    elementDataType = null;
                }
                for (JsonNode node : arrayNode) {
                    Object value = this.getRawNodeValue(node, elementDataType);
                    arrayElements[count++] = value;
                }
                return arrayElements;
            }
            if (fieldNode.isObject()) {
                SimpleRecordSchema childSchema;
                if (dataType != null && RecordFieldType.RECORD == dataType.getFieldType()) {
                    RecordDataType recordDataType = (RecordDataType)dataType;
                    childSchema = recordDataType.getChildSchema();
                } else {
                    childSchema = null;
                }
                if (childSchema == null) {
                    childSchema = new SimpleRecordSchema(Collections.emptyList());
                }
                Iterator fieldNames = fieldNode.getFieldNames();
                HashMap<String, Object> childValues = new HashMap<String, Object>();
                while (fieldNames.hasNext()) {
                    String childFieldName = (String)fieldNames.next();
                    Object childValue = this.getRawNodeValue(fieldNode.get(childFieldName), dataType);
                    childValues.put(childFieldName, childValue);
                }
                MapRecord record = new MapRecord((RecordSchema)childSchema, childValues);
                return record;
            }
            return null;
        }
    }

    static class NiFiUrlValidator
    implements Validator {
        NiFiUrlValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            String value = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
            try {
                SiteToSiteRestApiClient.parseClusterUrls((String)value);
                return new ValidationResult.Builder().input(input).subject(subject).valid(true).build();
            }
            catch (IllegalArgumentException ex) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation(ex.getLocalizedMessage()).build();
            }
        }
    }
}

