/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.snmp.processors.AbstractSNMPProcessor;
import org.apache.nifi.snmp.processors.SNMPGetter;
import org.apache.nifi.snmp.processors.SNMPUtils;
import org.snmp4j.PDU;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.util.TreeEvent;

@Tags(value={"snmp", "get", "oid", "walk"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Retrieves information from SNMP Agent and outputs a FlowFile with information in attributes and without any content")
@WritesAttributes(value={@WritesAttribute(attribute="snmp$*", description="Attributes retrieved from the SNMP response. It may include: snmp$errorIndex, snmp$errorStatus, snmp$errorStatusText, snmp$nonRepeaters, snmp$requestID, snmp$type, snmp$variableBindings"), @WritesAttribute(attribute="snmp$textualOid", description="This attribute will exist if and only if the strategy is GET and will be equal to the value given in Textual Oid property.")})
public class GetSNMP
extends AbstractSNMPProcessor<SNMPGetter> {
    public static final PropertyDescriptor OID = new PropertyDescriptor.Builder().name("snmp-oid").displayName("OID").description("The OID to request").required(true).addValidator(SNMPUtils.SNMP_OID_VALIDATOR).build();
    public static final PropertyDescriptor TEXTUAL_OID = new PropertyDescriptor.Builder().name("snmp-textual-oid").displayName("Textual OID").description("The textual OID to request").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue(null).build();
    public static final PropertyDescriptor SNMP_STRATEGY = new PropertyDescriptor.Builder().name("snmp-strategy").displayName("SNMP strategy (GET/WALK)").description("SNMP strategy to use (SNMP Get or SNMP Walk)").required(true).allowableValues(new String[]{"GET", "WALK"}).defaultValue("GET").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are received from the SNMP agent are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot received from the SNMP agent are routed to this relationship").build();
    private static final List<PropertyDescriptor> propertyDescriptors;
    private static final Set<Relationship> relationships;

    @Override
    protected void onTriggerSnmp(ProcessContext context, ProcessSession processSession) throws ProcessException {
        if ("GET".equals(context.getProperty(SNMP_STRATEGY).getValue())) {
            ResponseEvent response = ((SNMPGetter)this.targetResource).get();
            if (response.getResponse() != null) {
                FlowFile flowFile = processSession.create();
                PDU pdu = response.getResponse();
                flowFile = SNMPUtils.updateFlowFileAttributesWithPduProperties(pdu, flowFile, processSession);
                flowFile = SNMPUtils.addAttribute("snmp$textualOid", context.getProperty(TEXTUAL_OID).getValue(), flowFile, processSession);
                processSession.getProvenanceReporter().receive(flowFile, this.snmpTarget.getAddress().toString() + "/" + context.getProperty(OID).getValue());
                if (pdu.getErrorStatus() == 0) {
                    processSession.transfer(flowFile, REL_SUCCESS);
                } else {
                    processSession.transfer(flowFile, REL_FAILURE);
                }
            } else {
                this.getLogger().error("Get request timed out or parameters are incorrect.");
                context.yield();
            }
        } else if ("WALK".equals(context.getProperty(SNMP_STRATEGY).getValue())) {
            List<TreeEvent> events = ((SNMPGetter)this.targetResource).walk();
            if (events != null && !events.isEmpty() && events.get(0).getVariableBindings() != null) {
                FlowFile flowFile = processSession.create();
                for (TreeEvent treeEvent : events) {
                    flowFile = SNMPUtils.updateFlowFileAttributesWithTreeEventProperties(treeEvent, flowFile, processSession);
                }
                processSession.getProvenanceReporter().receive(flowFile, this.snmpTarget.getAddress().toString() + "/" + context.getProperty(OID).getValue());
                processSession.transfer(flowFile, REL_SUCCESS);
            } else {
                this.getLogger().error("Get request timed out or parameters are incorrect.");
                context.yield();
            }
        }
    }

    @Override
    protected SNMPGetter finishBuildingTargetResource(ProcessContext context) {
        String oid = context.getProperty(OID).getValue();
        return new SNMPGetter(this.snmp, this.snmpTarget, new OID(oid));
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    static {
        ArrayList<PropertyDescriptor> _propertyDescriptors = new ArrayList<PropertyDescriptor>();
        _propertyDescriptors.add(OID);
        _propertyDescriptors.add(TEXTUAL_OID);
        _propertyDescriptors.add(SNMP_STRATEGY);
        _propertyDescriptors.addAll(descriptors);
        propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

