/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TreeEvent;

abstract class SNMPUtils {
    private static final Logger logger = LoggerFactory.getLogger(SNMPUtils.class);
    public static final Pattern OID_PATTERN = Pattern.compile("[[0-9]+\\.]*");
    public static final String SNMP_PROP_DELIMITER = "$";
    public static final String SNMP_PROP_PREFIX = "snmp$";
    private static final List<String> propertyNames = Arrays.asList("snmp$errorIndex", "snmp$errorStatus", "snmp$errorStatusText", "snmp$nonRepeaters", "snmp$requestID", "snmp$type", "snmp$variableBindings");
    public static final Validator SNMP_OID_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.subject(subject).input(input);
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return builder.valid(true).explanation("Contains Expression Language").build();
            }
            try {
                if (OID_PATTERN.matcher(input).matches()) {
                    builder.valid(true);
                } else {
                    builder.valid(false).explanation(input + "is not a valid OID");
                }
            }
            catch (IllegalArgumentException e) {
                builder.valid(false).explanation(e.getMessage());
            }
            return builder.build();
        }
    };

    SNMPUtils() {
    }

    public static FlowFile updateFlowFileAttributesWithPduProperties(PDU response, FlowFile flowFile, ProcessSession processSession) {
        if (response != null) {
            try {
                Method[] methods = PDU.class.getDeclaredMethods();
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (Method method : methods) {
                    Object amqpPropertyValue;
                    String propertyName;
                    if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0 || !method.getName().startsWith("get") || !SNMPUtils.isValidSnmpPropertyName(propertyName = SNMPUtils.extractPropertyNameFromMethod(method)) || (amqpPropertyValue = method.invoke((Object)response, new Object[0])) == null) continue;
                    if (propertyName.equals("snmp$variableBindings") && amqpPropertyValue instanceof Vector) {
                        SNMPUtils.addGetOidValues(attributes, amqpPropertyValue);
                        continue;
                    }
                    attributes.put(propertyName, amqpPropertyValue.toString());
                }
                flowFile = processSession.putAllAttributes(flowFile, attributes);
            }
            catch (Exception e) {
                logger.warn("Failed to update FlowFile with AMQP attributes", (Throwable)e);
            }
        }
        return flowFile;
    }

    public static FlowFile addAttribute(String key, String value, FlowFile flowFile, ProcessSession processSession) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(key, value);
        flowFile = processSession.putAllAttributes(flowFile, attributes);
        return flowFile;
    }

    public static FlowFile updateFlowFileAttributesWithTreeEventProperties(TreeEvent treeEvent, FlowFile flowFile, ProcessSession processSession) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        SNMPUtils.addWalkOidValues(attributes, treeEvent.getVariableBindings());
        flowFile = processSession.putAllAttributes(flowFile, attributes);
        return flowFile;
    }

    private static void addWalkOidValues(Map<String, String> attributes, Object vector) {
        if (vector instanceof VariableBinding[]) {
            VariableBinding[] variables;
            for (VariableBinding variableBinding : variables = (VariableBinding[])vector) {
                SNMPUtils.addAttributeFromVariable(variableBinding, attributes);
            }
        }
    }

    private static void addGetOidValues(Map<String, String> attributes, Object vector) {
        if (vector instanceof Vector) {
            Vector variables = (Vector)vector;
            for (VariableBinding variableBinding : variables) {
                SNMPUtils.addAttributeFromVariable(variableBinding, attributes);
            }
        }
    }

    private static void addAttributeFromVariable(VariableBinding variableBinding, Map<String, String> attributes) {
        attributes.put(SNMP_PROP_PREFIX + variableBinding.getOid() + SNMP_PROP_DELIMITER + variableBinding.getVariable().getSyntax(), variableBinding.getVariable().toString());
    }

    public static boolean isValidSnmpPropertyName(String name) {
        return propertyNames.contains(name);
    }

    private static String extractPropertyNameFromMethod(Method method) {
        char[] c = method.getName().substring(3).toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return SNMP_PROP_PREFIX + new String(c);
    }

    public static OID getPriv(String privProtocol) {
        switch (privProtocol) {
            case "DES": {
                return PrivDES.ID;
            }
            case "3DES": {
                return Priv3DES.ID;
            }
            case "AES128": {
                return PrivAES128.ID;
            }
            case "AES192": {
                return PrivAES192.ID;
            }
            case "AES256": {
                return PrivAES256.ID;
            }
        }
        return null;
    }

    public static OID getAuth(String authProtocol) {
        switch (authProtocol) {
            case "SHA": {
                return AuthSHA.ID;
            }
            case "MD5": {
                return AuthMD5.ID;
            }
        }
        return null;
    }

    public static int getSecLevel(String level) {
        switch (level) {
            case "noAuthNoPriv": {
                return 1;
            }
            case "authNoPriv": {
                return 2;
            }
        }
        return 3;
    }
}

