/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.AbstractTarget;
import org.snmp4j.Snmp;

abstract class SNMPWorker
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SNMPWorker.class);
    protected final Snmp snmp;
    protected final AbstractTarget target;

    public SNMPWorker(Snmp snmp, AbstractTarget target) {
        this.snmp = snmp;
        this.target = target;
    }

    @Override
    public void close() throws TimeoutException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing SNMP connection");
        }
        this.snmp.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.snmp.toString();
    }
}

