/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.solr;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.SolrPortAwareCookieSpecFactory;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosHttpClientConfigurer
extends HttpClientConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private HttpRequestInterceptor bufferedEntityInterceptor = new HttpRequestInterceptor(){

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (request instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
                HttpEntity requestEntity = enclosingRequest.getEntity();
                enclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity(requestEntity));
            }
        }
    };

    public void configure(DefaultHttpClient httpClient, SolrParams config) {
        super.configure(httpClient, config);
        logger.info("Setting up SPNego auth...");
        AuthSchemeRegistry registry = new AuthSchemeRegistry();
        registry.register("Negotiate", (AuthSchemeFactory)new SPNegoSchemeFactory(true, false));
        httpClient.setAuthSchemes(registry);
        Credentials useJaasCreds = new Credentials(){

            public String getPassword() {
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }
        };
        SolrPortAwareCookieSpecFactory cookieFactory = new SolrPortAwareCookieSpecFactory();
        httpClient.getCookieSpecs().register("solr-portaware", (CookieSpecFactory)cookieFactory);
        httpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"solr-portaware");
        httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, useJaasCreds);
        httpClient.addRequestInterceptor(this.bufferedEntityInterceptor);
    }
}

