/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.solr;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.solr.SolrProcessor;
import org.apache.nifi.processors.solr.SolrUtils;
import org.apache.nifi.util.StopWatch;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;

@Tags(value={"Apache", "Solr", "Put", "Send"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Sends the contents of a FlowFile as a ContentStream to Solr")
@DynamicProperty(name="A Solr request parameter name", value="A Solr request parameter value", description="These parameters will be passed to Solr on the request")
public class PutSolrContentStream
extends SolrProcessor {
    public static final PropertyDescriptor CONTENT_STREAM_PATH = new PropertyDescriptor.Builder().name("Content Stream Path").description("The path in Solr to post the ContentStream").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("/update/json/docs").build();
    public static final PropertyDescriptor CONTENT_TYPE = new PropertyDescriptor.Builder().name("Content-Type").description("Content-Type being sent to Solr").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("application/json").build();
    public static final PropertyDescriptor COMMIT_WITHIN = new PropertyDescriptor.Builder().name("Commit Within").description("The number of milliseconds before the given update is committed").required(false).addValidator(StandardValidators.POSITIVE_LONG_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("5000").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The original FlowFile").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that failed for any reason other than Solr being unreachable").build();
    public static final Relationship REL_CONNECTION_FAILURE = new Relationship.Builder().name("connection_failure").description("FlowFiles that failed because Solr is unreachable").build();
    public static final String COLLECTION_PARAM_NAME = "collection";
    public static final String COMMIT_WITHIN_PARAM_NAME = "commitWithin";
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> descriptors;

    protected void init(ProcessorInitializationContext context) {
        super.init(context);
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(SolrUtils.SOLR_TYPE);
        descriptors.add(SolrUtils.SOLR_LOCATION);
        descriptors.add(SolrUtils.COLLECTION);
        descriptors.add(CONTENT_STREAM_PATH);
        descriptors.add(CONTENT_TYPE);
        descriptors.add(COMMIT_WITHIN);
        descriptors.add(SolrUtils.KERBEROS_CREDENTIALS_SERVICE);
        descriptors.add(SolrUtils.BASIC_USERNAME);
        descriptors.add(SolrUtils.BASIC_PASSWORD);
        descriptors.add(SolrUtils.SSL_CONTEXT_SERVICE);
        descriptors.add(SolrUtils.SOLR_SOCKET_TIMEOUT);
        descriptors.add(SolrUtils.SOLR_CONNECTION_TIMEOUT);
        descriptors.add(SolrUtils.SOLR_MAX_CONNECTIONS);
        descriptors.add(SolrUtils.SOLR_MAX_CONNECTIONS_PER_HOST);
        descriptors.add(SolrUtils.ZK_CLIENT_TIMEOUT);
        descriptors.add(SolrUtils.ZK_CONNECTION_TIMEOUT);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        relationships.add(REL_CONNECTION_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().description("Specifies the value to send for the '" + propertyDescriptorName + "' request parameter").name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    }

    @Override
    protected void doOnTrigger(final ProcessContext context, ProcessSession session) throws ProcessException {
        final FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        final AtomicReference<Object> error = new AtomicReference<Object>(null);
        final AtomicReference<Object> connectionError = new AtomicReference<Object>(null);
        final boolean isSolrCloud = SolrUtils.SOLR_TYPE_CLOUD.equals((Object)context.getProperty(SolrUtils.SOLR_TYPE).getValue());
        final String collection = context.getProperty(SolrUtils.COLLECTION).evaluateAttributeExpressions(flowFile).getValue();
        final Long commitWithin = context.getProperty(COMMIT_WITHIN).evaluateAttributeExpressions(flowFile).asLong();
        final String contentStreamPath = context.getProperty(CONTENT_STREAM_PATH).evaluateAttributeExpressions(flowFile).getValue();
        final MultiMapSolrParams requestParams = new MultiMapSolrParams(SolrUtils.getRequestParams(context, flowFile));
        StopWatch timer = new StopWatch(true);
        session.read(flowFile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                ContentStreamUpdateRequest request = new ContentStreamUpdateRequest(contentStreamPath);
                request.setParams(new ModifiableSolrParams());
                Iterator paramNames = requestParams.getParameterNamesIterator();
                while (paramNames.hasNext()) {
                    String paramName = (String)paramNames.next();
                    for (String paramValue : requestParams.getParams(paramName)) {
                        request.getParams().add(paramName, new String[]{paramValue});
                    }
                }
                if (isSolrCloud) {
                    request.setParam(PutSolrContentStream.COLLECTION_PARAM_NAME, collection);
                }
                if (commitWithin != null && commitWithin > 0L) {
                    request.setParam(PutSolrContentStream.COMMIT_WITHIN_PARAM_NAME, commitWithin.toString());
                }
                if (PutSolrContentStream.this.isBasicAuthEnabled()) {
                    request.setBasicAuthCredentials(PutSolrContentStream.this.getUsername(), PutSolrContentStream.this.getPassword());
                }
                try {
                    final BufferedInputStream bufferedIn = new BufferedInputStream(in);
                    Object object = null;
                    try {
                        request.addContentStream((ContentStream)new ContentStreamBase(){

                            public InputStream getStream() throws IOException {
                                return bufferedIn;
                            }

                            public String getContentType() {
                                return context.getProperty(CONTENT_TYPE).evaluateAttributeExpressions(flowFile).getValue();
                            }
                        });
                        UpdateResponse response = (UpdateResponse)request.process(PutSolrContentStream.this.getSolrClient());
                        PutSolrContentStream.this.getLogger().debug("Got {} response from Solr", new Object[]{response.getStatus()});
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (bufferedIn != null) {
                            if (object != null) {
                                try {
                                    bufferedIn.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                bufferedIn.close();
                            }
                        }
                    }
                }
                catch (SolrException e) {
                    error.set(e);
                }
                catch (SolrServerException e) {
                    if (PutSolrContentStream.this.causedByIOException(e)) {
                        connectionError.set(e);
                    } else {
                        error.set(e);
                    }
                }
                catch (IOException e) {
                    connectionError.set(e);
                }
            }
        });
        timer.stop();
        if (error.get() != null) {
            this.getLogger().error("Failed to send {} to Solr due to {}; routing to failure", new Object[]{flowFile, error.get()});
            session.transfer(flowFile, REL_FAILURE);
        } else if (connectionError.get() != null) {
            this.getLogger().error("Failed to send {} to Solr due to {}; routing to connection_failure", new Object[]{flowFile, connectionError.get()});
            session.penalize(flowFile);
            session.transfer(flowFile, REL_CONNECTION_FAILURE);
        } else {
            StringBuilder transitUri = new StringBuilder("solr://");
            transitUri.append(this.getSolrLocation());
            if (isSolrCloud) {
                transitUri.append(":").append(collection);
            }
            long duration = timer.getDuration(TimeUnit.MILLISECONDS);
            session.getProvenanceReporter().send(flowFile, transitUri.toString(), duration, true);
            this.getLogger().info("Successfully sent {} to Solr in {} millis", new Object[]{flowFile, duration});
            session.transfer(flowFile, REL_SUCCESS);
        }
    }

    private boolean causedByIOException(SolrServerException e) {
        boolean foundIOException = false;
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof IOException)) continue;
            foundIOException = true;
            break;
        }
        return foundIOException;
    }
}

