/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.solr;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.solr.KerberosHttpClientConfigurer;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.ListRecordSet;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(SolrUtils.class);
    public static final AllowableValue SOLR_TYPE_CLOUD = new AllowableValue("Cloud", "Cloud", "A SolrCloud instance.");
    public static final AllowableValue SOLR_TYPE_STANDARD = new AllowableValue("Standard", "Standard", "A stand-alone Solr instance.");
    public static final PropertyDescriptor RECORD_WRITER = new PropertyDescriptor.Builder().name("Record Writer").displayName("Record Writer").description("The Record Writer to use in order to write Solr documents to FlowFiles. Must be set if \"Records\" is used as return type.").identifiesControllerService(RecordSetWriterFactory.class).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    public static final PropertyDescriptor SOLR_TYPE = new PropertyDescriptor.Builder().name("Solr Type").description("The type of Solr instance, Cloud or Standard.").required(true).allowableValues(new AllowableValue[]{SOLR_TYPE_CLOUD, SOLR_TYPE_STANDARD}).defaultValue(SOLR_TYPE_STANDARD.getValue()).build();
    public static final PropertyDescriptor COLLECTION = new PropertyDescriptor.Builder().name("Collection").description("The Solr collection name, only used with a Solr Type of Cloud").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor SOLR_LOCATION = new PropertyDescriptor.Builder().name("Solr Location").description("The Solr url for a Solr Type of Standard (ex: http://localhost:8984/solr/gettingstarted), or the ZooKeeper hosts for a Solr Type of Cloud (ex: localhost:9983).").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor BASIC_USERNAME = new PropertyDescriptor.Builder().name("Username").description("The username to use when Solr is configured with basic authentication.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor BASIC_PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password to use when Solr is configured with basic authentication.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(true).build();
    static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context. This property must be set when communicating with a Solr over https.").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor SOLR_SOCKET_TIMEOUT = new PropertyDescriptor.Builder().name("Solr Socket Timeout").description("The amount of time to wait for data on a socket connection to Solr. A value of 0 indicates an infinite timeout.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("10 seconds").build();
    public static final PropertyDescriptor SOLR_CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("Solr Connection Timeout").description("The amount of time to wait when establishing a connection to Solr. A value of 0 indicates an infinite timeout.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("10 seconds").build();
    public static final PropertyDescriptor SOLR_MAX_CONNECTIONS = new PropertyDescriptor.Builder().name("Solr Maximum Connections").description("The maximum number of total connections allowed from the Solr client to Solr.").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("10").build();
    public static final PropertyDescriptor SOLR_MAX_CONNECTIONS_PER_HOST = new PropertyDescriptor.Builder().name("Solr Maximum Connections Per Host").description("The maximum number of connections allowed from the Solr client to a single Solr host.").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("5").build();
    public static final PropertyDescriptor ZK_CLIENT_TIMEOUT = new PropertyDescriptor.Builder().name("ZooKeeper Client Timeout").description("The amount of time to wait for data on a connection to ZooKeeper, only used with a Solr Type of Cloud.").required(false).addValidator(StandardValidators.createTimePeriodValidator((long)1L, (TimeUnit)TimeUnit.SECONDS, (long)Integer.MAX_VALUE, (TimeUnit)TimeUnit.SECONDS)).defaultValue("10 seconds").build();
    public static final PropertyDescriptor ZK_CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("ZooKeeper Connection Timeout").description("The amount of time to wait when establishing a connection to ZooKeeper, only used with a Solr Type of Cloud.").required(false).addValidator(StandardValidators.createTimePeriodValidator((long)1L, (TimeUnit)TimeUnit.SECONDS, (long)Integer.MAX_VALUE, (TimeUnit)TimeUnit.SECONDS)).defaultValue("10 seconds").build();
    public static final String REPEATING_PARAM_PATTERN = "[\\w\\.]+\\.\\d+$";

    public static SolrClient createSolrClient(PropertyContext context, String solrLocation) {
        Integer socketTimeout = context.getProperty(SOLR_SOCKET_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        Integer connectionTimeout = context.getProperty(SOLR_CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        Integer maxConnections = context.getProperty(SOLR_MAX_CONNECTIONS).asInteger();
        Integer maxConnectionsPerHost = context.getProperty(SOLR_MAX_CONNECTIONS_PER_HOST).asInteger();
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("socketTimeout", socketTimeout.intValue());
        params.set("connTimeout", connectionTimeout.intValue());
        params.set("maxConnections", maxConnections.intValue());
        params.set("maxConnectionsPerHost", maxConnectionsPerHost.intValue());
        if (kerberosCredentialsService != null) {
            HttpClientUtil.setConfigurer((HttpClientConfigurer)new KerberosHttpClientConfigurer());
        }
        CloseableHttpClient httpClient = HttpClientUtil.createClient((SolrParams)params);
        if (sslContextService != null) {
            SSLContext sslContext = sslContextService.createSSLContext(SSLContextService.ClientAuth.REQUIRED);
            SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext);
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
            httpClient.getConnectionManager().getSchemeRegistry().register(httpsScheme);
        }
        if (SOLR_TYPE_STANDARD.getValue().equals(context.getProperty(SOLR_TYPE).getValue())) {
            return new HttpSolrClient(solrLocation, (HttpClient)httpClient);
        }
        String collection = context.getProperty(COLLECTION).evaluateAttributeExpressions().getValue();
        Integer zkClientTimeout = context.getProperty(ZK_CLIENT_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        Integer zkConnectionTimeout = context.getProperty(ZK_CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        CloudSolrClient cloudSolrClient = new CloudSolrClient(solrLocation, (HttpClient)httpClient);
        cloudSolrClient.setDefaultCollection(collection);
        cloudSolrClient.setZkClientTimeout(zkClientTimeout.intValue());
        cloudSolrClient.setZkConnectTimeout(zkConnectionTimeout.intValue());
        return cloudSolrClient;
    }

    public static RecordSet solrDocumentsToRecordSet(List<SolrDocument> docs, RecordSchema schema) {
        ArrayList<MapRecord> lr = new ArrayList<MapRecord>();
        for (SolrDocument doc : docs) {
            LinkedHashMap<String, Object> recordValues = new LinkedHashMap<String, Object>();
            for (RecordField field : schema.getFields()) {
                Object fieldValue = doc.getFieldValue(field.getFieldName());
                if (fieldValue == null) continue;
                if (field.getDataType().getFieldType().equals((Object)RecordFieldType.ARRAY)) {
                    recordValues.put(field.getFieldName(), ((List)fieldValue).toArray());
                    continue;
                }
                recordValues.put(field.getFieldName(), fieldValue);
            }
            lr.add(new MapRecord(schema, recordValues));
        }
        return new ListRecordSet(schema, lr);
    }

    public static OutputStreamCallback getOutputStreamCallbackToTransformSolrResponseToXml(QueryResponse response) {
        return new QueryResponseOutputStreamCallback(response);
    }

    public static Map<String, String[]> getRequestParams(ProcessContext context, FlowFile flowFile) {
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        TreeMap<String, String> repeatingParams = new TreeMap<String, String>();
        for (Map.Entry entry : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (!descriptor.isDynamic()) continue;
            String paramName = descriptor.getName();
            String paramValue = context.getProperty(descriptor).evaluateAttributeExpressions(flowFile).getValue();
            if (paramValue.trim().isEmpty()) continue;
            if (paramName.matches(REPEATING_PARAM_PATTERN)) {
                repeatingParams.put(paramName, paramValue);
                continue;
            }
            MultiMapSolrParams.addParam((String)paramName, (String)paramValue, paramsMap);
        }
        for (Map.Entry entry : repeatingParams.entrySet()) {
            String paramName = (String)entry.getKey();
            String paramValue = (String)entry.getValue();
            int idx = paramName.lastIndexOf(".");
            MultiMapSolrParams.addParam((String)paramName.substring(0, idx), (String)paramValue, paramsMap);
        }
        return paramsMap;
    }

    public static void writeRecord(Record record, SolrInputDocument inputDocument, List<String> fieldsToIndex, String parentFieldName) throws IOException {
        RecordSchema schema = record.getSchema();
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            RecordField field = schema.getField(i);
            String fieldName = !StringUtils.isBlank((CharSequence)parentFieldName) ? parentFieldName + "_" + field.getFieldName() : field.getFieldName();
            Object value = record.getValue(field);
            if (value == null) continue;
            DataType dataType = (DataType)schema.getDataType(field.getFieldName()).get();
            SolrUtils.writeValue(inputDocument, value, fieldName, dataType, fieldsToIndex);
        }
    }

    private static void writeValue(SolrInputDocument inputDocument, Object value, String fieldName, DataType dataType, List<String> fieldsToIndex) throws IOException {
        DataType chosenDataType = dataType.getFieldType() == RecordFieldType.CHOICE ? DataTypeUtils.chooseDataType((Object)value, (ChoiceDataType)((ChoiceDataType)dataType)) : dataType;
        Object coercedValue = DataTypeUtils.convertType((Object)value, (DataType)chosenDataType, (String)fieldName);
        if (coercedValue == null) {
            return;
        }
        switch (chosenDataType.getFieldType()) {
            case DATE: {
                String stringValue = DataTypeUtils.toString((Object)coercedValue, () -> DataTypeUtils.getDateFormat((String)RecordFieldType.DATE.getDefaultFormat()));
                if (DataTypeUtils.isLongTypeCompatible((Object)stringValue)) {
                    LocalDate localDate = SolrUtils.getLocalDateFromEpochTime(fieldName, coercedValue);
                    SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, localDate.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + 'Z', fieldsToIndex);
                    break;
                }
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, LocalDate.parse(stringValue).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + 'Z', fieldsToIndex);
                break;
            }
            case TIMESTAMP: {
                String stringValue = DataTypeUtils.toString((Object)coercedValue, () -> DataTypeUtils.getDateFormat((String)RecordFieldType.TIMESTAMP.getDefaultFormat()));
                if (DataTypeUtils.isLongTypeCompatible((Object)stringValue)) {
                    LocalDateTime localDateTime = SolrUtils.getLocalDateTimeFromEpochTime(fieldName, coercedValue);
                    SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + 'Z', fieldsToIndex);
                    break;
                }
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, LocalDateTime.parse(stringValue).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + 'Z', fieldsToIndex);
                break;
            }
            case DOUBLE: {
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, DataTypeUtils.toDouble((Object)coercedValue, (String)fieldName), fieldsToIndex);
                break;
            }
            case FLOAT: {
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, DataTypeUtils.toFloat((Object)coercedValue, (String)fieldName), fieldsToIndex);
                break;
            }
            case LONG: {
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, DataTypeUtils.toLong((Object)coercedValue, (String)fieldName), fieldsToIndex);
                break;
            }
            case INT: 
            case BYTE: 
            case SHORT: {
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, DataTypeUtils.toInteger((Object)coercedValue, (String)fieldName), fieldsToIndex);
                break;
            }
            case CHAR: 
            case STRING: {
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, coercedValue.toString(), fieldsToIndex);
                break;
            }
            case BIGINT: {
                if (coercedValue instanceof Long) {
                    SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, (Long)coercedValue, fieldsToIndex);
                    break;
                }
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, (BigInteger)coercedValue, fieldsToIndex);
                break;
            }
            case BOOLEAN: {
                String stringValue = coercedValue.toString();
                if ("true".equalsIgnoreCase(stringValue)) {
                    SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, true, fieldsToIndex);
                    break;
                }
                if ("false".equalsIgnoreCase(stringValue)) {
                    SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, false, fieldsToIndex);
                    break;
                }
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, stringValue, fieldsToIndex);
                break;
            }
            case RECORD: {
                Record record = (Record)coercedValue;
                SolrUtils.writeRecord(record, inputDocument, fieldsToIndex, fieldName);
                break;
            }
            default: {
                if (coercedValue instanceof Object[]) {
                    Object[] values;
                    for (Object element : values = (Object[])coercedValue) {
                        if (element instanceof Record) {
                            SolrUtils.writeRecord((Record)element, inputDocument, fieldsToIndex, fieldName);
                            continue;
                        }
                        SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, coercedValue.toString(), fieldsToIndex);
                    }
                    break;
                }
                SolrUtils.addFieldToSolrDocument(inputDocument, fieldName, coercedValue.toString(), fieldsToIndex);
            }
        }
    }

    private static void addFieldToSolrDocument(SolrInputDocument inputDocument, String fieldName, Object fieldValue, List<String> fieldsToIndex) {
        if (!fieldsToIndex.isEmpty() && fieldsToIndex.contains(fieldName) || fieldsToIndex.isEmpty()) {
            inputDocument.addField(fieldName, fieldValue);
        }
    }

    private static LocalDate getLocalDateFromEpochTime(String fieldName, Object coercedValue) {
        Long date = DataTypeUtils.toLong((Object)coercedValue, (String)fieldName);
        return Instant.ofEpochMilli(date).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static LocalDateTime getLocalDateTimeFromEpochTime(String fieldName, Object coercedValue) {
        Long date = DataTypeUtils.toLong((Object)coercedValue, (String)fieldName);
        return Instant.ofEpochMilli(date).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private static class QueryResponseOutputStreamCallback
    implements OutputStreamCallback {
        private QueryResponse response;

        public QueryResponseOutputStreamCallback(QueryResponse response) {
            this.response = response;
        }

        public void process(OutputStream out) throws IOException {
            IOUtils.write((String)"<docs>", (OutputStream)out, (Charset)StandardCharsets.UTF_8);
            for (SolrDocument doc : this.response.getResults()) {
                String xml = ClientUtils.toXML((SolrInputDocument)this.toSolrInputDocument(doc));
                IOUtils.write((String)xml, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
            }
            IOUtils.write((String)"</docs>", (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }

        public SolrInputDocument toSolrInputDocument(SolrDocument d) {
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            for (String name : d.getFieldNames()) {
                doc.addField(name, d.getFieldValue(name));
            }
            return doc;
        }
    }
}

