/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.annotation.CapabilityDescription;
import org.apache.nifi.processor.annotation.OnScheduled;
import org.apache.nifi.processor.annotation.SupportsBatching;
import org.apache.nifi.processor.annotation.Tags;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;

@SupportsBatching
@Tags(value={"test", "random", "generate"})
@CapabilityDescription(value="This processor creates FlowFiles of random data and is used for load testing")
public class GenerateFlowFile
extends AbstractProcessor {
    private final AtomicReference<byte[]> data = new AtomicReference();
    public static final String DATA_FORMAT_BINARY = "Binary";
    public static final String DATA_FORMAT_TEXT = "Text";
    public static final PropertyDescriptor FILE_SIZE = new PropertyDescriptor.Builder().name("File Size").description("The size of the file that will be used").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The number of FlowFiles to be transferred in each invocation").required(true).defaultValue("1").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor DATA_FORMAT = new PropertyDescriptor.Builder().name("Data Format").description("Specifies whether the data should be Text or Binary").required(true).defaultValue("Binary").allowableValues(new String[]{"Binary", "Text"}).build();
    public static final PropertyDescriptor UNIQUE_FLOWFILES = new PropertyDescriptor.Builder().name("Unique FlowFiles").description("If true, each FlowFile that is generated will be unique. If false, a random value will be generated and all FlowFiles will get the same content but this offers much higher throughput").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final Relationship SUCCESS = new Relationship.Builder().name("success").build();
    private List<PropertyDescriptor> descriptors;
    private Set<Relationship> relationships;
    private static final char[] TEXT_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()-_=+/?.,';:\"?<>\n\t ".toCharArray();

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(FILE_SIZE);
        descriptors.add(BATCH_SIZE);
        descriptors.add(DATA_FORMAT);
        descriptors.add(UNIQUE_FLOWFILES);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        if (context.getProperty(UNIQUE_FLOWFILES).asBoolean().booleanValue()) {
            this.data.set(null);
        } else {
            this.data.set(this.generateData(context));
        }
    }

    private byte[] generateData(ProcessContext context) {
        int byteCount = context.getProperty(FILE_SIZE).asDataSize(DataUnit.B).intValue();
        Random random = new Random();
        byte[] array = new byte[byteCount];
        if (context.getProperty(DATA_FORMAT).getValue().equals(DATA_FORMAT_BINARY)) {
            random.nextBytes(array);
        } else {
            for (int i = 0; i < array.length; ++i) {
                int index = random.nextInt(TEXT_CHARS.length);
                array[i] = (byte)TEXT_CHARS[index];
            }
        }
        return array;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        final byte[] data = context.getProperty(UNIQUE_FLOWFILES).asBoolean() != false ? this.generateData(context) : this.data.get();
        for (int i = 0; i < context.getProperty(BATCH_SIZE).asInteger(); ++i) {
            FlowFile flowFile = session.create();
            if (data.length > 0) {
                flowFile = session.write(flowFile, new OutputStreamCallback(){

                    public void process(OutputStream out) throws IOException {
                        out.write(data);
                    }
                });
            }
            session.getProvenanceReporter().create(flowFile);
            session.transfer(flowFile, SUCCESS);
        }
    }
}

