/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jms.JMSException;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.annotation.CapabilityDescription;
import org.apache.nifi.processor.annotation.OnStopped;
import org.apache.nifi.processor.annotation.Tags;
import org.apache.nifi.processor.annotation.TriggerWhenEmpty;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.JmsConsumer;
import org.apache.nifi.processors.standard.util.JmsFactory;
import org.apache.nifi.processors.standard.util.WrappedMessageConsumer;

@TriggerWhenEmpty
@Tags(value={"jms", "queue", "listen", "get", "pull", "source", "consume", "consumer"})
@CapabilityDescription(value="Pulls messages from a JMS Queue, creating a FlowFile for each JMS Message or bundle of messages, as configured")
public class GetJMSQueue
extends JmsConsumer {
    private final Queue<WrappedMessageConsumer> consumerQueue = new LinkedBlockingQueue<WrappedMessageConsumer>();

    @OnStopped
    public void cleanupResources() {
        WrappedMessageConsumer wrappedConsumer = this.consumerQueue.poll();
        while (wrappedConsumer != null) {
            wrappedConsumer.close(this.getLogger());
            wrappedConsumer = this.consumerQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ProcessorLog logger = this.getLogger();
        WrappedMessageConsumer wrappedConsumer = this.consumerQueue.poll();
        if (wrappedConsumer == null) {
            try {
                wrappedConsumer = JmsFactory.createQueueMessageConsumer(context);
            }
            catch (JMSException e) {
                logger.error("Failed to connect to JMS Server due to {}", (Throwable)e);
                context.yield();
                return;
            }
        }
        try {
            super.consume(context, session, wrappedConsumer);
        }
        finally {
            if (!wrappedConsumer.isClosed()) {
                this.consumerQueue.offer(wrappedConsumer);
            }
        }
    }
}

