/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.annotation.CapabilityDescription;
import org.apache.nifi.processor.annotation.EventDriven;
import org.apache.nifi.processor.annotation.SideEffectFree;
import org.apache.nifi.processor.annotation.SupportsBatching;
import org.apache.nifi.processor.annotation.Tags;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.util.FlowFilePackagerV3;
import org.apache.nifi.util.ObjectHolder;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"compression", "gzip", "bzip2", "zip", "MIME", "mime.type", "file", "identify"})
@CapabilityDescription(value="Attempts to identify the MIME Type used for a FlowFile. If the MIME Type can be identified, an attribute with the name 'mime.type' is added with the value being the MIME Type. If the MIME Type cannot be determined, the value will be set to 'application/octet-stream'. Some MIME Types require reading a significant amount of data; for these MIME Types, their identification is optional. The algorithm may have to read the entire contents of the file for each type of identification.")
public class IdentifyMimeType
extends AbstractProcessor {
    public static final PropertyDescriptor IDENTIFY_ZIP = new PropertyDescriptor.Builder().name("Identify ZIP").description("Determines whether or not to attempt in depth identification of ZIP MIME types").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor IDENTIFY_TAR = new PropertyDescriptor.Builder().name("Identify TAR").description("Determines whether or not to attempt in depth identification of TAR MIME types").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles are routed to success").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final List<MagicHeader> magicHeaders;
    private final List<MagicHeader> zipMagicHeaders;
    private final List<MagicHeader> tarMagicHeaders;
    private final List<ContentScanningMimeTypeIdentifier> contentScanners;
    private final int magicHeaderMaxLength;

    public IdentifyMimeType() {
        ArrayList<MagicHeader> headers = new ArrayList<MagicHeader>();
        headers.add(new SimpleMagicHeader("application/gzip", new byte[]{31, -117}));
        headers.add(new SimpleMagicHeader("application/bzip2", new byte[]{66, 90}));
        headers.add(new SimpleMagicHeader("application/flowfile-v3", FlowFilePackagerV3.MAGIC_HEADER));
        headers.add(new SimpleMagicHeader("application/xml", new byte[]{60, 63, 120, 109, 108, 32}));
        headers.add(new SimpleMagicHeader("video/mp4", new byte[]{0, 0, 0, 20, 102, 116, 121, 112, 105, 115, 111, 109}));
        headers.add(new SimpleMagicHeader("video/mp4", new byte[]{0, 0, 0, 20, 102, 116, 121, 112, 51, 103, 112, 53}));
        headers.add(new SimpleMagicHeader("video/mp4", new byte[]{0, 0, 0, 20, 102, 116, 121, 112, 77, 83, 78, 86, 1, 41, 0, 70, 77, 83, 78, 86, 109, 112, 52, 50}));
        headers.add(new SimpleMagicHeader("video/x-m4v", new byte[]{0, 0, 0, 24, 102, 116, 121, 112, 109, 112, 52, 50}));
        headers.add(new SimpleMagicHeader("video/mp4a-latm", new byte[]{0, 0, 0, 24, 102, 116, 121, 112, 77, 52, 65, 32}));
        headers.add(new SimpleMagicHeader("video/quicktime", new byte[]{0, 0, 0, 20, 102, 116, 121, 112, 113, 116, 32, 32}));
        headers.add(new SimpleMagicHeader("video/quicktime", new byte[]{109, 111, 111, 118}, 4));
        headers.add(new SimpleMagicHeader("audio/mp3", new byte[]{73, 68, 51}));
        headers.add(new SimpleMagicHeader("image/bmp", new byte[]{66, 77}));
        headers.add(new SimpleMagicHeader("image/png", new byte[]{-119, 80, 78, 71, 13, 10, 26, 10}));
        headers.add(new SimpleMagicHeader("image/jpg", new byte[]{-1, -40, -1}));
        headers.add(new SimpleMagicHeader("image/gif", new byte[]{71, 73, 70, 56, 55, 97}));
        headers.add(new SimpleMagicHeader("image/gif", new byte[]{71, 73, 70, 56, 57, 97}));
        headers.add(new SimpleMagicHeader("image/tif", new byte[]{73, 32, 73}));
        headers.add(new SimpleMagicHeader("image/tif", new byte[]{73, 73, 42, 0}));
        headers.add(new SimpleMagicHeader("image/tif", new byte[]{77, 77, 0, 42}));
        headers.add(new SimpleMagicHeader("image/tif", new byte[]{77, 77, 0, 43}));
        headers.add(new SimpleMagicHeader("application/vnd.ms-works", new byte[]{-1, 0, 2, 0, 4, 4, 5, 84, 2, 0}));
        headers.add(new SimpleMagicHeader("application/msexcel", new byte[]{9, 8, 16, 0, 0, 6, 5, 0}, 512));
        headers.add(new SimpleMagicHeader("application/mspowerpoint", new byte[]{0, 110, 30, -16}, 512));
        headers.add(new SimpleMagicHeader("application/mspowerpoint", new byte[]{15, 0, -24, 3}, 512));
        headers.add(new SimpleMagicHeader("application/mspowerpoint", new byte[]{-96, 70, 29, -16}, 512));
        headers.add(new CompoundMagicHeader("application/mspowerpoint", new SimpleMagicHeader("", new byte[]{-3, -1, -1, -1}, 512), new SimpleMagicHeader("", new byte[]{0, 0, 0}, 517)));
        headers.add(new SimpleMagicHeader("application/msaccess", new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 65, 67, 69, 32, 68, 66}));
        headers.add(new SimpleMagicHeader("application/msaccess", new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116, 32, 68, 66}));
        for (byte b : new byte[]{16, 31, 34, 35, 40, 41}) {
            headers.add(new SimpleMagicHeader("application/msaccess", new byte[]{-3, -1, -1, -1, b, 0}, 512));
            headers.add(new SimpleMagicHeader("application/msaccess", new byte[]{-3, -1, -1, -1, b, 2}, 512));
        }
        headers.add(new SimpleMagicHeader("application/x-ms-wmv", new byte[]{48, 38, -78, 117, -114, 102, -49, 17, -90, -39, 0, -86, 0, 98, -50, 108}));
        headers.add(new SimpleMagicHeader("application/pdf", new byte[]{37, 80, 68, 70}));
        headers.add(new SimpleMagicHeader("application/x-rpm", new byte[]{-19, -85, -18, -37}));
        headers.add(new SimpleMagicHeader("application/x-7z-compressed", new byte[]{55, 122, -68, -81, 39, 28}));
        headers.add(new SimpleMagicHeader("application/java-archive", new byte[]{74, 65, 82, 67, 83, 0}));
        headers.add(new SimpleMagicHeader("application/java-archive", new byte[]{80, 75, 3, 4, 20, 0, 8}));
        headers.add(new SimpleMagicHeader("application/java-archive", new byte[]{80, 75, 3, 4, -96, 0, 0}));
        headers.add(new SimpleMagicHeader("application/x-lzh", new byte[]{45, 108, 104}, 2));
        headers.add(new CompoundMagicHeader("audio/wav", new SimpleMagicHeader("", new byte[]{82, 73, 70, 70}), new SimpleMagicHeader("", new byte[]{87, 65, 86, 69, 102, 109, 116, 32}, 8)));
        for (int nibble = 176; nibble <= 191; ++nibble) {
            headers.add(new SimpleMagicHeader("video/mpeg", new byte[]{0, 0, 1, (byte)nibble}));
        }
        this.magicHeaders = Collections.unmodifiableList(headers);
        ArrayList<SimpleMagicHeader> zipHeaders = new ArrayList<SimpleMagicHeader>();
        zipHeaders.add(new SimpleMagicHeader("application/zip", new byte[]{80, 75, 3, 4}));
        this.zipMagicHeaders = Collections.unmodifiableList(zipHeaders);
        ArrayList<SimpleMagicHeader> tarHeaders = new ArrayList<SimpleMagicHeader>();
        tarHeaders.add(new SimpleMagicHeader("application/tar", new byte[]{117, 115, 116, 97, 114}, 257));
        this.tarMagicHeaders = Collections.unmodifiableList(tarHeaders);
        int max = 0;
        for (MagicHeader header : this.magicHeaders) {
            max = Math.max(max, header.getRequiredBufferLength());
        }
        for (MagicHeader header : this.zipMagicHeaders) {
            max = Math.max(max, header.getRequiredBufferLength());
        }
        for (MagicHeader header : this.tarMagicHeaders) {
            max = Math.max(max, header.getRequiredBufferLength());
        }
        this.magicHeaderMaxLength = max;
        ArrayList<ContentScanningMimeTypeIdentifier> scanningIdentifiers = new ArrayList<ContentScanningMimeTypeIdentifier>();
        scanningIdentifiers.add(new ZipIdentifier());
        scanningIdentifiers.add(new TarIdentifier());
        this.contentScanners = Collections.unmodifiableList(scanningIdentifiers);
    }

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(IDENTIFY_ZIP);
        properties.add(IDENTIFY_TAR);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        final boolean identifyZip = context.getProperty(IDENTIFY_ZIP).asBoolean();
        final boolean identifyTar = context.getProperty(IDENTIFY_TAR).asBoolean();
        final ObjectHolder mimeTypeRef = new ObjectHolder(null);
        session.read(flowFile, new InputStreamCallback(){

            public void process(InputStream stream) throws IOException {
                block28: {
                    try (BufferedInputStream in = new BufferedInputStream(stream);){
                        ((InputStream)in).mark(IdentifyMimeType.this.magicHeaderMaxLength);
                        byte[] header = new byte[IdentifyMimeType.this.magicHeaderMaxLength];
                        for (int i = 0; i < header.length; ++i) {
                            int next = ((InputStream)in).read();
                            if (next >= 0) {
                                header[i] = (byte)next;
                                continue;
                            }
                            if (i == 0) {
                                header = new byte[]{};
                                continue;
                            }
                            byte[] newBuffer = new byte[i - 1];
                            System.arraycopy(header, 0, newBuffer, 0, i - 1);
                            header = newBuffer;
                            break;
                        }
                        ((InputStream)in).reset();
                        for (MagicHeader magicHeader : IdentifyMimeType.this.magicHeaders) {
                            if (!magicHeader.matches(header)) continue;
                            mimeTypeRef.set((Object)magicHeader.getMimeType());
                            return;
                        }
                        if (!identifyZip) {
                            for (MagicHeader magicHeader : IdentifyMimeType.this.zipMagicHeaders) {
                                if (!magicHeader.matches(header)) continue;
                                mimeTypeRef.set((Object)magicHeader.getMimeType());
                                return;
                            }
                        }
                        if (identifyTar) break block28;
                        for (MagicHeader magicHeader : IdentifyMimeType.this.tarMagicHeaders) {
                            if (!magicHeader.matches(header)) continue;
                            mimeTypeRef.set((Object)magicHeader.getMimeType());
                            return;
                        }
                    }
                }
            }
        });
        String mimeType = (String)mimeTypeRef.get();
        if (mimeType == null) {
            for (final ContentScanningMimeTypeIdentifier scanningIdentifier : this.contentScanners) {
                if (!scanningIdentifier.isEnabled(context)) continue;
                session.read(flowFile, new InputStreamCallback(){

                    public void process(InputStream in) throws IOException {
                        String mimeType = scanningIdentifier.getMimeType(in);
                        if (mimeType != null) {
                            mimeTypeRef.set((Object)mimeType);
                        }
                    }
                });
                if (mimeTypeRef.get() == null) continue;
                break;
            }
        }
        if ((mimeType = (String)mimeTypeRef.get()) == null) {
            flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), "application/octet-stream");
            logger.info("Unable to identify MIME Type for {}; setting to application/octet-stream", new Object[]{flowFile});
        } else {
            flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), mimeType);
            logger.info("Identified {} as having MIME Type {}", new Object[]{flowFile, mimeType});
        }
        session.getProvenanceReporter().modifyAttributes(flowFile);
        session.transfer(flowFile, REL_SUCCESS);
    }

    private static class CompoundMagicHeader
    implements MagicHeader {
        private final MagicHeader[] headers;
        private final int requiredLength;
        private final String mimeType;

        public CompoundMagicHeader(String mimeType, MagicHeader ... headers) {
            this.mimeType = mimeType;
            this.headers = headers;
            int max = 0;
            for (MagicHeader header : headers) {
                max = Math.max(max, header.getRequiredBufferLength());
            }
            this.requiredLength = max;
        }

        @Override
        public int getRequiredBufferLength() {
            return this.requiredLength;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public boolean matches(byte[] header) {
            for (MagicHeader mh : this.headers) {
                if (mh.matches(header)) continue;
                return false;
            }
            return true;
        }
    }

    private static class SimpleMagicHeader
    implements MagicHeader {
        private final String mimeType;
        private final int offset;
        private final byte[] byteSequence;

        public SimpleMagicHeader(String mimeType, byte[] byteSequence) {
            this(mimeType, byteSequence, 0);
        }

        public SimpleMagicHeader(String mimeType, byte[] byteSequence, int offset) {
            this.mimeType = mimeType;
            this.byteSequence = byteSequence;
            this.offset = offset;
        }

        @Override
        public int getRequiredBufferLength() {
            return this.byteSequence.length + this.offset;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public boolean matches(byte[] header) {
            if (header.length < this.getRequiredBufferLength()) {
                return false;
            }
            for (int i = 0; i < this.byteSequence.length; ++i) {
                if (this.byteSequence[i] == header[this.offset + i]) continue;
                return false;
            }
            return true;
        }
    }

    private static interface MagicHeader {
        public int getRequiredBufferLength();

        public String getMimeType();

        public boolean matches(byte[] var1);
    }

    private static class TarIdentifier
    implements ContentScanningMimeTypeIdentifier {
        private TarIdentifier() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String getMimeType(InputStream in) throws IOException {
            try (TarArchiveInputStream tarIn = new TarArchiveInputStream(in);){
                TarArchiveEntry secondEntry;
                TarArchiveEntry firstEntry = tarIn.getNextTarEntry();
                if (firstEntry == null) return null;
                if (firstEntry.getName().equals("flowfile.attributes") && (secondEntry = tarIn.getNextTarEntry()) != null && secondEntry.getName().equals("flowfile.content")) {
                    String string = "application/flowfile-v1";
                    return string;
                }
                String string = "application/tar";
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public boolean isEnabled(ProcessContext context) {
            return context.getProperty(IDENTIFY_TAR).asBoolean();
        }
    }

    private static class ZipIdentifier
    implements ContentScanningMimeTypeIdentifier {
        private ZipIdentifier() {
        }

        @Override
        public String getMimeType(InputStream in) throws IOException {
            ZipInputStream zipIn = new ZipInputStream(in);
            try {
                if (zipIn.getNextEntry() != null) {
                    return "application/zip";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public boolean isEnabled(ProcessContext context) {
            return context.getProperty(IDENTIFY_ZIP).asBoolean();
        }
    }

    private static interface ContentScanningMimeTypeIdentifier {
        public boolean isEnabled(ProcessContext var1);

        public String getMimeType(InputStream var1) throws IOException;
    }
}

