/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.EntityUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.annotation.CapabilityDescription;
import org.apache.nifi.processor.annotation.OnScheduled;
import org.apache.nifi.processor.annotation.OnStopped;
import org.apache.nifi.processor.annotation.SupportsBatching;
import org.apache.nifi.processor.annotation.Tags;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.stream.io.GZIPOutputStream;
import org.apache.nifi.stream.io.LeakyBucketStreamThrottler;
import org.apache.nifi.stream.io.StreamThrottler;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.FlowFilePackagerV1;
import org.apache.nifi.util.FlowFilePackagerV2;
import org.apache.nifi.util.FlowFilePackagerV3;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.ObjectHolder;
import org.apache.nifi.util.StopWatch;

@SupportsBatching
@Tags(value={"http", "https", "remote", "copy", "archive"})
@CapabilityDescription(value="Performs an HTTP Post with the content of the FlowFile")
public class PostHTTP
extends AbstractProcessor {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String APPLICATION_FLOW_FILE_V1 = "application/flowfile";
    public static final String APPLICATION_FLOW_FILE_V2 = "application/flowfile-v2";
    public static final String APPLICATION_FLOW_FILE_V3 = "application/flowfile-v3";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String FLOWFILE_CONFIRMATION_HEADER = "x-prefer-acknowledge-uri";
    public static final String LOCATION_HEADER_NAME = "Location";
    public static final String LOCATION_URI_INTENT_NAME = "x-location-uri-intent";
    public static final String LOCATION_URI_INTENT_VALUE = "flowfile-hold";
    public static final String GZIPPED_HEADER = "flowfile-gzipped";
    public static final String PROTOCOL_VERSION_HEADER = "x-nifi-transfer-protocol-version";
    public static final String TRANSACTION_ID_HEADER = "x-nifi-transaction-id";
    public static final String PROTOCOL_VERSION = "3";
    public static final PropertyDescriptor URL = new PropertyDescriptor.Builder().name("URL").description("The URL to POST to. The first part of the URL must be static. However, the path of the URL may be defined using the Attribute Expression Language. For example, https://${hostname} is not valid, but https://1.1.1.1:8080/files/${nf.file.name} is valid.").required(true).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("https?\\://.*"))).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor SEND_AS_FLOWFILE = new PropertyDescriptor.Builder().name("Send as FlowFile").description("If true, will package the FlowFile's contents and attributes together and send the FlowFile Package; otherwise, will send only the FlowFile's content").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("Connection Timeout").description("How long to wait when attempting to connect to the remote server before giving up").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor DATA_TIMEOUT = new PropertyDescriptor.Builder().name("Data Timeout").description("How long to wait between receiving segments of data from the remote server before giving up and discarding the partial file").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("Username required to access the URL").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("Password required to access the URL").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USER_AGENT = new PropertyDescriptor.Builder().name("User Agent").description("What to report as the User Agent when we connect to the remote server").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor COMPRESSION_LEVEL = new PropertyDescriptor.Builder().name("Compression Level").description("Determines the GZIP Compression Level to use when sending the file; the value must be in the range of 0-9. A value of 0 indicates that the file will not be GZIP'ed").required(true).addValidator(StandardValidators.createLongValidator((long)0L, (long)9L, (boolean)true)).defaultValue("0").build();
    public static final PropertyDescriptor ATTRIBUTES_AS_HEADERS_REGEX = new PropertyDescriptor.Builder().name("Attributes to Send as HTTP Headers (Regex)").description("Specifies the Regular Expression that determines the names of FlowFile attributes that should be sent as HTTP Headers").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).required(false).build();
    public static final PropertyDescriptor MAX_DATA_RATE = new PropertyDescriptor.Builder().name("Max Data to Post per Second").description("The maximum amount of data to send per second; this allows the bandwidth to be throttled to a specified data rate; if not specified, the data rate is not throttled").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor MAX_BATCH_SIZE = new PropertyDescriptor.Builder().name("Max Batch Size").description("If the Send as FlowFile property is true, specifies the max data size for a batch of FlowFiles to send in a single HTTP POST. If not specified, each FlowFile will be sent separately. If the Send as FlowFile property is false, this property is ignored").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("100 MB").build();
    public static final PropertyDescriptor CHUNKED_ENCODING = new PropertyDescriptor.Builder().name("Use Chunked Encoding").description("Specifies whether or not to use Chunked Encoding to send the data. If false, the entire content of the FlowFile will be buffered into memory.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Files that are successfully send will be transferred to success").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Files that fail to send will transferred to failure").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final AtomicReference<DestinationAccepts> acceptsRef = new AtomicReference();
    private final AtomicReference<StreamThrottler> throttlerRef = new AtomicReference();
    private final ConcurrentMap<String, Config> configMap = new ConcurrentHashMap<String, Config>();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(URL);
        properties.add(MAX_BATCH_SIZE);
        properties.add(MAX_DATA_RATE);
        properties.add(SSL_CONTEXT_SERVICE);
        properties.add(USERNAME);
        properties.add(PASSWORD);
        properties.add(SEND_AS_FLOWFILE);
        properties.add(CHUNKED_ENCODING);
        properties.add(COMPRESSION_LEVEL);
        properties.add(CONNECTION_TIMEOUT);
        properties.add(DATA_TIMEOUT);
        properties.add(ATTRIBUTES_AS_HEADERS_REGEX);
        properties.add(USER_AGENT);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (context.getProperty(URL).getValue().startsWith("https") && context.getProperty(SSL_CONTEXT_SERVICE).getValue() == null) {
            results.add(new ValidationResult.Builder().explanation("URL is set to HTTPS protocol but no SSLContext has been specified").valid(false).subject("SSL Context").build());
        }
        return results;
    }

    @OnStopped
    public void onStopped() {
        this.acceptsRef.set(null);
        for (Map.Entry entry : this.configMap.entrySet()) {
            Config config = (Config)entry.getValue();
            config.getConnectionManager().shutdown();
        }
        this.configMap.clear();
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        Double bytesPerSecond = context.getProperty(MAX_DATA_RATE).asDataSize(DataUnit.B);
        this.throttlerRef.set((StreamThrottler)(bytesPerSecond == null ? null : new LeakyBucketStreamThrottler(bytesPerSecond.intValue())));
    }

    private String getBaseUrl(String url) {
        int index = url.indexOf("/", 9);
        if (index < 0) {
            return url;
        }
        return url.substring(0, index);
    }

    private Config getConfig(String url, ProcessContext context) {
        SSLContext sslContext;
        String baseUrl = this.getBaseUrl(url);
        Config config = (Config)this.configMap.get(baseUrl);
        if (config != null) {
            return config;
        }
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        try {
            sslContext = this.createSSLContext(sslContextService);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager conMan = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        conMan.setDefaultMaxPerRoute(context.getMaxConcurrentTasks());
        conMan.setMaxTotal(context.getMaxConcurrentTasks());
        config = new Config((HttpClientConnectionManager)conMan);
        Config existingConfig = this.configMap.putIfAbsent(baseUrl, config);
        return existingConfig == null ? config : existingConfig;
    }

    private SSLContext createSSLContext(SSLContextService service) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        KeyStore truststore = KeyStore.getInstance(service.getTrustStoreType());
        try (FileInputStream in = new FileInputStream(new File(service.getTrustStoreFile()));){
            truststore.load(in, service.getTrustStorePassword().toCharArray());
        }
        KeyStore keystore = KeyStore.getInstance(service.getKeyStoreType());
        try (FileInputStream in = new FileInputStream(new File(service.getKeyStoreFile()));){
            keystore.load(in, service.getKeyStorePassword().toCharArray());
        }
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(truststore, (TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(keystore, service.getKeyStorePassword().toCharArray()).build();
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onTrigger(ProcessContext context, final ProcessSession session) {
        sendAsFlowFile = context.getProperty(PostHTTP.SEND_AS_FLOWFILE).asBoolean();
        compressionLevel = context.getProperty(PostHTTP.COMPRESSION_LEVEL).asInteger();
        userAgent = context.getProperty(PostHTTP.USER_AGENT).getValue();
        requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectionRequestTimeout(context.getProperty(PostHTTP.DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
        requestConfigBuilder.setConnectTimeout(context.getProperty(PostHTTP.CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
        requestConfigBuilder.setRedirectsEnabled(false);
        requestConfigBuilder.setSocketTimeout(context.getProperty(PostHTTP.DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
        requestConfig = requestConfigBuilder.build();
        throttler = this.throttlerRef.get();
        logger = this.getLogger();
        maxBatchBytes = context.getProperty(PostHTTP.MAX_BATCH_SIZE).asDataSize(DataUnit.B);
        lastUrl = null;
        bytesToSend = 0L;
        toSend = new ArrayList<FlowFile>();
        destinationAccepts = null;
        client = null;
        transactionId = UUID.randomUUID().toString();
        dnHolder = new ObjectHolder((Object)"none");
        while ((flowFile = session.get()) != null) {
            url = context.getProperty(PostHTTP.URL).evaluateAttributeExpressions(flowFile).getValue();
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                logger.error("After substituting attribute values for {}, URL is {}; this is not a valid URL, so routing to failure", new Object[]{flowFile, url});
                flowFile = session.penalize(flowFile);
                session.transfer(flowFile, PostHTTP.REL_FAILURE);
                continue;
            }
            if (lastUrl != null && !lastUrl.equals(url)) {
                session.transfer(flowFile);
                break;
            }
            lastUrl = url;
            toSend.add(flowFile);
            if (client == null || destinationAccepts == null) {
                config = this.getConfig(url, context);
                conMan = config.getConnectionManager();
                clientBuilder = HttpClientBuilder.create();
                clientBuilder.setConnectionManager(conMan);
                clientBuilder.setUserAgent(userAgent);
                clientBuilder.addInterceptorFirst(new HttpResponseInterceptor(){

                    public void process(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
                        HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)httpContext);
                        ManagedHttpClientConnection conn = (ManagedHttpClientConnection)coreContext.getConnection(ManagedHttpClientConnection.class);
                        SSLSession sslSession = conn.getSSLSession();
                        if (sslSession != null) {
                            X509Certificate[] certChain = sslSession.getPeerCertificateChain();
                            if (certChain == null || certChain.length == 0) {
                                throw new SSLPeerUnverifiedException("No certificates found");
                            }
                            X509Certificate cert = certChain[0];
                            dnHolder.set((Object)cert.getSubjectDN().getName().trim());
                        }
                    }
                });
                clientBuilder.disableAutomaticRetries();
                clientBuilder.disableContentCompression();
                username = context.getProperty(PostHTTP.USERNAME).getValue();
                password = context.getProperty(PostHTTP.PASSWORD).getValue();
                if (username != null) {
                    credentialsProvider = new BasicCredentialsProvider();
                    if (password == null) {
                        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username));
                    } else {
                        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                    }
                    clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                client = clientBuilder.build();
                destinationAccepts = config.getDestinationAccepts();
                if (destinationAccepts == null) {
                    try {
                        destinationAccepts = sendAsFlowFile != false ? this.getDestinationAcceptance((HttpClient)client, url, this.getLogger(), transactionId) : new DestinationAccepts(false, false, false, false, null);
                        config.setDestinationAccepts(destinationAccepts);
                    }
                    catch (IOException e) {
                        flowFile = session.penalize(flowFile);
                        session.transfer(flowFile, PostHTTP.REL_FAILURE);
                        logger.error("Unable to communicate with destination {} to determine whether or not it can accept flowfiles/gzip; routing {} to failure due to {}", new Object[]{url, flowFile, e});
                        context.yield();
                        return;
                    }
                }
            }
            if (sendAsFlowFile && (destinationAccepts.isFlowFileV3Accepted() || destinationAccepts.isFlowFileV2Accepted()) && (bytesToSend += flowFile.getSize()) <= maxBatchBytes.longValue()) continue;
            break;
        }
        if (toSend.isEmpty()) {
            return;
        }
        url = lastUrl;
        post = new HttpPost(url);
        flowFileList = toSend;
        accepts = destinationAccepts;
        isDestinationLegacyNiFi = accepts.getProtocolVersion() == null;
        entity = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream rawOut) throws IOException {
                OutputStream throttled = throttler == null ? rawOut : throttler.newThrottledOutputStream(rawOut);
                BufferedOutputStream wrappedOut = new BufferedOutputStream(throttled);
                if (compressionLevel > 0 && accepts.isGzipAccepted()) {
                    wrappedOut = new GZIPOutputStream((OutputStream)wrappedOut, compressionLevel);
                }
                try (BufferedOutputStream out = wrappedOut;){
                    for (FlowFile flowFile : flowFileList) {
                        session.read(flowFile, new InputStreamCallback((OutputStream)out, flowFile){
                            final /* synthetic */ OutputStream val$out;
                            final /* synthetic */ FlowFile val$flowFile;
                            {
                                this.val$out = outputStream;
                                this.val$flowFile = flowFile;
                            }

                            public void process(InputStream rawIn) throws IOException {
                                try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                                    FlowFilePackagerV3 packager = null;
                                    if (!sendAsFlowFile) {
                                        packager = null;
                                    } else if (accepts.isFlowFileV3Accepted()) {
                                        packager = new FlowFilePackagerV3();
                                    } else if (accepts.isFlowFileV2Accepted()) {
                                        packager = new FlowFilePackagerV2();
                                    } else if (accepts.isFlowFileV1Accepted()) {
                                        packager = new FlowFilePackagerV1();
                                    }
                                    if (packager == null) {
                                        StreamUtils.copy((InputStream)in, (OutputStream)this.val$out);
                                    } else {
                                        HashMap<String, String> flowFileAttributes;
                                        if (isDestinationLegacyNiFi) {
                                            flowFileAttributes = new HashMap<String, String>(this.val$flowFile.getAttributes());
                                            flowFileAttributes.put("nf.file.name", this.val$flowFile.getAttribute(CoreAttributes.FILENAME.key()));
                                            flowFileAttributes.put("nf.file.path", this.val$flowFile.getAttribute(CoreAttributes.PATH.key()));
                                        } else {
                                            flowFileAttributes = this.val$flowFile.getAttributes();
                                        }
                                        packager.packageFlowFile((InputStream)in, this.val$out, flowFileAttributes, this.val$flowFile.getSize());
                                    }
                                }
                            }
                        });
                    }
                    out.flush();
                }
            }
        });
        entity.setChunked(context.getProperty(PostHTTP.CHUNKED_ENCODING).asBoolean().booleanValue());
        post.setEntity((HttpEntity)entity);
        post.setConfig(requestConfig);
        if (!sendAsFlowFile) ** GOTO lbl105
        if (accepts.isFlowFileV3Accepted()) {
            contentType = "application/flowfile-v3";
        } else if (accepts.isFlowFileV2Accepted()) {
            contentType = "application/flowfile-v2";
        } else if (accepts.isFlowFileV1Accepted()) {
            contentType = "application/flowfile";
        } else {
            logger.error("Cannot send data to {} because the destination does not accept FlowFiles and this processor is configured to deliver FlowFiles; rolling back session", new Object[]{url});
            session.rollback();
            context.yield();
            return;
lbl105:
            // 1 sources

            attributeValue = ((FlowFile)toSend.get(0)).getAttribute(CoreAttributes.MIME_TYPE.key());
            contentType = attributeValue == null ? "application/octet-stream" : attributeValue;
        }
        attributeHeaderRegex = context.getProperty(PostHTTP.ATTRIBUTES_AS_HEADERS_REGEX).getValue();
        if (attributeHeaderRegex != null && !sendAsFlowFile && flowFileList.size() == 1) {
            pattern = Pattern.compile(attributeHeaderRegex);
            attributes = ((FlowFile)flowFileList.get(0)).getAttributes();
            for (Map.Entry<K, V> entry : attributes.entrySet()) {
                key = (String)entry.getKey();
                if (!pattern.matcher(key).matches()) continue;
                post.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        post.setHeader("Content-Type", contentType);
        post.setHeader("x-prefer-acknowledge-uri", "true");
        post.setHeader("x-nifi-transfer-protocol-version", "3");
        post.setHeader("x-nifi-transaction-id", transactionId);
        if (compressionLevel > 0 && accepts.isGzipAccepted()) {
            post.setHeader("flowfile-gzipped", "true");
        }
        flowFileDescription = toSend.size() <= 10 ? toSend.toString() : toSend.size() + " FlowFiles";
        response = null;
        try {
            stopWatch = new StopWatch(true);
            response = client.execute((HttpUriRequest)post);
            EntityUtils.consume((HttpEntity)response.getEntity());
            stopWatch.stop();
            uploadDataRate = stopWatch.calculateDataRate(bytesToSend);
            uploadMillis = stopWatch.getDuration(TimeUnit.MILLISECONDS);
            ** if (response == null) goto lbl-1000
        }
        catch (IOException e) {
            block57: {
                try {
                    logger.error("Failed to Post {} due to {}; transferring to failure", new Object[]{flowFileDescription, e});
                    context.yield();
                    for (FlowFile flowFile : toSend) {
                        flowFile = session.penalize(flowFile);
                        session.transfer(flowFile, PostHTTP.REL_FAILURE);
                    }
                    if (response == null) break block57;
                }
                catch (Throwable var35_44) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (IOException e) {
                            this.getLogger().warn("Failed to close HTTP Response due to {}", new Object[]{e});
                        }
                    }
                    throw var35_44;
                }
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.getLogger().warn("Failed to close HTTP Response due to {}", new Object[]{e});
                }
            }
            return;
        }
lbl-1000:
        // 1 sources

        {
            try {
                response.close();
            }
            catch (IOException e) {
                this.getLogger().warn("Failed to close HTTP Response due to {}", new Object[]{e});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        responseCode = response.getStatusLine().getStatusCode();
        responseReason = response.getStatusLine().getReasonPhrase();
        holdUri = null;
        if (responseCode == 303) {
            locationUriHeader = response.getFirstHeader("x-location-uri-intent");
            if (locationUriHeader != null && "flowfile-hold".equals(locationUriHeader.getValue()) && (holdUriHeader = response.getFirstHeader("Location")) != null) {
                holdUri = holdUriHeader.getValue();
            }
            if (holdUri == null) {
                for (FlowFile flowFile : toSend) {
                    flowFile = session.penalize(flowFile);
                    logger.error("Failed to Post {} to {}: sent content and received status code {}:{} but no Hold URI", new Object[]{flowFile, url, responseCode, responseReason});
                    session.transfer(flowFile, PostHTTP.REL_FAILURE);
                }
                return;
            }
        }
        if (holdUri == null) {
            if (responseCode == 503) {
                for (FlowFile flowFile : toSend) {
                    flowFile = session.penalize(flowFile);
                    logger.error("Failed to Post {} to {}: response code was {}:{}; will yield processing, since the destination is temporarily unavailable", new Object[]{flowFile, url, responseCode, responseReason});
                    session.transfer(flowFile, PostHTTP.REL_FAILURE);
                }
                context.yield();
                return;
            }
            if (responseCode >= 300) {
                for (FlowFile flowFile : toSend) {
                    flowFile = session.penalize(flowFile);
                    logger.error("Failed to Post {} to {}: response code was {}:{}", new Object[]{flowFile, url, responseCode, responseReason});
                    session.transfer(flowFile, PostHTTP.REL_FAILURE);
                }
                return;
            }
            logger.info("Successfully Posted {} to {} in {} at a rate of {}", new Object[]{flowFileDescription, url, FormatUtils.formatMinutesSeconds((long)uploadMillis, (TimeUnit)TimeUnit.MILLISECONDS), uploadDataRate});
            for (FlowFile flowFile : toSend) {
                session.getProvenanceReporter().send(flowFile, url, "Remote DN=" + (String)dnHolder.get(), uploadMillis, true);
                session.transfer(flowFile, PostHTTP.REL_SUCCESS);
            }
            return;
        }
        fullHoldUri = holdUri;
        if (holdUri.startsWith("/contentListener")) {
            fullHoldUri = url + holdUri.substring(16);
        } else if (holdUri.startsWith("/")) {
            firstSlash = url.indexOf("/", 8);
            if (firstSlash < 0) {
                firstSlash = url.length();
            }
            beforeSlash = url.substring(0, firstSlash);
            fullHoldUri = beforeSlash + holdUri;
        } else if (!holdUri.startsWith("http")) {
            fullHoldUri = url + (url.endsWith("/") != false ? "" : "/") + holdUri;
        }
        delete = new HttpDelete(fullHoldUri);
        delete.setHeader("x-nifi-transaction-id", transactionId);
        while (true) {
            try {
                holdResponse = client.execute((HttpUriRequest)delete);
                EntityUtils.consume((HttpEntity)holdResponse.getEntity());
                holdStatusCode = holdResponse.getStatusLine().getStatusCode();
                holdReason = holdResponse.getStatusLine().getReasonPhrase();
                if (holdStatusCode >= 300) {
                    logger.error("Failed to delete Hold that destination placed on {}: got response code {}:{}; routing to failure", new Object[]{flowFileDescription, holdStatusCode, holdReason});
                    for (FlowFile flowFile : toSend) {
                        flowFile = session.penalize(flowFile);
                        session.transfer(flowFile, PostHTTP.REL_FAILURE);
                    }
                    return;
                }
                logger.info("Successfully Posted {} to {} in {} milliseconds at a rate of {}", new Object[]{flowFileDescription, url, uploadMillis, uploadDataRate});
                for (FlowFile flowFile : toSend) {
                    session.getProvenanceReporter().send(flowFile, url);
                    session.transfer(flowFile, PostHTTP.REL_SUCCESS);
                }
                return;
            }
            catch (IOException e) {
                logger.warn("Failed to delete Hold that destination placed on {} due to {}", new Object[]{flowFileDescription, e});
                if (this.isScheduled()) continue;
                context.yield();
                logger.warn("Failed to delete Hold that destination placed on {}; Processor has been stopped so routing FlowFile(s) to failure", new Object[]{flowFileDescription});
                for (FlowFile flowFile : toSend) {
                    flowFile = session.penalize(flowFile);
                    session.transfer(flowFile, PostHTTP.REL_FAILURE);
                }
                return;
            }
            break;
        }
    }

    private DestinationAccepts getDestinationAcceptance(HttpClient client, String uri, ProcessorLog logger, String transactionId) throws IOException {
        HttpHead head = new HttpHead(uri);
        head.addHeader(TRANSACTION_ID_HEADER, transactionId);
        HttpResponse response = client.execute((HttpUriRequest)head);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == ClientResponse.Status.METHOD_NOT_ALLOWED.getStatusCode()) {
            return new DestinationAccepts(false, false, true, false, null);
        }
        if (statusCode == ClientResponse.Status.OK.getStatusCode()) {
            Header destinationVersion;
            boolean acceptsFlowFileV3 = false;
            boolean acceptsFlowFileV2 = false;
            boolean acceptsFlowFileV1 = true;
            boolean acceptsGzip = false;
            Integer protocolVersion = null;
            Header[] headers = response.getHeaders(ACCEPT);
            if (headers != null) {
                for (Header header : headers) {
                    for (String accepted : header.getValue().split(",")) {
                        String trimmed = accepted.trim();
                        if (trimmed.equals(APPLICATION_FLOW_FILE_V3)) {
                            acceptsFlowFileV3 = true;
                            continue;
                        }
                        if (trimmed.equals(APPLICATION_FLOW_FILE_V2)) {
                            acceptsFlowFileV2 = true;
                            continue;
                        }
                        acceptsFlowFileV1 = true;
                    }
                }
            }
            if ((destinationVersion = response.getFirstHeader(PROTOCOL_VERSION_HEADER)) != null) {
                try {
                    protocolVersion = Integer.valueOf(destinationVersion.getValue());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (acceptsFlowFileV3) {
                logger.debug("Connection to URI " + uri + " will be using Content Type " + APPLICATION_FLOW_FILE_V3 + " if sending data as FlowFile");
            } else if (acceptsFlowFileV2) {
                logger.debug("Connection to URI " + uri + " will be using Content Type " + APPLICATION_FLOW_FILE_V2 + " if sending data as FlowFile");
            } else if (acceptsFlowFileV1) {
                logger.debug("Connection to URI " + uri + " will be using Content Type " + APPLICATION_FLOW_FILE_V1 + " if sending data as FlowFile");
            }
            headers = response.getHeaders(ACCEPT_ENCODING);
            if (headers != null) {
                for (Header header : headers) {
                    for (String accepted : header.getValue().split(",")) {
                        if (!accepted.equalsIgnoreCase("gzip")) continue;
                        acceptsGzip = true;
                    }
                }
            }
            if (acceptsGzip) {
                logger.debug("Connection to URI " + uri + " indicates that inline GZIP compression is supported");
            } else {
                logger.debug("Connection to URI " + uri + " indicates that it does NOT support inline GZIP compression");
            }
            return new DestinationAccepts(acceptsFlowFileV3, acceptsFlowFileV2, acceptsFlowFileV1, acceptsGzip, protocolVersion);
        }
        logger.warn("Unable to communicate with destination; when attempting to perform an HTTP HEAD, got unexpected response code of " + statusCode + ": " + response.getStatusLine().getReasonPhrase());
        return new DestinationAccepts(false, false, false, false, null);
    }

    private static class Config {
        private volatile DestinationAccepts destinationAccepts;
        private final HttpClientConnectionManager conMan;

        public Config(HttpClientConnectionManager conMan) {
            this.conMan = conMan;
        }

        public DestinationAccepts getDestinationAccepts() {
            return this.destinationAccepts;
        }

        public void setDestinationAccepts(DestinationAccepts destinationAccepts) {
            this.destinationAccepts = destinationAccepts;
        }

        public HttpClientConnectionManager getConnectionManager() {
            return this.conMan;
        }
    }

    private static class DestinationAccepts {
        private final boolean flowFileV1;
        private final boolean flowFileV2;
        private final boolean flowFileV3;
        private final boolean gzip;
        private final Integer protocolVersion;

        public DestinationAccepts(boolean flowFileV3, boolean flowFileV2, boolean flowFileV1, boolean gzip, Integer protocolVersion) {
            this.flowFileV3 = flowFileV3;
            this.flowFileV2 = flowFileV2;
            this.flowFileV1 = flowFileV1;
            this.gzip = gzip;
            this.protocolVersion = protocolVersion;
        }

        public boolean isFlowFileV3Accepted() {
            return this.flowFileV3;
        }

        public boolean isFlowFileV2Accepted() {
            return this.flowFileV2;
        }

        public boolean isFlowFileV1Accepted() {
            return this.flowFileV1;
        }

        public boolean isGzipAccepted() {
            return this.gzip;
        }

        public Integer getProtocolVersion() {
            return this.protocolVersion;
        }
    }
}

