/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.sun.mail.smtp.SMTPTransport;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.annotation.CapabilityDescription;
import org.apache.nifi.processor.annotation.SupportsBatching;
import org.apache.nifi.processor.annotation.Tags;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;

@SupportsBatching
@Tags(value={"email", "put", "notify", "smtp"})
@CapabilityDescription(value="Sends an e-mail to configured recipients for each incoming FlowFile")
public class PutEmail
extends AbstractProcessor {
    public static final PropertyDescriptor SMTP_HOSTNAME = new PropertyDescriptor.Builder().name("SMTP Hostname").description("The hostname of the SMTP host").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SMTP_PORT = new PropertyDescriptor.Builder().name("SMTP Port").description("The Port used for SMTP communications").required(true).defaultValue("25").addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor FROM = new PropertyDescriptor.Builder().name("From").description("Specifies the Email address to use as the sender").required(true).expressionLanguageSupported(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TO = new PropertyDescriptor.Builder().name("To").description("The recipients to include in the To-Line of the email").required(false).expressionLanguageSupported(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CC = new PropertyDescriptor.Builder().name("CC").description("The recipients to include in the CC-Line of the email").required(false).expressionLanguageSupported(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor BCC = new PropertyDescriptor.Builder().name("BCC").description("The recipients to include in the BCC-Line of the email").required(false).expressionLanguageSupported(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SUBJECT = new PropertyDescriptor.Builder().name("Subject").description("The email subject").required(true).expressionLanguageSupported(true).defaultValue("Message from NiFi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MESSAGE = new PropertyDescriptor.Builder().name("Message").description("The body of the email message").required(true).expressionLanguageSupported(true).defaultValue("").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ATTACH_FILE = new PropertyDescriptor.Builder().name("Attach File").description("Specifies whether or not the FlowFile content should be attached to the email").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor INCLUDE_ALL_ATTRIBUTES = new PropertyDescriptor.Builder().name("Include All Attributes In Message").description("Specifies whether or not all FlowFile attributes should be recorded in the body of the email message").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that are successfully sent will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that fail to send will be routed to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    public static final String BODY_SEPARATOR = "\n\n--------------------------------------------------\n";

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SMTP_HOSTNAME);
        properties.add(SMTP_PORT);
        properties.add(FROM);
        properties.add(TO);
        properties.add(CC);
        properties.add(BCC);
        properties.add(SUBJECT);
        properties.add(MESSAGE);
        properties.add(ATTACH_FILE);
        properties.add(INCLUDE_ALL_ATTRIBUTES);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>(super.customValidate(context));
        String to = context.getProperty(TO).getValue();
        String cc = context.getProperty(CC).getValue();
        String bcc = context.getProperty(BCC).getValue();
        if (to == null && cc == null && bcc == null) {
            errors.add(new ValidationResult.Builder().subject("To, CC, BCC").valid(false).explanation("Must specify at least one To/CC/BCC address").build());
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("smtp.mail.host", context.getProperty(SMTP_HOSTNAME).getValue());
        Session mailSession = Session.getInstance((Properties)properties);
        MimeMessage message = new MimeMessage(mailSession);
        ProcessorLog logger = this.getLogger();
        try {
            message.setFrom((Address)InternetAddress.parse((String)context.getProperty(FROM).evaluateAttributeExpressions(flowFile).getValue())[0]);
            InternetAddress[] toAddresses = PutEmail.toInetAddresses(context.getProperty(TO).evaluateAttributeExpressions(flowFile).getValue());
            message.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            InternetAddress[] ccAddresses = PutEmail.toInetAddresses(context.getProperty(CC).evaluateAttributeExpressions(flowFile).getValue());
            message.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
            InternetAddress[] bccAddresses = PutEmail.toInetAddresses(context.getProperty(BCC).evaluateAttributeExpressions(flowFile).getValue());
            message.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
            message.setHeader("X-Mailer", "NiFi");
            message.setSubject(context.getProperty(SUBJECT).evaluateAttributeExpressions(flowFile).getValue());
            String messageText = context.getProperty(MESSAGE).evaluateAttributeExpressions(flowFile).getValue();
            if (context.getProperty(INCLUDE_ALL_ATTRIBUTES).asBoolean().booleanValue()) {
                messageText = PutEmail.formatAttributes(flowFile, messageText);
            }
            message.setText(messageText);
            message.setSentDate(new Date());
            if (context.getProperty(ATTACH_FILE).asBoolean().booleanValue()) {
                PreencodedMimeBodyPart mimeText = new PreencodedMimeBodyPart("base64");
                mimeText.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(Base64.encodeBase64((byte[])messageText.getBytes("UTF-8")), "text/plain; charset=\"utf-8\"")));
                final MimeBodyPart mimeFile = new MimeBodyPart();
                session.read(flowFile, new InputStreamCallback(){

                    public void process(InputStream stream) throws IOException {
                        try {
                            mimeFile.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(stream, "application/octet-stream")));
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    }
                });
                mimeFile.setFileName(flowFile.getAttribute(CoreAttributes.FILENAME.key()));
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)mimeText);
                multipart.addBodyPart((BodyPart)mimeFile);
                message.setContent((Multipart)multipart);
            }
            String smtpHost = context.getProperty(SMTP_HOSTNAME).getValue();
            try (SMTPTransport transport = new SMTPTransport(mailSession, new URLName(smtpHost));){
                int smtpPort = context.getProperty(SMTP_PORT).asInteger();
                transport.connect(new Socket(smtpHost, smtpPort));
                transport.sendMessage((Message)message, message.getAllRecipients());
            }
            session.getProvenanceReporter().send(flowFile, "mailto:" + message.getAllRecipients()[0].toString());
            session.transfer(flowFile, REL_SUCCESS);
            logger.info("Sent email as a result of receiving {}", new Object[]{flowFile});
        }
        catch (Exception e) {
            context.yield();
            logger.error("Failed to send email for {}: {}; routing to failure", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private static String formatAttributes(FlowFile flowFile, String messagePrepend) {
        StringBuilder message = new StringBuilder(messagePrepend);
        message.append(BODY_SEPARATOR);
        message.append("\nStandard FlowFile Metadata:");
        message.append(String.format("\n\t%1$s = '%2$s'", "id", flowFile.getId()));
        message.append(String.format("\n\t%1$s = '%2$s'", "entryDate", new Date(flowFile.getEntryDate())));
        message.append(String.format("\n\t%1$s = '%2$s'", "fileSize", flowFile.getSize()));
        message.append("\nFlowFile Attributes:");
        for (Map.Entry attribute : flowFile.getAttributes().entrySet()) {
            message.append(String.format("\n\t%1$s = '%2$s'", attribute.getKey(), attribute.getValue()));
        }
        message.append("\n");
        return message.toString();
    }

    private static InternetAddress[] toInetAddresses(String val) throws AddressException {
        if (val == null) {
            return new InternetAddress[0];
        }
        return InternetAddress.parse((String)val);
    }
}

