/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.annotation.CapabilityDescription;
import org.apache.nifi.processor.annotation.EventDriven;
import org.apache.nifi.processor.annotation.SideEffectFree;
import org.apache.nifi.processor.annotation.SupportsBatching;
import org.apache.nifi.processor.annotation.Tags;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.Tuple;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"xml", "xslt", "transform"})
@CapabilityDescription(value="Applies the provided XSLT file to the flowfile XML payload. A new FlowFile is created with transformed content and is routed to the 'success' relationship. If the XSL transform fails, the original FlowFile is routed to the 'failure' relationship")
public class TransformXml
extends AbstractProcessor {
    public static final PropertyDescriptor XSLT_FILE_NAME = new PropertyDescriptor.Builder().name("XSLT file name").description("Provides the name (including full path) of the XSLT file to apply to the flowfile XML content.").required(true).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The FlowFile with transformed content will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid XML), it will be routed to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(XSLT_FILE_NAME);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).expressionLanguageSupported(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).required(false).dynamic(true).build();
    }

    public void onTrigger(final ProcessContext context, ProcessSession session) {
        final FlowFile original = session.get();
        if (original == null) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        StopWatch stopWatch = new StopWatch(true);
        try {
            FlowFile transformed = session.write(original, new StreamCallback(){

                public void process(InputStream rawIn, OutputStream out) throws IOException {
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                        File stylesheet = new File(context.getProperty(XSLT_FILE_NAME).getValue());
                        StreamSource styleSource = new StreamSource(stylesheet);
                        TransformerFactoryImpl tfactory = new TransformerFactoryImpl();
                        Transformer transformer = tfactory.newTransformer(styleSource);
                        for (Map.Entry entry : context.getProperties().entrySet()) {
                            if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
                            String value = context.newPropertyValue((String)entry.getValue()).evaluateAttributeExpressions(original).getValue();
                            transformer.setParameter(((PropertyDescriptor)entry.getKey()).getName(), value);
                        }
                        StreamSource source = new StreamSource((InputStream)in);
                        StreamResult result = new StreamResult(out);
                        transformer.transform(source, result);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            });
            session.transfer(transformed, REL_SUCCESS);
            session.getProvenanceReporter().modifyContent(transformed, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            logger.info("Transformed {}", new Object[]{original});
        }
        catch (Exception e) {
            logger.error("Unable to transform {} due to {}", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
        }
    }

    private static final class XsltValidator
    implements Validator {
        private volatile Tuple<String, ValidationResult> cachedResult;

        private XsltValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext validationContext) {
            Tuple<String, ValidationResult> lastResult = this.cachedResult;
            if (lastResult != null && ((String)lastResult.getKey()).equals(input)) {
                return (ValidationResult)lastResult.getValue();
            }
            String error = null;
            File stylesheet = new File(input);
            TransformerFactoryImpl tfactory = new TransformerFactoryImpl();
            StreamSource styleSource = new StreamSource(stylesheet);
            try {
                tfactory.newTransformer(styleSource);
            }
            catch (Exception e) {
                error = e.toString();
            }
            this.cachedResult = new Tuple((Object)input, (Object)new ValidationResult.Builder().input(input).subject(subject).valid(error == null).explanation(error).build());
            return (ValidationResult)this.cachedResult.getValue();
        }
    }
}

