/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.annotation.CapabilityDescription;
import org.apache.nifi.processor.annotation.EventDriven;
import org.apache.nifi.processor.annotation.SideEffectFree;
import org.apache.nifi.processor.annotation.SupportsBatching;
import org.apache.nifi.processor.annotation.Tags;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.FlowFileUnpackager;
import org.apache.nifi.util.FlowFileUnpackagerV1;
import org.apache.nifi.util.FlowFileUnpackagerV2;
import org.apache.nifi.util.FlowFileUnpackagerV3;
import org.apache.nifi.util.ObjectHolder;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"Unpack", "un-merge", "tar", "zip", "archive", "flowfile-stream", "flowfile-stream-v3"})
@CapabilityDescription(value="Unpacks the content of FlowFiles that have been packaged with one of several different Packaging Formats, emitting one to many FlowFiles for each input FlowFile")
public class UnpackContent
extends AbstractProcessor {
    public static final String AUTO_DETECT_FORMAT = "use mime.type attribute";
    public static final String TAR_FORMAT = "tar";
    public static final String ZIP_FORMAT = "zip";
    public static final String FLOWFILE_STREAM_FORMAT_V3 = "flowfile-stream-v3";
    public static final String FLOWFILE_STREAM_FORMAT_V2 = "flowfile-stream-v2";
    public static final String FLOWFILE_TAR_FORMAT = "flowfile-tar-v1";
    public static final String FRAGMENT_ID = "fragment.identifier";
    public static final String FRAGMENT_INDEX = "fragment.index";
    public static final String FRAGMENT_COUNT = "fragment.count";
    public static final String SEGMENT_ORIGINAL_FILENAME = "segment.original.filename";
    public static final String OCTET_STREAM = "application/octet-stream";
    public static final PropertyDescriptor PACKAGING_FORMAT = new PropertyDescriptor.Builder().name("Packaging Format").description("The Packaging Format used to create the file").required(true).allowableValues(new String[]{"use mime.type attribute", "tar", "zip", "flowfile-stream-v3", "flowfile-stream-v2", "flowfile-tar-v1"}).defaultValue("use mime.type attribute").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Unpacked FlowFiles are sent to this relationship").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original FlowFile is sent to this relationship after it has been successfully unpacked").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("The original FlowFile is sent to this relationship when it cannot be unpacked for some reason").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(PACKAGING_FORMAT);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        boolean addFragmentAttrs;
        Unpacker unpacker;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        String packagingFormat = context.getProperty(PACKAGING_FORMAT).getValue().toLowerCase();
        if (AUTO_DETECT_FORMAT.equals(packagingFormat)) {
            String mimeType = flowFile.getAttribute(CoreAttributes.MIME_TYPE.key());
            if (mimeType == null) {
                logger.error("No mime.type attribute set for {}; routing to failure", new Object[]{flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            switch (mimeType.toLowerCase()) {
                case "application/tar": {
                    packagingFormat = TAR_FORMAT;
                    break;
                }
                case "application/zip": {
                    packagingFormat = ZIP_FORMAT;
                    break;
                }
                case "application/flowfile-v3": {
                    packagingFormat = FLOWFILE_STREAM_FORMAT_V3;
                    break;
                }
                case "application/flowfile-v2": {
                    packagingFormat = FLOWFILE_STREAM_FORMAT_V2;
                    break;
                }
                case "application/flowfile-v1": {
                    packagingFormat = FLOWFILE_TAR_FORMAT;
                    break;
                }
                default: {
                    logger.info("Cannot unpack {} because its mime.type attribute is set to '{}', which is not a format that can be unpacked; routing to 'success'", new Object[]{flowFile, mimeType});
                    session.transfer(flowFile, REL_SUCCESS);
                    return;
                }
            }
        }
        switch (packagingFormat) {
            case "tar": {
                unpacker = new TarUnpacker();
                addFragmentAttrs = true;
                break;
            }
            case "zip": {
                unpacker = new ZipUnpacker();
                addFragmentAttrs = true;
                break;
            }
            case "flowfile-stream-v2": {
                unpacker = new FlowFileStreamUnpacker((FlowFileUnpackager)new FlowFileUnpackagerV2());
                addFragmentAttrs = false;
                break;
            }
            case "flowfile-stream-v3": {
                unpacker = new FlowFileStreamUnpacker((FlowFileUnpackager)new FlowFileUnpackagerV3());
                addFragmentAttrs = false;
                break;
            }
            case "flowfile-tar-v1": {
                unpacker = new FlowFileStreamUnpacker((FlowFileUnpackager)new FlowFileUnpackagerV1());
                addFragmentAttrs = false;
                break;
            }
            default: {
                throw new AssertionError((Object)("Packaging Format was " + context.getProperty(PACKAGING_FORMAT).getValue()));
            }
        }
        ArrayList<FlowFile> unpacked = new ArrayList<FlowFile>();
        try {
            unpacker.unpack(session, flowFile, unpacked);
            if (unpacked.isEmpty()) {
                logger.error("Unable to unpack {} because it does not appear to have any entries; routing to failure", new Object[]{flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            if (addFragmentAttrs) {
                this.finishFragmentAttributes(session, flowFile, unpacked);
            }
            session.transfer(unpacked, REL_SUCCESS);
            session.transfer(flowFile, REL_ORIGINAL);
            session.getProvenanceReporter().fork(flowFile, unpacked);
            logger.info("Unpacked {} into {} and transferred to success", new Object[]{flowFile, unpacked});
        }
        catch (ProcessException e) {
            logger.error("Unable to unpack {} due to {}; routing to failure", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            session.remove(unpacked);
        }
    }

    private static void mapAttributes(Map<String, String> attributes, String oldKey, String newKey) {
        if (!attributes.containsKey(newKey) && attributes.containsKey(oldKey)) {
            attributes.put(newKey, attributes.get(oldKey));
        }
    }

    private void finishFragmentAttributes(ProcessSession session, FlowFile source, List<FlowFile> unpacked) {
        int fragmentCount = 0;
        for (FlowFile ff : unpacked) {
            String fragmentIndex = ff.getAttribute(FRAGMENT_INDEX);
            if (fragmentIndex != null) {
                ++fragmentCount;
                continue;
            }
            return;
        }
        String originalFilename = source.getAttribute(CoreAttributes.FILENAME.key());
        if (originalFilename.endsWith(".tar") || originalFilename.endsWith(".zip") || originalFilename.endsWith(".pkg")) {
            originalFilename = originalFilename.substring(0, originalFilename.length() - 4);
        }
        ArrayList<FlowFile> newList = new ArrayList<FlowFile>(unpacked);
        unpacked.clear();
        for (FlowFile ff : newList) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(FRAGMENT_COUNT, String.valueOf(fragmentCount));
            attributes.put(SEGMENT_ORIGINAL_FILENAME, originalFilename);
            FlowFile newFF = session.putAllAttributes(ff, attributes);
            unpacked.add(newFF);
        }
    }

    private static class FlowFileStreamUnpacker
    implements Unpacker {
        private final FlowFileUnpackager unpackager;

        public FlowFileStreamUnpacker(FlowFileUnpackager unpackager) {
            this.unpackager = unpackager;
        }

        @Override
        public void unpack(final ProcessSession session, final FlowFile source, final List<FlowFile> unpacked) {
            session.read(source, new InputStreamCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(InputStream rawIn) throws IOException {
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                        while (FlowFileStreamUnpacker.this.unpackager.hasMoreData()) {
                            ObjectHolder attributesRef = new ObjectHolder(null);
                            FlowFile unpackedFile = session.create(source);
                            try {
                                unpackedFile = session.write(unpackedFile, new OutputStreamCallback((InputStream)in, attributesRef){
                                    final /* synthetic */ InputStream val$in;
                                    final /* synthetic */ ObjectHolder val$attributesRef;
                                    {
                                        this.val$in = inputStream;
                                        this.val$attributesRef = objectHolder;
                                    }

                                    public void process(OutputStream rawOut) throws IOException {
                                        try (BufferedOutputStream out = new BufferedOutputStream(rawOut);){
                                            Map attributes = FlowFileStreamUnpacker.this.unpackager.unpackageFlowFile(this.val$in, (OutputStream)out);
                                            if (attributes == null) {
                                                throw new IOException("Failed to unpack " + source + ": stream had no Attributes");
                                            }
                                            this.val$attributesRef.set((Object)attributes);
                                        }
                                    }
                                });
                                Map attributes = (Map)attributesRef.get();
                                attributes.remove(CoreAttributes.UUID.key());
                                UnpackContent.mapAttributes(attributes, "nf.file.name", CoreAttributes.FILENAME.key());
                                UnpackContent.mapAttributes(attributes, "nf.file.path", CoreAttributes.PATH.key());
                                UnpackContent.mapAttributes(attributes, "content-encoding", CoreAttributes.MIME_TYPE.key());
                                UnpackContent.mapAttributes(attributes, "content-type", CoreAttributes.MIME_TYPE.key());
                                if (!attributes.containsKey(CoreAttributes.MIME_TYPE.key())) {
                                    attributes.put(CoreAttributes.MIME_TYPE.key(), UnpackContent.OCTET_STREAM);
                                }
                                unpackedFile = session.putAllAttributes(unpackedFile, attributes);
                            }
                            finally {
                                unpacked.add(unpackedFile);
                            }
                        }
                    }
                }
            });
        }
    }

    private static class ZipUnpacker
    implements Unpacker {
        private ZipUnpacker() {
        }

        @Override
        public void unpack(final ProcessSession session, final FlowFile source, final List<FlowFile> unpacked) {
            final String fragmentId = UUID.randomUUID().toString();
            session.read(source, new InputStreamCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(InputStream in) throws IOException {
                    int fragmentCount = 0;
                    try (final ZipArchiveInputStream zipIn = new ZipArchiveInputStream((InputStream)new BufferedInputStream(in));){
                        ArchiveEntry zipEntry;
                        while ((zipEntry = zipIn.getNextEntry()) != null) {
                            if (zipEntry.isDirectory()) continue;
                            File file = new File(zipEntry.getName());
                            String parentDirectory = file.getParent() == null ? "/" : file.getParent();
                            Path absPath = file.toPath().toAbsolutePath();
                            String absPathString = absPath.getParent().toString() + "/";
                            FlowFile unpackedFile = session.create(source);
                            try {
                                HashMap<String, String> attributes = new HashMap<String, String>();
                                attributes.put(CoreAttributes.FILENAME.key(), file.getName());
                                attributes.put(CoreAttributes.PATH.key(), parentDirectory);
                                attributes.put(CoreAttributes.ABSOLUTE_PATH.key(), absPathString);
                                attributes.put(CoreAttributes.MIME_TYPE.key(), UnpackContent.OCTET_STREAM);
                                attributes.put(UnpackContent.FRAGMENT_ID, fragmentId);
                                attributes.put(UnpackContent.FRAGMENT_INDEX, String.valueOf(++fragmentCount));
                                unpackedFile = session.putAllAttributes(unpackedFile, attributes);
                                unpackedFile = session.write(unpackedFile, new OutputStreamCallback(){

                                    public void process(OutputStream out) throws IOException {
                                        StreamUtils.copy((InputStream)zipIn, (OutputStream)out);
                                    }
                                });
                            }
                            finally {
                                unpacked.add(unpackedFile);
                            }
                        }
                    }
                }
            });
        }
    }

    private static class TarUnpacker
    implements Unpacker {
        private TarUnpacker() {
        }

        @Override
        public void unpack(final ProcessSession session, final FlowFile source, final List<FlowFile> unpacked) {
            final String fragmentId = UUID.randomUUID().toString();
            session.read(source, new InputStreamCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(InputStream in) throws IOException {
                    int fragmentCount = 0;
                    try (final TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new BufferedInputStream(in));){
                        TarArchiveEntry tarEntry;
                        while ((tarEntry = tarIn.getNextTarEntry()) != null) {
                            if (tarEntry.isDirectory()) continue;
                            File file = new File(tarEntry.getName());
                            Path filePath = file.toPath();
                            String filePathString = filePath.getParent() + "/";
                            Path absPath = filePath.toAbsolutePath();
                            String absPathString = absPath.getParent().toString() + "/";
                            FlowFile unpackedFile = session.create(source);
                            try {
                                HashMap<String, String> attributes = new HashMap<String, String>();
                                attributes.put(CoreAttributes.FILENAME.key(), file.getName());
                                attributes.put(CoreAttributes.PATH.key(), filePathString);
                                attributes.put(CoreAttributes.ABSOLUTE_PATH.key(), absPathString);
                                attributes.put(CoreAttributes.MIME_TYPE.key(), UnpackContent.OCTET_STREAM);
                                attributes.put(UnpackContent.FRAGMENT_ID, fragmentId);
                                attributes.put(UnpackContent.FRAGMENT_INDEX, String.valueOf(++fragmentCount));
                                unpackedFile = session.putAllAttributes(unpackedFile, attributes);
                                final long fileSize = tarEntry.getSize();
                                unpackedFile = session.write(unpackedFile, new OutputStreamCallback(){

                                    public void process(OutputStream out) throws IOException {
                                        StreamUtils.copy((InputStream)tarIn, (OutputStream)out, (long)fileSize);
                                    }
                                });
                            }
                            finally {
                                unpacked.add(unpackedFile);
                            }
                        }
                    }
                }
            });
        }
    }

    private static interface Unpacker {
        public void unpack(ProcessSession var1, FlowFile var2, List<FlowFile> var3);
    }
}

