/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.http.HttpContextMap;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"http", "https", "response", "egress", "web service"})
@CapabilityDescription(value="Sends an HTTP Response to the Requestor that generated a FlowFile. This Processor is designed to be used in conjunction with the HandleHttpRequest in order to create a web service.")
public class HandleHttpResponse
extends AbstractProcessor {
    public static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");
    public static final String HTTP_CONTEXT_ID = "http.context.identifier";
    public static final PropertyDescriptor STATUS_CODE = new PropertyDescriptor.Builder().name("HTTP Status Code").description("The HTTP Status Code to use when responding to the HTTP Request. See Section 10 of RFC 2616 for more information.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor HTTP_CONTEXT_MAP = new PropertyDescriptor.Builder().name("HTTP Context Map").description("The HTTP Context Map Controller Service to use for caching the HTTP Request Information").required(true).identifiesControllerService(HttpContextMap.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles will be routed to this Relationship after the response has been successfully sent to the requestor").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles will be routed to this Relationship if the Processor is unable to respond to the requestor. This may happen, for instance, if the connection times out or if NiFi is restarted before responding to the HTTP Request.").build();

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(STATUS_CODE);
        properties.add(HTTP_CONTEXT_MAP);
        return properties;
    }

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        return relationships;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().description("Specifies the value to send for the '" + propertyDescriptorName + "' HTTP Header").name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).expressionLanguageSupported(true).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        HttpContextMap contextMap;
        HttpServletResponse response;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String contextIdentifier = flowFile.getAttribute(HTTP_CONTEXT_ID);
        if (contextIdentifier == null) {
            session.transfer(flowFile, REL_FAILURE);
            this.getLogger().warn("Failed to respond to HTTP request for {} because FlowFile did not have an 'http.context.identifier' attribute", new Object[]{flowFile});
            return;
        }
        String statusCodeValue = context.getProperty(STATUS_CODE).evaluateAttributeExpressions(flowFile).getValue();
        if (!HandleHttpResponse.isNumber(statusCodeValue)) {
            session.transfer(flowFile, REL_FAILURE);
            this.getLogger().error("Failed to response to HTTP request for {} because status code was '{}', which is not a valid number", new Object[]{flowFile, statusCodeValue});
        }
        if ((response = (contextMap = (HttpContextMap)context.getProperty(HTTP_CONTEXT_MAP).asControllerService(HttpContextMap.class)).getResponse(contextIdentifier)) == null) {
            session.transfer(flowFile, REL_FAILURE);
            this.getLogger().error("Failed to respond to HTTP request for {} because FlowFile had an '{}' attribute of {} but could not find an HTTP Response Object for this identifier", new Object[]{flowFile, HTTP_CONTEXT_ID, contextIdentifier});
            return;
        }
        int statusCode = Integer.parseInt(statusCodeValue);
        response.setStatus(statusCode);
        for (Map.Entry entry : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (!descriptor.isDynamic()) continue;
            String headerName = descriptor.getName();
            String headerValue = context.getProperty(descriptor).evaluateAttributeExpressions(flowFile).getValue();
            if (headerValue.trim().isEmpty()) continue;
            response.setHeader(headerName, headerValue);
        }
        try {
            session.exportTo(flowFile, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ioe) {
            session.transfer(flowFile, REL_FAILURE);
            this.getLogger().error("Failed to respond to HTTP request for {} due to {}", new Object[]{flowFile, ioe});
            return;
        }
        try {
            contextMap.complete(contextIdentifier);
        }
        catch (IllegalStateException ise) {
            this.getLogger().error("Failed to complete HTTP Transaction for {} due to {}", new Object[]{flowFile, ise});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        session.transfer(flowFile, REL_SUCCESS);
        this.getLogger().info("Successfully responded to HTTP Request for {} with status code {}", new Object[]{flowFile, statusCode});
    }

    private static boolean isNumber(String value) {
        if (value.length() == 0) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

