/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.util.NaiveSearchRingBuffer;
import org.apache.nifi.util.Tuple;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"content", "split", "binary"})
@CapabilityDescription(value="Splits incoming FlowFiles by a specified byte sequence")
public class SplitContent
extends AbstractProcessor {
    public static final String FRAGMENT_ID = "fragment.identifier";
    public static final String FRAGMENT_INDEX = "fragment.index";
    public static final String FRAGMENT_COUNT = "fragment.count";
    public static final String SEGMENT_ORIGINAL_FILENAME = "segment.original.filename";
    public static final PropertyDescriptor BYTE_SEQUENCE = new PropertyDescriptor.Builder().name("Byte Sequence").description("A hex representation of bytes to look for and upon which to split the source file into separate files").addValidator((Validator)new HexStringPropertyValidator()).required(true).build();
    public static final PropertyDescriptor KEEP_SEQUENCE = new PropertyDescriptor.Builder().name("Keep Byte Sequence").description("Determines whether or not the Byte Sequence should be included at the end of each Split").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final Relationship REL_SPLITS = new Relationship.Builder().name("splits").description("All Splits will be routed to the splits relationship").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original file").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final AtomicReference<byte[]> byteSequence = new AtomicReference();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SPLITS);
        relationships.add(REL_ORIGINAL);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(BYTE_SEQUENCE);
        properties.add(KEEP_SEQUENCE);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.equals((Object)BYTE_SEQUENCE)) {
            try {
                this.byteSequence.set(Hex.decodeHex((char[])newValue.toCharArray()));
            }
            catch (Exception e) {
                this.byteSequence.set(null);
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        final boolean keepSequence = context.getProperty(KEEP_SEQUENCE).asBoolean();
        final byte[] byteSequence = this.byteSequence.get();
        if (byteSequence == null) {
            logger.error("{} Unable to obtain Byte Sequence", new Object[]{this});
            session.rollback();
            return;
        }
        final ArrayList splits = new ArrayList();
        final NaiveSearchRingBuffer buffer = new NaiveSearchRingBuffer(byteSequence);
        session.read(flowFile, new InputStreamCallback(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void process(InputStream rawIn) throws IOException {
                long bytesRead = 0L;
                long startOffset = 0L;
                try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                    while (true) {
                        int nextByte;
                        if ((nextByte = in.read()) == -1) {
                            return;
                        }
                        ++bytesRead;
                        boolean matched = buffer.addAndCompare((byte)(nextByte & 0xFF));
                        if (!matched) continue;
                        long splitLength = keepSequence ? bytesRead - startOffset : bytesRead - startOffset - (long)byteSequence.length;
                        splits.add(new Tuple((Object)startOffset, (Object)splitLength));
                        startOffset = bytesRead;
                        buffer.clear();
                        continue;
                        break;
                    }
                }
            }
        });
        long lastOffsetPlusSize = -1L;
        if (splits.isEmpty()) {
            FlowFile clone = session.clone(flowFile);
            session.transfer(flowFile, REL_ORIGINAL);
            session.transfer(clone, REL_SPLITS);
            logger.info("Found no match for {}; transferring original 'original' and transferring clone {} to 'splits'", new Object[]{flowFile, clone});
            return;
        }
        ArrayList<FlowFile> splitList = new ArrayList<FlowFile>();
        for (Tuple tuple : splits) {
            long offset = (Long)tuple.getKey();
            long size = (Long)tuple.getValue();
            if (size > 0L) {
                FlowFile split = session.clone(flowFile, offset, size);
                splitList.add(split);
            }
            lastOffsetPlusSize = offset + size;
        }
        long finalSplitOffset = lastOffsetPlusSize;
        if (!keepSequence) {
            finalSplitOffset += (long)byteSequence.length;
        }
        if (finalSplitOffset > -1L && finalSplitOffset < flowFile.getSize()) {
            FlowFile finalSplit = session.clone(flowFile, finalSplitOffset, flowFile.getSize() - finalSplitOffset);
            splitList.add(finalSplit);
        }
        this.finishFragmentAttributes(session, flowFile, splitList);
        session.transfer(splitList, REL_SPLITS);
        session.transfer(flowFile, REL_ORIGINAL);
        if (splitList.size() > 10) {
            logger.info("Split {} into {} files", new Object[]{flowFile, splitList.size()});
        } else {
            logger.info("Split {} into {} files: {}", new Object[]{flowFile, splitList.size(), splitList});
        }
    }

    private void finishFragmentAttributes(ProcessSession session, FlowFile source, List<FlowFile> splits) {
        String originalFilename = source.getAttribute(CoreAttributes.FILENAME.key());
        String fragmentId = UUID.randomUUID().toString();
        ArrayList<FlowFile> newList = new ArrayList<FlowFile>(splits);
        splits.clear();
        for (int i = 1; i <= newList.size(); ++i) {
            FlowFile ff = newList.get(i - 1);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(FRAGMENT_ID, fragmentId);
            attributes.put(FRAGMENT_INDEX, String.valueOf(i));
            attributes.put(FRAGMENT_COUNT, String.valueOf(newList.size()));
            attributes.put(SEGMENT_ORIGINAL_FILENAME, originalFilename);
            FlowFile newFF = session.putAllAttributes(ff, attributes);
            splits.add(newFF);
        }
    }

    static class HexStringPropertyValidator
    implements Validator {
        HexStringPropertyValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext validationContext) {
            try {
                Hex.decodeHex((char[])input.toCharArray());
                return new ValidationResult.Builder().valid(true).input(input).subject(subject).build();
            }
            catch (Exception e) {
                return new ValidationResult.Builder().valid(false).explanation("Not a valid Hex String").input(input).subject(subject).build();
            }
        }
    }
}

