/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DocumentReaderCallback
implements InputStreamCallback {
    private final boolean isNamespaceAware;
    private Document document;

    public DocumentReaderCallback(boolean isNamespaceAware) {
        this.isNamespaceAware = isNamespaceAware;
    }

    public void process(InputStream stream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(this.isNamespaceAware);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(stream);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce.getLocalizedMessage(), pce);
        }
        catch (SAXException saxe) {
            throw new IOException(saxe.getLocalizedMessage(), saxe);
        }
    }

    public Document getDocument() {
        return this.document;
    }
}

