/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@SupportsBatching
@Tags(value={"http", "https", "rest", "client"})
@CapabilityDescription(value="An HTTP client processor which converts FlowFile attributes to HTTP headers, with configurable HTTP method, url, etc.")
@WritesAttributes(value={@WritesAttribute(attribute="invokehttp.status.code", description="The status code that is returned"), @WritesAttribute(attribute="invokehttp.status.message", description="The status message that is returned"), @WritesAttribute(attribute="invokehttp.response.body", description="The response body"), @WritesAttribute(attribute="invokehttp.request.url", description="The request URL"), @WritesAttribute(attribute="invokehttp.tx.id", description="The transaction ID that is returned after reading the response"), @WritesAttribute(attribute="invokehttp.remote.dn", description="The DN of the remote server")})
@DynamicProperty(name="Trusted Hostname", value="A hostname", description="Bypass the normal truststore hostname verifier to allow the specified (single) remote hostname as trusted Enabling this property has MITM security implications, use wisely. Only valid with SSL (HTTPS) connections.")
public final class InvokeHTTP
extends AbstractProcessor {
    final AtomicReference<SSLContext> sslContextRef = new AtomicReference();
    final AtomicReference<Pattern> attributesToSendRef = new AtomicReference();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Config.PROPERTIES;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        if (Config.PROP_TRUSTED_HOSTNAME.getName().equalsIgnoreCase(propertyDescriptorName)) {
            return Config.PROP_TRUSTED_HOSTNAME;
        }
        return super.getSupportedDynamicPropertyDescriptor(propertyDescriptorName);
    }

    public Set<Relationship> getRelationships() {
        return Config.RELATIONSHIPS;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        newValue = StringUtils.trimToEmpty((String)newValue);
        if (Config.PROP_SSL_CONTEXT_SERVICE.getName().equalsIgnoreCase(descriptor.getName())) {
            if (newValue.isEmpty()) {
                this.sslContextRef.set(null);
            } else {
                SSLContextService svc = (SSLContextService)this.getControllerServiceLookup().getControllerService(newValue);
                this.sslContextRef.set(svc.createSSLContext(SSLContextService.ClientAuth.NONE));
                this.getLogger().info("Loading SSL configuration from keystore={} and truststore={}", new Object[]{svc.getKeyStoreFile(), svc.getTrustStoreFile()});
            }
        }
        if (Config.PROP_ATTRIBUTES_TO_SEND.getName().equalsIgnoreCase(descriptor.getName())) {
            if (newValue.isEmpty()) {
                this.attributesToSendRef.set(null);
            } else {
                this.attributesToSendRef.set(Pattern.compile(newValue));
            }
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        List flowfiles = session.get(50);
        if (flowfiles.isEmpty()) {
            context.yield();
            return;
        }
        for (FlowFile flowfile : flowfiles) {
            Transaction transaction = new Transaction(this.getLogger(), this.sslContextRef, this.attributesToSendRef, context, session, flowfile);
            transaction.process();
        }
    }

    private static class Transaction
    implements Config {
        private static final String rfc1123 = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
        private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZoneUTC();
        private static final AtomicLong txIdGenerator = new AtomicLong();
        private static final Charset utf8 = Charset.forName("UTF-8");
        private final ProcessorLog logger;
        private final AtomicReference<SSLContext> sslContextRef;
        private final AtomicReference<Pattern> attributesToSendRef;
        private final ProcessContext context;
        private final ProcessSession session;
        private final long txId = txIdGenerator.incrementAndGet();
        private FlowFile request;
        private FlowFile response;
        private HttpURLConnection conn;
        private int statusCode;
        private String statusMessage;

        public Transaction(ProcessorLog logger, AtomicReference<SSLContext> sslContextRef, AtomicReference<Pattern> attributesToSendRef, ProcessContext context, ProcessSession session, FlowFile request) {
            this.logger = logger;
            this.sslContextRef = sslContextRef;
            this.attributesToSendRef = attributesToSendRef;
            this.context = context;
            this.session = session;
            this.request = request;
        }

        public void process() {
            try {
                this.openConnection();
                this.sendRequest();
                this.readResponse();
                this.transfer();
            }
            catch (Throwable t) {
                this.logger.error("Routing to {} due to exception: {}", new Object[]{REL_FAILURE.getName(), t}, t);
                this.request = this.session.penalize(this.request);
                this.session.transfer(this.request, REL_FAILURE);
                try {
                    if (this.response != null) {
                        this.session.remove(this.response);
                    }
                }
                catch (Throwable t1) {
                    this.logger.error("Could not cleanup response flowfile due to exception: {}", new Object[]{t1}, t1);
                }
            }
        }

        private void openConnection() throws IOException {
            String urlstr = StringUtils.trimToEmpty((String)this.context.getProperty(PROP_URL).evaluateAttributeExpressions(this.request).getValue());
            URL url = new URL(urlstr);
            this.conn = (HttpURLConnection)url.openConnection();
            String method = StringUtils.trimToEmpty((String)this.context.getProperty(PROP_METHOD).evaluateAttributeExpressions(this.request).getValue()).toUpperCase();
            this.conn.setRequestMethod(method);
            this.conn.setConnectTimeout(this.context.getProperty(PROP_CONNECT_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
            this.conn.setReadTimeout(this.context.getProperty(PROP_READ_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
            this.conn.setInstanceFollowRedirects(this.context.getProperty(PROP_FOLLOW_REDIRECTS).asBoolean());
            if (this.conn instanceof HttpsURLConnection) {
                String trustedHostname;
                HttpsURLConnection sconn = (HttpsURLConnection)this.conn;
                SSLContext sslContext = this.sslContextRef.get();
                if (sslContext != null) {
                    sconn.setSSLSocketFactory(sslContext.getSocketFactory());
                }
                if (!(trustedHostname = StringUtils.trimToEmpty((String)this.context.getProperty(PROP_TRUSTED_HOSTNAME).getValue())).isEmpty()) {
                    sconn.setHostnameVerifier(new OverrideHostnameVerifier(trustedHostname, sconn.getHostnameVerifier()));
                }
            }
        }

        private void sendRequest() throws IOException {
            this.setRequestProperties();
            this.logRequest();
            String method = this.conn.getRequestMethod().toUpperCase();
            if ("POST".equals(method) || "PUT".equals(method)) {
                this.conn.setDoOutput(true);
                this.conn.setFixedLengthStreamingMode(this.request.getSize());
                try (BufferedOutputStream os = new BufferedOutputStream(this.conn.getOutputStream());){
                    this.session.exportTo(this.request, (OutputStream)os);
                }
                this.session.getProvenanceReporter().send(this.request, this.conn.getURL().toExternalForm());
            }
        }

        private void readResponse() throws IOException {
            this.logResponse();
            this.statusCode = this.conn.getResponseCode();
            this.statusMessage = this.conn.getResponseMessage();
            this.request = this.writeStatusAttributes(this.request);
            try (InputStream is = this.getResponseStream();){
                if (!this.isSuccess()) {
                    String body = StringUtils.trimToEmpty((String)this.toString(is, utf8));
                    this.request = this.session.putAttribute(this.request, "invokehttp.response.body", body);
                }
                if (this.isSuccess()) {
                    this.response = this.session.clone(this.request);
                    this.response = this.writeStatusAttributes(this.response);
                    this.response = this.session.putAllAttributes(this.response, this.convertAttributesFromHeaders());
                    if (is != null) {
                        this.response = this.session.importFrom(is, this.response);
                    }
                    this.session.getProvenanceReporter().receive(this.response, this.conn.getURL().toExternalForm());
                }
            }
        }

        private void transfer() throws IOException {
            if (!this.isSuccess()) {
                this.request = this.session.penalize(this.request);
            }
            this.logger.info("Request to {} returned status code {} for {}", new Object[]{this.conn.getURL().toExternalForm(), this.statusCode, this.request});
            if (this.isSuccess()) {
                this.session.transfer(this.request, REL_SUCCESS_REQ);
                this.session.transfer(this.response, REL_SUCCESS_RESP);
            } else if (this.statusCode / 100 == 5) {
                this.session.transfer(this.request, REL_RETRY);
            } else {
                this.session.transfer(this.request, REL_NO_RETRY);
            }
        }

        private void setRequestProperties() {
            Pattern p;
            if (this.context.getProperty(PROP_DATE_HEADER).asBoolean().booleanValue()) {
                this.conn.setRequestProperty("Date", this.getDateValue());
            }
            if ((p = this.attributesToSendRef.get()) != null) {
                Map attributes = this.request.getAttributes();
                Matcher m = p.matcher("");
                for (Map.Entry entry : attributes.entrySet()) {
                    String key = StringUtils.trimToEmpty((String)((String)entry.getKey()));
                    String val = StringUtils.trimToEmpty((String)((String)entry.getValue()));
                    if (IGNORED_ATTRIBUTES.contains(key)) continue;
                    m.reset(key);
                    if (!m.matches()) continue;
                    this.conn.setRequestProperty(key, val);
                }
            }
        }

        private Map<String, String> convertAttributesFromHeaders() throws IOException {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<String, List<String>> entry : this.conn.getHeaderFields().entrySet()) {
                List<String> values;
                String key = entry.getKey();
                if (key == null || (values = entry.getValue()) == null || values.isEmpty()) continue;
                String value = this.csv(values);
                map.put(key, value);
            }
            if (this.conn instanceof HttpsURLConnection) {
                HttpsURLConnection sconn = (HttpsURLConnection)this.conn;
                sconn.connect();
                map.put("invokehttp.remote.dn", sconn.getPeerPrincipal().getName());
            }
            return map;
        }

        private boolean isSuccess() throws IOException {
            if (this.statusCode == 0) {
                throw new IllegalStateException("Status code unknown, connection hasn't been attempted.");
            }
            return this.statusCode / 100 == 2;
        }

        private void logRequest() {
            this.logger.debug("\nRequest to remote service:\n\t{}\n{}", new Object[]{this.conn.getURL().toExternalForm(), this.getLogString(this.conn.getRequestProperties())});
        }

        private void logResponse() {
            this.logger.debug("\nResponse from remote service:\n\t{}\n{}", new Object[]{this.conn.getURL().toExternalForm(), this.getLogString(this.conn.getHeaderFields())});
        }

        private String getLogString(Map<String, List<String>> map) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                List<String> list = entry.getValue();
                if (list.isEmpty()) continue;
                sb.append("\t");
                sb.append(entry.getKey());
                sb.append(": ");
                if (list.size() == 1) {
                    sb.append(list.get(0));
                } else {
                    sb.append(list.toString());
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        private String csv(Collection<String> values) {
            if (values == null || values.isEmpty()) {
                return "";
            }
            if (values.size() == 1) {
                return values.iterator().next();
            }
            StringBuilder sb = new StringBuilder();
            for (String value : values) {
                if ((value = value.trim()).isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(value);
            }
            return sb.toString().trim();
        }

        private String getDateValue() {
            return dateFormat.print(System.currentTimeMillis());
        }

        private String toString(InputStream is, Charset charset) throws IOException {
            int len;
            if (is == null) {
                return "";
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            return new String(out.toByteArray(), charset);
        }

        private InputStream getResponseStream() {
            try {
                InputStream is = this.conn.getErrorStream();
                if (is == null) {
                    is = this.conn.getInputStream();
                }
                return new BufferedInputStream(is);
            }
            catch (IOException e) {
                this.logger.warn("Response stream threw an exception: {}", new Object[]{e}, (Throwable)e);
                return null;
            }
        }

        private FlowFile writeStatusAttributes(FlowFile flowfile) {
            flowfile = this.session.putAttribute(flowfile, "invokehttp.status.code", String.valueOf(this.statusCode));
            flowfile = this.session.putAttribute(flowfile, "invokehttp.status.message", this.statusMessage);
            flowfile = this.session.putAttribute(flowfile, "invokehttp.request.url", this.conn.getURL().toExternalForm());
            flowfile = this.session.putAttribute(flowfile, "invokehttp.tx.id", Long.toString(this.txId));
            return flowfile;
        }

        private static class OverrideHostnameVerifier
        implements HostnameVerifier {
            private final String trustedHostname;
            private final HostnameVerifier delegate;

            private OverrideHostnameVerifier(String trustedHostname, HostnameVerifier delegate) {
                this.trustedHostname = trustedHostname;
                this.delegate = delegate;
            }

            @Override
            public boolean verify(String hostname, SSLSession session) {
                if (this.trustedHostname.equalsIgnoreCase(hostname)) {
                    return true;
                }
                return this.delegate.verify(hostname, session);
            }
        }
    }

    public static interface Config {
        public static final int MAX_RESULTS_PER_THREAD = 50;
        public static final String STATUS_CODE = "invokehttp.status.code";
        public static final String STATUS_MESSAGE = "invokehttp.status.message";
        public static final String RESPONSE_BODY = "invokehttp.response.body";
        public static final String REQUEST_URL = "invokehttp.request.url";
        public static final String TRANSACTION_ID = "invokehttp.tx.id";
        public static final String REMOTE_DN = "invokehttp.remote.dn";
        public static final Set<String> IGNORED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("invokehttp.status.code", "invokehttp.status.message", "invokehttp.response.body", "invokehttp.request.url", "invokehttp.tx.id", "invokehttp.remote.dn", "uuid", "filename", "path")));
        public static final PropertyDescriptor PROP_METHOD = new PropertyDescriptor.Builder().name("HTTP Method").description("HTTP request method (GET, POST, PUT, DELETE, HEAD, OPTIONS).").required(true).defaultValue("GET").expressionLanguageSupported(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        public static final PropertyDescriptor PROP_URL = new PropertyDescriptor.Builder().name("Remote URL").description("Remote URL which will be connected to, including scheme, host, port, path.").required(true).expressionLanguageSupported(true).addValidator(StandardValidators.URL_VALIDATOR).build();
        public static final PropertyDescriptor PROP_CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("Connection Timeout").description("Max wait time for connection to remote service.").required(true).defaultValue("5 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
        public static final PropertyDescriptor PROP_READ_TIMEOUT = new PropertyDescriptor.Builder().name("Read Timeout").description("Max wait time for response from remote service.").required(true).defaultValue("15 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
        public static final PropertyDescriptor PROP_DATE_HEADER = new PropertyDescriptor.Builder().name("Include Date Header").description("Include an RFC-2616 Date header in the request.").required(true).defaultValue("True").allowableValues(new String[]{"True", "False"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
        public static final PropertyDescriptor PROP_FOLLOW_REDIRECTS = new PropertyDescriptor.Builder().name("Follow Redirects").description("Follow HTTP redirects issued by remote server.").required(true).defaultValue("True").allowableValues(new String[]{"True", "False"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
        public static final PropertyDescriptor PROP_ATTRIBUTES_TO_SEND = new PropertyDescriptor.Builder().name("Attributes to Send").description("Regular expression that defines which attributes to send as HTTP headers in the request. If not defined, no attributes are sent as headers.").required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
        public static final PropertyDescriptor PROP_SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL (https) connections.").required(false).identifiesControllerService(SSLContextService.class).build();
        public static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(PROP_METHOD, PROP_URL, PROP_SSL_CONTEXT_SERVICE, PROP_CONNECT_TIMEOUT, PROP_READ_TIMEOUT, PROP_DATE_HEADER, PROP_FOLLOW_REDIRECTS, PROP_ATTRIBUTES_TO_SEND));
        public static final PropertyDescriptor PROP_TRUSTED_HOSTNAME = new PropertyDescriptor.Builder().name("Trusted Hostname").description("Bypass the normal truststore hostname verifier to allow the specified (single) remote hostname as trusted Enabling this property has MITM security implications, use wisely. Only valid with SSL (HTTPS) connections.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).build();
        public static final Relationship REL_SUCCESS_REQ = new Relationship.Builder().name("Original").description("Original FlowFile will be routed upon success (2xx status codes).").build();
        public static final Relationship REL_SUCCESS_RESP = new Relationship.Builder().name("Response").description("Response FlowFile will be routed upon success (2xx status codes).").build();
        public static final Relationship REL_RETRY = new Relationship.Builder().name("Retry").description("FlowFile will be routed on any status code that can be retried (5xx status codes).").build();
        public static final Relationship REL_NO_RETRY = new Relationship.Builder().name("No Retry").description("FlowFile will be routed on any status code that should NOT be retried (1xx, 3xx, 4xx status codes).").build();
        public static final Relationship REL_FAILURE = new Relationship.Builder().name("Failure").description("FlowFile will be routed on any type of connection failure, timeout or general exception.").build();
        public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS_REQ, REL_SUCCESS_RESP, REL_RETRY, REL_NO_RETRY, REL_FAILURE)));
    }
}

