/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;

@EventDriven
@SideEffectFree
@Tags(value={"binary", "discard", "keep"})
@CapabilityDescription(value="Keep or discard bytes range from a binary file.")
public class ModifyBytes
extends AbstractProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Processed flowfiles.").build();
    private final Set<Relationship> relationships;
    public static final PropertyDescriptor START_OFFSET = new PropertyDescriptor.Builder().name("Start Offset").description("Number of bytes removed at the beginning of the file.").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("0 B").build();
    public static final PropertyDescriptor END_OFFSET = new PropertyDescriptor.Builder().name("End Offset").description("Number of bytes removed at the end of the file.").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("0 B").build();
    private final List<PropertyDescriptor> propDescriptors;

    public ModifyBytes() {
        HashSet<Relationship> r = new HashSet<Relationship>();
        r.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(r);
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(START_OFFSET);
        pds.add(END_OFFSET);
        this.propDescriptors = Collections.unmodifiableList(pds);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propDescriptors;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile ff = session.get();
        if (null == ff) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        final int startOffset = context.getProperty(START_OFFSET).asDataSize(DataUnit.B).intValue();
        int endOffset = context.getProperty(END_OFFSET).asDataSize(DataUnit.B).intValue();
        final int newFileSize = (int)ff.getSize() - startOffset - endOffset;
        StopWatch stopWatch = new StopWatch(true);
        ff = newFileSize <= 0 ? session.write(ff, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                out.write(new byte[0]);
            }
        }) : session.write(ff, new StreamCallback(){

            public void process(InputStream in, OutputStream out) throws IOException {
                in.skip(startOffset);
                StreamUtils.copy((InputStream)in, (OutputStream)out, (long)newFileSize);
            }
        });
        logger.info("Transferred {} to 'success'", new Object[]{ff});
        session.getProvenanceReporter().modifyContent(ff, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
        session.transfer(ff, REL_SUCCESS);
    }
}

