/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.EncryptContent;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;

public class OpenPGPKeyBasedEncryptor
implements EncryptContent.Encryptor {
    private String algorithm;
    private String provider;
    private String keyring;
    private String userId;
    private char[] passphrase;
    private String filename;
    public static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";

    public OpenPGPKeyBasedEncryptor(String algorithm, String provider, String keyring, String userId, char[] passphrase, String filename) {
        this.algorithm = algorithm;
        this.provider = provider;
        this.keyring = keyring;
        this.userId = userId;
        this.passphrase = passphrase;
        this.filename = filename;
    }

    @Override
    public StreamCallback getEncryptionCallback() throws Exception {
        return new OpenPGPEncryptCallback(this.algorithm, this.provider, this.keyring, this.userId, this.filename);
    }

    @Override
    public StreamCallback getDecryptionCallback() throws Exception {
        return new OpenPGPDecryptCallback(this.provider, this.keyring, this.passphrase);
    }

    public static boolean validateKeyring(String provider, String secretKeyringFile, char[] passphrase) throws IOException, PGPException, NoSuchProviderException {
        PGPSecretKeyRingCollection pgpsec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)Files.newInputStream(Paths.get(secretKeyringFile, new String[0]), new OpenOption[0])));
        Iterator ringit = pgpsec.getKeyRings();
        if (ringit.hasNext()) {
            PGPSecretKeyRing secretkeyring = (PGPSecretKeyRing)ringit.next();
            PGPSecretKey secretkey = secretkeyring.getSecretKey();
            secretkey.extractPrivateKey(passphrase, provider);
            return true;
        }
        return false;
    }

    public static PGPPublicKey getPublicKey(String userId, String publicKeyring) throws IOException, PGPException {
        PGPPublicKey pubkey = null;
        PGPPublicKeyRingCollection pgppub = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)Files.newInputStream(Paths.get(publicKeyring, new String[0]), new OpenOption[0])));
        Iterator ringit = pgppub.getKeyRings();
        while (ringit.hasNext()) {
            PGPPublicKeyRing kring = (PGPPublicKeyRing)ringit.next();
            Iterator keyit = kring.getPublicKeys();
            while (keyit.hasNext()) {
                pubkey = (PGPPublicKey)keyit.next();
                boolean userIdMatch = false;
                Iterator userit = pubkey.getUserIDs();
                while (userit.hasNext()) {
                    String id = userit.next().toString();
                    if (!id.contains(userId)) continue;
                    userIdMatch = true;
                    break;
                }
                if (!pubkey.isEncryptionKey() || !userIdMatch) continue;
                return pubkey;
            }
        }
        return null;
    }

    private class OpenPGPEncryptCallback
    implements StreamCallback {
        private String algorithm;
        private String provider;
        private String publicKeyring;
        private String userId;
        private String filename;

        OpenPGPEncryptCallback(String algorithm, String provider, String keyring, String userId, String filename) {
            this.algorithm = algorithm;
            this.provider = provider;
            this.publicKeyring = keyring;
            this.userId = userId;
            this.filename = filename;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            PGPPublicKey publicKey;
            try {
                publicKey = OpenPGPKeyBasedEncryptor.getPublicKey(this.userId, this.publicKeyring);
            }
            catch (Exception e) {
                throw new ProcessException("Invalid public keyring - " + e.getMessage());
            }
            try {
                int len;
                SecureRandom secureRandom = SecureRandom.getInstance(OpenPGPKeyBasedEncryptor.SECURE_RANDOM_ALGORITHM);
                OutputStream output = out;
                if (EncryptContent.isPGPArmoredAlgorithm(this.algorithm)) {
                    output = new ArmoredOutputStream(out);
                }
                PGPEncryptedDataGenerator encGenerator = new PGPEncryptedDataGenerator(3, false, secureRandom, this.provider);
                encGenerator.addMethod(publicKey);
                OutputStream encOut = encGenerator.open(output, new byte[65536]);
                PGPCompressedDataGenerator compData = new PGPCompressedDataGenerator(1, 1);
                OutputStream compOut = compData.open(encOut, new byte[65536]);
                PGPLiteralDataGenerator literal = new PGPLiteralDataGenerator();
                OutputStream literalOut = literal.open(compOut, 'b', this.filename, new Date(), new byte[65536]);
                byte[] buffer = new byte[4096];
                while ((len = in.read(buffer)) >= 0) {
                    literalOut.write(buffer, 0, len);
                }
                literalOut.close();
                compOut.close();
                encOut.close();
                output.close();
            }
            catch (Exception e) {
                throw new ProcessException(e.getMessage());
            }
        }
    }

    private class OpenPGPDecryptCallback
    implements StreamCallback {
        private String provider;
        private String secretKeyring;
        private char[] passphrase;

        OpenPGPDecryptCallback(String provider, String keyring, char[] passphrase) {
            this.provider = provider;
            this.secretKeyring = keyring;
            this.passphrase = passphrase;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            PGPSecretKeyRingCollection pgpSecretKeyring;
            InputStream pgpin = PGPUtil.getDecoderStream((InputStream)in);
            PGPObjectFactory pgpFactory = new PGPObjectFactory(pgpin);
            Object obj = pgpFactory.nextObject();
            if (!(obj instanceof PGPEncryptedDataList) && !((obj = pgpFactory.nextObject()) instanceof PGPEncryptedDataList)) {
                throw new ProcessException("Invalid OpenPGP data");
            }
            PGPEncryptedDataList encList = (PGPEncryptedDataList)obj;
            try {
                pgpSecretKeyring = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)Files.newInputStream(Paths.get(this.secretKeyring, new String[0]), new OpenOption[0])));
            }
            catch (Exception e) {
                throw new ProcessException("Invalid secret keyring - " + e.getMessage());
            }
            try {
                int len;
                PGPPrivateKey privateKey = null;
                PGPPublicKeyEncryptedData encData = null;
                Iterator it = encList.getEncryptedDataObjects();
                while (privateKey == null && it.hasNext()) {
                    obj = it.next();
                    if (!(obj instanceof PGPPublicKeyEncryptedData)) {
                        throw new ProcessException("Invalid OpenPGP data");
                    }
                    encData = (PGPPublicKeyEncryptedData)obj;
                    PGPSecretKey secretkey = pgpSecretKeyring.getSecretKey(encData.getKeyID());
                    if (secretkey == null) continue;
                    privateKey = secretkey.extractPrivateKey(this.passphrase, this.provider);
                }
                if (privateKey == null) {
                    throw new ProcessException("Secret keyring does not contain the key required to decrypt");
                }
                InputStream clearData = encData.getDataStream(privateKey, this.provider);
                PGPObjectFactory clearFactory = new PGPObjectFactory(clearData);
                obj = clearFactory.nextObject();
                if (obj instanceof PGPCompressedData) {
                    PGPCompressedData compData = (PGPCompressedData)obj;
                    clearFactory = new PGPObjectFactory(compData.getDataStream());
                    obj = clearFactory.nextObject();
                }
                PGPLiteralData literal = (PGPLiteralData)obj;
                InputStream lis = literal.getInputStream();
                byte[] buffer = new byte[4096];
                while ((len = lis.read(buffer)) >= 0) {
                    out.write(buffer, 0, len);
                }
            }
            catch (Exception e) {
                throw new ProcessException(e.getMessage());
            }
        }
    }
}

