/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@EventDriven
@SupportsBatching
@Tags(value={"test", "load", "duplicate"})
@CapabilityDescription(value="Intended for load testing, this processor will create the configured number of copies of each incoming FlowFile")
public class DuplicateFlowFile
extends AbstractProcessor {
    static final PropertyDescriptor NUM_COPIES = new PropertyDescriptor.Builder().name("Number of Copies").description("Specifies how many copies of each incoming FlowFile will be made").required(true).expressionLanguageSupported(false).defaultValue("100").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The original FlowFile and all copies will be sent to this relationship").build();

    public Set<Relationship> getRelationships() {
        return Collections.singleton(REL_SUCCESS);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(NUM_COPIES);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        for (int i = 0; i < context.getProperty(NUM_COPIES).asInteger(); ++i) {
            FlowFile copy = session.clone(flowFile);
            session.transfer(copy, REL_SUCCESS);
        }
        session.transfer(flowFile, REL_SUCCESS);
    }
}

