/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import net.sf.saxon.xpath.XPathEvaluator;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.util.ObjectHolder;
import org.xml.sax.InputSource;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"XML", "evaluate", "XPath"})
@CapabilityDescription(value="Evaluates one or more XPaths against the content of a FlowFile. The results of those XPaths are assigned to FlowFile Attributes or are written to the content of the FlowFile itself, depending on configuration of the Processor. XPaths are entered by adding user-defined properties; the name of the property maps to the Attribute Name into which the result will be placed (if the Destination is flowfile-attribute; otherwise, the property name is ignored). The value of the property must be a valid XPath expression. If the XPath evaluates to more than one node and the Return Type is set to 'nodeset' (either directly, or via 'auto-detect' with a Destination of 'flowfile-content'), the FlowFile will be unmodified and will be routed to failure. If the XPath does not evaluate to a Node, the FlowFile will be routed to 'unmatched' without having its contents modified. If Destination is flowfile-attribute and the expression matches nothing, attributes will be created with empty strings as the value, and the FlowFile will always be routed to 'matched'")
@WritesAttribute(attribute="user-defined", description="This processor adds user-defined attributes if the <Destination> property is set to flowfile-attribute.")
@DynamicProperty(name="A FlowFile attribute(if <Destination> is set to 'flowfile-attribute'", value="An XPath expression", description="If <Destination>='flowfile-attribute' then the FlowFile attribute is set to the result of the XPath Expression.  If <Destination>='flowfile-content' then the FlowFile content is set to the result of the XPath Expression.")
public class EvaluateXPath
extends AbstractProcessor {
    public static final String DESTINATION_ATTRIBUTE = "flowfile-attribute";
    public static final String DESTINATION_CONTENT = "flowfile-content";
    public static final String RETURN_TYPE_AUTO = "auto-detect";
    public static final String RETURN_TYPE_NODESET = "nodeset";
    public static final String RETURN_TYPE_STRING = "string";
    public static final PropertyDescriptor DESTINATION = new PropertyDescriptor.Builder().name("Destination").description("Indicates whether the results of the XPath evaluation are written to the FlowFile content or a FlowFile attribute; if using attribute, must specify the Attribute Name property. If set to flowfile-content, only one XPath may be specified, and the property name is ignored.").required(true).allowableValues(new String[]{"flowfile-content", "flowfile-attribute"}).defaultValue("flowfile-content").build();
    public static final PropertyDescriptor RETURN_TYPE = new PropertyDescriptor.Builder().name("Return Type").description("Indicates the desired return type of the Xpath expressions.  Selecting 'auto-detect' will set the return type to 'nodeset' for a Destination of 'flowfile-content', and 'string' for a Destination of 'flowfile-attribute'.").required(true).allowableValues(new String[]{"auto-detect", "nodeset", "string"}).defaultValue("auto-detect").build();
    public static final Relationship REL_MATCH = new Relationship.Builder().name("matched").description("FlowFiles are routed to this relationship when the XPath is successfully evaluated and the FlowFile is modified as a result").build();
    public static final Relationship REL_NO_MATCH = new Relationship.Builder().name("unmatched").description("FlowFiles are routed to this relationship when the XPath does not match the content of the FlowFile and the Destination is set to flowfile-content").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to this relationship when the XPath cannot be evaluated against the content of the FlowFile; for instance, if the FlowFile is not valid XML, or if the Return Type is 'nodeset' and the XPath evaluates to multiple nodes").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final AtomicReference<XPathFactory> factoryRef = new AtomicReference();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_MATCH);
        relationships.add(REL_NO_MATCH);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(DESTINATION);
        properties.add(RETURN_TYPE);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(context));
        String destination = context.getProperty(DESTINATION).getValue();
        if (DESTINATION_CONTENT.equals(destination)) {
            int xpathCount = 0;
            for (PropertyDescriptor desc : context.getProperties().keySet()) {
                if (!desc.isDynamic()) continue;
                ++xpathCount;
            }
            if (xpathCount != 1) {
                results.add(new ValidationResult.Builder().subject("XPaths").valid(false).explanation("Exactly one XPath must be set if using destination of flowfile-content").build());
            }
        }
        return results;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @OnScheduled
    public void initializeXPathFactory() throws XPathFactoryConfigurationException {
        this.factoryRef.set(XPathFactory.newInstance("http://saxon.sf.net/jaxp/xpath/om"));
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).expressionLanguageSupported(false).addValidator((Validator)new XPathValidator()).required(false).dynamic(true).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        QName returnType;
        XPathExpression slashExpression;
        List flowFiles = session.get(50);
        if (flowFiles.isEmpty()) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        XPathFactory factory = this.factoryRef.get();
        XPathEvaluator xpathEvaluator = (XPathEvaluator)factory.newXPath();
        HashMap<String, XPathExpression> attributeToXPathMap = new HashMap<String, XPathExpression>();
        for (Map.Entry entry : context.getProperties().entrySet()) {
            if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
            try {
                XPathExpression xpathExpression = xpathEvaluator.compile((String)entry.getValue());
                attributeToXPathMap.put(((PropertyDescriptor)entry.getKey()).getName(), xpathExpression);
            }
            catch (XPathExpressionException e) {
                throw new ProcessException((Throwable)e);
            }
        }
        try {
            slashExpression = xpathEvaluator.compile("/");
        }
        catch (XPathExpressionException e) {
            logger.error("unable to compile XPath expression due to {}", new Object[]{e});
            session.transfer((Collection)flowFiles, REL_FAILURE);
            return;
        }
        String destination = context.getProperty(DESTINATION).getValue();
        switch (context.getProperty(RETURN_TYPE).getValue()) {
            case "auto-detect": {
                if (DESTINATION_ATTRIBUTE.equals(destination)) {
                    returnType = XPathConstants.STRING;
                    break;
                }
                if (DESTINATION_CONTENT.equals(destination)) {
                    returnType = XPathConstants.NODESET;
                    break;
                }
                throw new IllegalStateException("The only possible destinations should be CONTENT or ATTRIBUTE...");
            }
            case "nodeset": {
                returnType = XPathConstants.NODESET;
                break;
            }
            case "string": {
                returnType = XPathConstants.STRING;
                break;
            }
            default: {
                throw new IllegalStateException("There are no other return types...");
            }
        }
        block20: for (FlowFile flowFile : flowFiles) {
            final ObjectHolder error = new ObjectHolder(null);
            final ObjectHolder sourceRef = new ObjectHolder(null);
            session.read(flowFile, new InputStreamCallback(){

                public void process(InputStream rawIn) throws IOException {
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                        List rootList = (List)slashExpression.evaluate(new InputSource((InputStream)in), XPathConstants.NODESET);
                        sourceRef.set(rootList.get(0));
                    }
                    catch (Exception e) {
                        error.set((Object)e);
                    }
                }
            });
            if (error.get() != null) {
                logger.error("unable to evaluate XPath against {} due to {}; routing to 'failure'", new Object[]{flowFile, error.get()});
                session.transfer(flowFile, REL_FAILURE);
                continue;
            }
            HashMap xpathResults = new HashMap();
            for (Map.Entry entry : attributeToXPathMap.entrySet()) {
                Object result = null;
                try {
                    result = ((XPathExpression)entry.getValue()).evaluate(sourceRef.get(), returnType);
                    if (result == null) {
                        continue;
                    }
                }
                catch (XPathExpressionException e) {
                    logger.error("failed to evaluate XPath for {} for Property {} due to {}; routing to failure", new Object[]{flowFile, entry.getKey(), e});
                    session.transfer(flowFile, REL_FAILURE);
                    continue block20;
                }
                if (returnType == XPathConstants.NODESET) {
                    List nodeList = (List)result;
                    if (nodeList.isEmpty()) {
                        logger.info("Routing {} to 'unmatched'", new Object[]{flowFile});
                        session.transfer(flowFile, REL_NO_MATCH);
                        continue block20;
                    }
                    if (nodeList.size() > 1) {
                        logger.error("Routing {} to 'failure' because the XPath evaluated to {} XML nodes", new Object[]{flowFile, nodeList.size()});
                        session.transfer(flowFile, REL_FAILURE);
                        continue block20;
                    }
                    final Source sourceNode = (Source)nodeList.get(0);
                    if (DESTINATION_ATTRIBUTE.equals(destination)) {
                        try {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            this.doTransform(sourceNode, baos);
                            xpathResults.put(entry.getKey(), baos.toString("UTF-8"));
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new ProcessException((Throwable)e);
                        }
                        catch (TransformerException e) {
                            error.set((Object)e);
                            continue;
                        }
                    }
                    if (!DESTINATION_CONTENT.equals(destination)) continue;
                    flowFile = session.write(flowFile, new OutputStreamCallback(){

                        public void process(OutputStream rawOut) throws IOException {
                            try (BufferedOutputStream out = new BufferedOutputStream(rawOut);){
                                EvaluateXPath.this.doTransform(sourceNode, (OutputStream)out);
                            }
                            catch (TransformerException e) {
                                error.set((Object)e);
                            }
                        }
                    });
                    continue;
                }
                if (returnType != XPathConstants.STRING) continue;
                final String resultString = (String)result;
                if (DESTINATION_ATTRIBUTE.equals(destination)) {
                    xpathResults.put(entry.getKey(), resultString);
                    continue;
                }
                if (!DESTINATION_CONTENT.equals(destination)) continue;
                flowFile = session.write(flowFile, new OutputStreamCallback(){

                    public void process(OutputStream rawOut) throws IOException {
                        try (BufferedOutputStream out = new BufferedOutputStream(rawOut);){
                            out.write(resultString.getBytes("UTF-8"));
                        }
                    }
                });
            }
            if (error.get() == null) {
                if (DESTINATION_ATTRIBUTE.equals(destination)) {
                    flowFile = session.putAllAttributes(flowFile, xpathResults);
                    Relationship destRel = xpathResults.isEmpty() ? REL_NO_MATCH : REL_MATCH;
                    logger.info("Successfully evaluated XPaths against {} and found {} matches; routing to {}", new Object[]{flowFile, xpathResults.size(), destRel.getName()});
                    session.transfer(flowFile, destRel);
                    session.getProvenanceReporter().modifyAttributes(flowFile);
                    continue;
                }
                if (!DESTINATION_CONTENT.equals(destination)) continue;
                logger.info("Successfully updated content for {}; routing to 'matched'", new Object[]{flowFile});
                session.transfer(flowFile, REL_MATCH);
                session.getProvenanceReporter().modifyContent(flowFile);
                continue;
            }
            logger.error("Failed to write XPath result for {} due to {}; routing original to 'failure'", new Object[]{flowFile, error.get()});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private void doTransform(Source sourceNode, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("indent", "no");
        props.setProperty("omit-xml-declaration", "no");
        transformer.setOutputProperties(props);
        final ProcessorLog logger = this.getLogger();
        final ObjectHolder error = new ObjectHolder(null);
        transformer.setErrorListener(new ErrorListener(){

            @Override
            public void warning(TransformerException exception) throws TransformerException {
                logger.warn("Encountered warning from XPath Engine: ", new Object[]{exception.toString(), exception});
            }

            @Override
            public void error(TransformerException exception) throws TransformerException {
                logger.error("Encountered error from XPath Engine: ", new Object[]{exception.toString(), exception});
                error.set((Object)exception);
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
                logger.error("Encountered warning from XPath Engine: ", new Object[]{exception.toString(), exception});
                error.set((Object)exception);
            }
        });
        transformer.transform(sourceNode, new StreamResult(out));
        if (error.get() != null) {
            throw (TransformerException)error.get();
        }
    }

    static {
        System.setProperty("javax.xml.xpath.XPathFactory:http://saxon.sf.net/jaxp/xpath/om", "net.sf.saxon.xpath.XPathFactoryImpl");
    }

    private static class XPathValidator
    implements Validator {
        private XPathValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext validationContext) {
            try {
                XPathFactory factory = XPathFactory.newInstance("http://saxon.sf.net/jaxp/xpath/om");
                XPathEvaluator evaluator = (XPathEvaluator)factory.newXPath();
                String error = null;
                try {
                    evaluator.compile(input);
                }
                catch (Exception e) {
                    error = e.toString();
                }
                return new ValidationResult.Builder().input(input).subject(subject).valid(error == null).explanation(error).build();
            }
            catch (Exception e) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Unable to initialize XPath engine due to " + e.toString()).build();
            }
        }
    }
}

