/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.BinFiles;
import org.apache.nifi.processors.standard.SegmentContent;
import org.apache.nifi.processors.standard.util.Bin;
import org.apache.nifi.processors.standard.util.BinManager;
import org.apache.nifi.processors.standard.util.FlowFileSessionWrapper;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.stream.io.NonCloseableOutputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.FlowFilePackager;
import org.apache.nifi.util.FlowFilePackagerV1;
import org.apache.nifi.util.FlowFilePackagerV2;
import org.apache.nifi.util.FlowFilePackagerV3;
import org.apache.nifi.util.ObjectHolder;

@SideEffectFree
@TriggerWhenEmpty
@Tags(value={"merge", "content", "correlation", "tar", "zip", "stream", "concatenation", "archive", "flowfile-stream", "flowfile-stream-v3"})
@CapabilityDescription(value="Merges a Group of FlowFiles together based on a user-defined strategy and packages them into a single FlowFile. It is recommended that the Processor be configured with only a single incoming connection, as Group of FlowFiles will not be created from FlowFiles in different connections. This processor updates the mime.type attribute as appropriate.")
@ReadsAttributes(value={@ReadsAttribute(attribute="fragment.identifier", description="Applicable only if the <Merge Strategy> property is set to Defragment. All FlowFiles with the same value for this attribute will be bundled together."), @ReadsAttribute(attribute="fragment.index", description="Applicable only if the <Merge Strategy> property is set to Defragment. This attribute indicates the order in which the fragments should be assembled. This attribute must be present on all FlowFiles when using the Defragment Merge Strategy and must be a unique (i.e., unique across all FlowFiles that have the same value for the \"fragment.identifier\" attribute) integer between 0 and the value of the fragment.count attribute. If two or more FlowFiles have the same value for the \"fragment.identifier\" attribute and the same value for the \"fragment.index\" attribute, the behavior of this Processor is undefined."), @ReadsAttribute(attribute="fragment.count", description="Applicable only if the <Merge Strategy> property is set to Defragment. This attribute must be present on all FlowFiles with the same value for the fragment.identifier attribute. All FlowFiles in the same bundle must have the same value for this attribute. The value of this attribute indicates how many FlowFiles should be expected in the given bundle."), @ReadsAttribute(attribute="segment.original.filename", description="Applicable only if the <Merge Strategy> property is set to Defragment. This attribute must be present on all FlowFiles with the same value for the fragment.identifier attribute. All FlowFiles in the same bundle must have the same value for this attribute. The value of this attribute will be used for the filename of the completed merged FlowFile."), @ReadsAttribute(attribute="tar.permissions", description="Applicable only if the <Merge Format> property is set to TAR. The value of this attribute must be 3 characters; each character must be in the range 0 to 7 (inclusive) and indicates the file permissions that should be used for the FlowFile's TAR entry. If this attribute is missing or has an invalid value, the default value of 644 will be used")})
@WritesAttributes(value={@WritesAttribute(attribute="filename", description="When more than 1 file is merged, the filename comes from the segment.original.filename attribute. If that attribute does not exist in the source FlowFiles, then the filename is set to the number of nanoseconds matching system time. Then a filename extension may be applied:if Merge Format is TAR, then the filename will be appended with .tar, if Merge Format is ZIP, then the filename will be appended with .zip, if Merge Format is FlowFileStream, then the filename will be appended with .pkg"), @WritesAttribute(attribute="merge.count", description="The number of FlowFiles that were merged into this bundle"), @WritesAttribute(attribute="merge.bin.age", description="The age of the bin, in milliseconds, when it was merged and output. Effectively this is the greatest amount of time that any FlowFile in this bundle remained waiting in this processor before it was output")})
@SeeAlso(value={SegmentContent.class})
public class MergeContent
extends BinFiles {
    public static final String FRAGMENT_ID_ATTRIBUTE = "fragment.identifier";
    public static final String FRAGMENT_INDEX_ATTRIBUTE = "fragment.index";
    public static final String FRAGMENT_COUNT_ATTRIBUTE = "fragment.count";
    public static final String SEGMENT_ID_ATTRIBUTE = "segment.identifier";
    public static final String SEGMENT_INDEX_ATTRIBUTE = "segment.index";
    public static final String SEGMENT_COUNT_ATTRIBUTE = "segment.count";
    public static final String SEGMENT_ORIGINAL_FILENAME = "segment.original.filename";
    public static final AllowableValue MERGE_STRATEGY_BIN_PACK = new AllowableValue("Bin-Packing Algorithm", "Bin-Packing Algorithm", "Generates 'bins' of FlowFiles and fills each bin as full as possible. FlowFiles are placed into a bin based on their size and optionally their attributes (if the <Correlation Attribute> property is set)");
    public static final AllowableValue MERGE_STRATEGY_DEFRAGMENT = new AllowableValue("Defragment", "Defragment", "Combines fragments that are associated by attributes back into a single cohesive FlowFile. If using this strategy, all FlowFiles must have the attributes <fragment.identifier>, <fragment.count>, and <fragment.index> or alternatively (for backward compatibility purposes) <segment.identifier>, <segment.count>, and <segment.index>. All FlowFiles with the same value for \"fragment.identifier\" will be grouped together. All FlowFiles in this group must have the same value for the \"fragment.count\" attribute. All FlowFiles in this group must have a unique value for the \"fragment.index\" attribute between 0 and the value of the \"fragment.count\" attribute.");
    public static final AllowableValue DELIMITER_STRATEGY_FILENAME = new AllowableValue("Filename", "Filename", "The values of Header, Footer, and Demarcator will be retrieved from the contents of a file");
    public static final AllowableValue DELIMITER_STRATEGY_TEXT = new AllowableValue("Text", "Text", "The values of Header, Footer, and Demarcator will be specified as property values");
    public static final String MERGE_FORMAT_TAR_VALUE = "TAR";
    public static final String MERGE_FORMAT_ZIP_VALUE = "ZIP";
    public static final String MERGE_FORMAT_FLOWFILE_STREAM_V3_VALUE = "FlowFile Stream, v3";
    public static final String MERGE_FORMAT_FLOWFILE_STREAM_V2_VALUE = "FlowFile Stream, v2";
    public static final String MERGE_FORMAT_FLOWFILE_TAR_V1_VALUE = "FlowFile Tar, v1";
    public static final String MERGE_FORMAT_CONCAT_VALUE = "Binary Concatenation";
    public static final AllowableValue MERGE_FORMAT_TAR = new AllowableValue("TAR", "TAR", "A bin of FlowFiles will be combined into a single TAR file. The FlowFiles' <path> attribute will be used to create a directory in the TAR file if the <Keep Paths> property is set to true; otherwise, all FlowFiles will be added at the root of the TAR file. If a FlowFile has an attribute named <tar.permissions> that is 3 characters, each between 0-7, that attribute will be used as the TAR entry's 'mode'.");
    public static final AllowableValue MERGE_FORMAT_ZIP = new AllowableValue("ZIP", "ZIP", "A bin of FlowFiles will be combined into a single ZIP file. The FlowFiles' <path> attribute will be used to create a directory in the ZIP file if the <Keep Paths> property is set to true; otherwise, all FlowFiles will be added at the root of the ZIP file. The <Compression Level> property indicates the ZIP compression to use.");
    public static final AllowableValue MERGE_FORMAT_FLOWFILE_STREAM_V3 = new AllowableValue("FlowFile Stream, v3", "FlowFile Stream, v3", "A bin of FlowFiles will be combined into a single Version 3 FlowFile Stream");
    public static final AllowableValue MERGE_FORMAT_FLOWFILE_STREAM_V2 = new AllowableValue("FlowFile Stream, v2", "FlowFile Stream, v2", "A bin of FlowFiles will be combined into a single Version 2 FlowFile Stream");
    public static final AllowableValue MERGE_FORMAT_FLOWFILE_TAR_V1 = new AllowableValue("FlowFile Tar, v1", "FlowFile Tar, v1", "A bin of FlowFiles will be combined into a single Version 1 FlowFile Package");
    public static final AllowableValue MERGE_FORMAT_CONCAT = new AllowableValue("Binary Concatenation", "Binary Concatenation", "The contents of all FlowFiles will be concatenated together into a single FlowFile");
    public static final String ATTRIBUTE_STRATEGY_ALL_COMMON = "Keep Only Common Attributes";
    public static final String ATTRIBUTE_STRATEGY_ALL_UNIQUE = "Keep All Unique Attributes";
    public static final String TAR_PERMISSIONS_ATTRIBUTE = "tar.permissions";
    public static final String MERGE_COUNT_ATTRIBUTE = "merge.count";
    public static final String MERGE_BIN_AGE_ATTRIBUTE = "merge.bin.age";
    public static final PropertyDescriptor MERGE_STRATEGY = new PropertyDescriptor.Builder().name("Merge Strategy").description("Specifies the algorithm used to merge content. The 'Defragment' algorithm combines fragments that are associated by attributes back into a single cohesive FlowFile. The 'Bin-Packing Algorithm' generates a FlowFile populated by arbitrarily chosen FlowFiles").required(true).allowableValues(new AllowableValue[]{MERGE_STRATEGY_BIN_PACK, MERGE_STRATEGY_DEFRAGMENT}).defaultValue(MERGE_STRATEGY_BIN_PACK.getValue()).build();
    public static final PropertyDescriptor MERGE_FORMAT = new PropertyDescriptor.Builder().required(true).name("Merge Format").description("Determines the format that will be used to merge the content.").allowableValues(new AllowableValue[]{MERGE_FORMAT_TAR, MERGE_FORMAT_ZIP, MERGE_FORMAT_FLOWFILE_STREAM_V3, MERGE_FORMAT_FLOWFILE_STREAM_V2, MERGE_FORMAT_FLOWFILE_TAR_V1, MERGE_FORMAT_CONCAT}).defaultValue(MERGE_FORMAT_CONCAT.getValue()).build();
    public static final PropertyDescriptor ATTRIBUTE_STRATEGY = new PropertyDescriptor.Builder().required(true).name("Attribute Strategy").description("Determines which FlowFile attributes should be added to the bundle. If 'Keep All Unique Attributes' is selected, any attribute on any FlowFile that gets bundled will be kept unless its value conflicts with the value from another FlowFile. If 'Keep Only Common Attributes' is selected, only the attributes that exist on all FlowFiles in the bundle, with the same value, will be preserved.").allowableValues(new String[]{"Keep Only Common Attributes", "Keep All Unique Attributes"}).defaultValue("Keep Only Common Attributes").build();
    public static final PropertyDescriptor CORRELATION_ATTRIBUTE_NAME = new PropertyDescriptor.Builder().name("Correlation Attribute Name").description("If specified, like FlowFiles will be binned together, where 'like FlowFiles' means FlowFiles that have the same value for this Attribute. If not specified, FlowFiles are bundled by the order in which they are pulled from the queue.").required(false).addValidator(StandardValidators.ATTRIBUTE_KEY_VALIDATOR).defaultValue(null).build();
    public static final PropertyDescriptor DELIMITER_STRATEGY = new PropertyDescriptor.Builder().required(true).name("Delimiter Strategy").description("Determines if Header, Footer, and Demarcator should point to files containing the respective content, or if the values of the properties should be used as the content.").allowableValues(new AllowableValue[]{DELIMITER_STRATEGY_FILENAME, DELIMITER_STRATEGY_TEXT}).defaultValue(DELIMITER_STRATEGY_FILENAME.getValue()).build();
    public static final PropertyDescriptor HEADER = new PropertyDescriptor.Builder().name("Header File").displayName("Header").description("Filename specifying the header to use. If not specified, no header is supplied. This property is valid only when using the binary-concatenation merge strategy; otherwise, it is ignored.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor FOOTER = new PropertyDescriptor.Builder().name("Footer File").displayName("Footer").description("Filename specifying the footer to use. If not specified, no footer is supplied. This property is valid only when using the binary-concatenation merge strategy; otherwise, it is ignored.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor DEMARCATOR = new PropertyDescriptor.Builder().name("Demarcator File").displayName("Demarcator").description("Filename specifying the demarcator to use. If not specified, no demarcator is supplied. This property is valid only when using the binary-concatenation merge strategy; otherwise, it is ignored.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor COMPRESSION_LEVEL = new PropertyDescriptor.Builder().name("Compression Level").description("Specifies the compression level to use when using the Zip Merge Format; if not using the Zip Merge Format, this value is ignored").required(true).allowableValues(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}).defaultValue("1").build();
    public static final PropertyDescriptor KEEP_PATH = new PropertyDescriptor.Builder().name("Keep Path").description("If using the Zip or Tar Merge Format, specifies whether or not the FlowFiles' paths should be included in their entry names; if using other merge strategy, this value is ignored").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final Relationship REL_MERGED = new Relationship.Builder().name("merged").description("The FlowFile containing the merged content").build();
    public static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");

    public Set<Relationship> getRelationships() {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_FAILURE);
        relationships.add(REL_MERGED);
        return relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(MERGE_STRATEGY);
        descriptors.add(MERGE_FORMAT);
        descriptors.add(ATTRIBUTE_STRATEGY);
        descriptors.add(CORRELATION_ATTRIBUTE_NAME);
        descriptors.add(MIN_ENTRIES);
        descriptors.add(MAX_ENTRIES);
        descriptors.add(MIN_SIZE);
        descriptors.add(MAX_SIZE);
        descriptors.add(MAX_BIN_AGE);
        descriptors.add(MAX_BIN_COUNT);
        descriptors.add(DELIMITER_STRATEGY);
        descriptors.add(HEADER);
        descriptors.add(FOOTER);
        descriptors.add(DEMARCATOR);
        descriptors.add(COMPRESSION_LEVEL);
        descriptors.add(KEEP_PATH);
        return descriptors;
    }

    @Override
    protected Collection<ValidationResult> additionalCustomValidation(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String delimiterStrategy = context.getProperty(DELIMITER_STRATEGY).getValue();
        if (DELIMITER_STRATEGY_FILENAME.equals((Object)delimiterStrategy)) {
            String demarcatorValue;
            String footerValue;
            String headerValue = context.getProperty(HEADER).getValue();
            if (headerValue != null) {
                results.add(StandardValidators.FILE_EXISTS_VALIDATOR.validate(HEADER.getName(), headerValue, context));
            }
            if ((footerValue = context.getProperty(FOOTER).getValue()) != null) {
                results.add(StandardValidators.FILE_EXISTS_VALIDATOR.validate(FOOTER.getName(), footerValue, context));
            }
            if ((demarcatorValue = context.getProperty(DEMARCATOR).getValue()) != null) {
                results.add(StandardValidators.FILE_EXISTS_VALIDATOR.validate(DEMARCATOR.getName(), demarcatorValue, context));
            }
        }
        return results;
    }

    private byte[] readContent(String filename) throws IOException {
        return Files.readAllBytes(Paths.get(filename, new String[0]));
    }

    @Override
    protected FlowFile preprocessFlowFile(ProcessContext context, ProcessSession session, FlowFile flowFile) {
        FlowFile processed = flowFile;
        if (processed.getAttribute(FRAGMENT_COUNT_ATTRIBUTE) == null && processed.getAttribute(SEGMENT_COUNT_ATTRIBUTE) != null) {
            processed = session.putAttribute(processed, FRAGMENT_COUNT_ATTRIBUTE, processed.getAttribute(SEGMENT_COUNT_ATTRIBUTE));
        }
        if (processed.getAttribute(FRAGMENT_INDEX_ATTRIBUTE) == null && processed.getAttribute(SEGMENT_INDEX_ATTRIBUTE) != null) {
            processed = session.putAttribute(processed, FRAGMENT_INDEX_ATTRIBUTE, processed.getAttribute(SEGMENT_INDEX_ATTRIBUTE));
        }
        if (processed.getAttribute(FRAGMENT_ID_ATTRIBUTE) == null && processed.getAttribute(SEGMENT_ID_ATTRIBUTE) != null) {
            processed = session.putAttribute(processed, FRAGMENT_ID_ATTRIBUTE, processed.getAttribute(SEGMENT_ID_ATTRIBUTE));
        }
        return processed;
    }

    @Override
    protected String getGroupId(ProcessContext context, FlowFile flowFile) {
        String groupId;
        String correlationAttributeName = context.getProperty(CORRELATION_ATTRIBUTE_NAME).getValue();
        String string = groupId = correlationAttributeName == null ? null : flowFile.getAttribute(correlationAttributeName);
        if (groupId == null && MERGE_STRATEGY_DEFRAGMENT.equals((Object)context.getProperty(MERGE_STRATEGY).getValue())) {
            groupId = flowFile.getAttribute(FRAGMENT_ID_ATTRIBUTE);
        }
        return groupId;
    }

    @Override
    protected void setUpBinManager(BinManager binManager, ProcessContext context) {
        if (MERGE_STRATEGY_DEFRAGMENT.equals((Object)context.getProperty(MERGE_STRATEGY).getValue())) {
            binManager.setFileCountAttribute(FRAGMENT_COUNT_ATTRIBUTE);
        }
    }

    @Override
    protected boolean processBin(Bin unmodifiableBin, List<FlowFileSessionWrapper> binCopy, ProcessContext context, ProcessSession session) throws ProcessException {
        AttributeStrategy attributeStrategy;
        MergeBin merger;
        String mergeFormat;
        switch (mergeFormat = context.getProperty(MERGE_FORMAT).getValue()) {
            case "TAR": {
                merger = new TarMerge();
                break;
            }
            case "ZIP": {
                merger = new ZipMerge(context.getProperty(COMPRESSION_LEVEL).asInteger());
                break;
            }
            case "FlowFile Stream, v3": {
                merger = new FlowFileStreamMerger((FlowFilePackager)new FlowFilePackagerV3(), "application/flowfile-v3");
                break;
            }
            case "FlowFile Stream, v2": {
                merger = new FlowFileStreamMerger((FlowFilePackager)new FlowFilePackagerV2(), "application/flowfile-v2");
                break;
            }
            case "FlowFile Tar, v1": {
                merger = new FlowFileStreamMerger((FlowFilePackager)new FlowFilePackagerV1(), "application/flowfile-v1");
                break;
            }
            case "Binary Concatenation": {
                merger = new BinaryConcatenationMerge();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        switch (context.getProperty(ATTRIBUTE_STRATEGY).getValue()) {
            case "Keep All Unique Attributes": {
                attributeStrategy = new KeepUniqueAttributeStrategy();
                break;
            }
            default: {
                attributeStrategy = new KeepCommonAttributeStrategy();
            }
        }
        if (MERGE_STRATEGY_DEFRAGMENT.equals((Object)context.getProperty(MERGE_STRATEGY).getValue())) {
            String error = this.getDefragmentValidationError(binCopy);
            if (error != null) {
                String binDescription = binCopy.size() <= 10 ? binCopy.toString() : binCopy.size() + " FlowFiles";
                this.getLogger().error(error + "; routing {} to failure", new Object[]{binDescription});
                for (FlowFileSessionWrapper wrapper : binCopy) {
                    wrapper.getSession().transfer(wrapper.getFlowFile(), REL_FAILURE);
                    wrapper.getSession().commit();
                }
                return true;
            }
            Collections.sort(binCopy, new FragmentComparator());
        }
        FlowFile bundle = merger.merge(context, session, binCopy);
        String filename = bundle.getAttribute(CoreAttributes.FILENAME.key());
        Map<String, String> bundleAttributes = attributeStrategy.getMergedAttributes(binCopy);
        bundleAttributes.put(CoreAttributes.MIME_TYPE.key(), merger.getMergedContentType());
        bundleAttributes.put(CoreAttributes.FILENAME.key(), filename);
        bundleAttributes.put(MERGE_COUNT_ATTRIBUTE, Integer.toString(binCopy.size()));
        bundleAttributes.put(MERGE_BIN_AGE_ATTRIBUTE, Long.toString(unmodifiableBin.getBinAge()));
        bundle = session.putAllAttributes(bundle, bundleAttributes);
        String inputDescription = binCopy.size() < 10 ? binCopy.toString() : binCopy.size() + " FlowFiles";
        this.getLogger().info("Merged {} into {}", new Object[]{inputDescription, bundle});
        session.transfer(bundle, REL_MERGED);
        return false;
    }

    private String getDefragmentValidationError(List<FlowFileSessionWrapper> bin) {
        int numericFragmentCount;
        if (bin.isEmpty()) {
            return null;
        }
        String decidedFragmentCount = null;
        String fragmentIdentifier = null;
        for (FlowFileSessionWrapper flowFileWrapper : bin) {
            FlowFile flowFile = flowFileWrapper.getFlowFile();
            String fragmentIndex = flowFile.getAttribute(FRAGMENT_INDEX_ATTRIBUTE);
            if (!this.isNumber(fragmentIndex)) {
                return "Cannot Defragment " + flowFile + " because it does not have an integer value for the " + FRAGMENT_INDEX_ATTRIBUTE + " attribute";
            }
            fragmentIdentifier = flowFile.getAttribute(FRAGMENT_ID_ATTRIBUTE);
            String fragmentCount = flowFile.getAttribute(FRAGMENT_COUNT_ATTRIBUTE);
            if (!this.isNumber(fragmentCount)) {
                return "Cannot Defragment " + flowFile + " because it does not have an integer value for the " + FRAGMENT_COUNT_ATTRIBUTE + " attribute";
            }
            if (decidedFragmentCount == null) {
                decidedFragmentCount = fragmentCount;
                continue;
            }
            if (decidedFragmentCount.equals(fragmentCount)) continue;
            return "Cannot Defragment " + flowFile + " because it is grouped with another FlowFile, and the two have differing values for the " + FRAGMENT_COUNT_ATTRIBUTE + " attribute: " + decidedFragmentCount + " and " + fragmentCount;
        }
        try {
            numericFragmentCount = Integer.parseInt(decidedFragmentCount);
        }
        catch (NumberFormatException nfe) {
            return "Cannot Defragment FlowFiles with Fragment Identifier " + fragmentIdentifier + " because the " + FRAGMENT_COUNT_ATTRIBUTE + " has a non-integer value of " + decidedFragmentCount;
        }
        if (bin.size() < numericFragmentCount) {
            return "Cannot Defragment FlowFiles with Fragment Identifier " + fragmentIdentifier + " because the expected number of fragments is " + decidedFragmentCount + " but found only " + bin.size() + " fragments";
        }
        if (bin.size() > numericFragmentCount) {
            return "Cannot Defragment FlowFiles with Fragment Identifier " + fragmentIdentifier + " because the expected number of fragments is " + decidedFragmentCount + " but found " + bin.size() + " fragments for this identifier";
        }
        return null;
    }

    private boolean isNumber(String value) {
        if (value == null) {
            return false;
        }
        return NUMBER_PATTERN.matcher(value).matches();
    }

    private List<FlowFile> getFlowFiles(List<FlowFileSessionWrapper> sessionWrappers) {
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>();
        for (FlowFileSessionWrapper wrapper : sessionWrappers) {
            flowFiles.add(wrapper.getFlowFile());
        }
        return flowFiles;
    }

    private String getPath(FlowFile flowFile) {
        Path path = Paths.get(flowFile.getAttribute(CoreAttributes.PATH.key()), new String[0]);
        if (path.getNameCount() == 0) {
            return "";
        }
        if (".".equals(path.getName(0).toString())) {
            path = path.getNameCount() == 1 ? null : path.subpath(1, path.getNameCount());
        }
        return path == null ? "" : path.toString() + "/";
    }

    private String createFilename(List<FlowFileSessionWrapper> wrappers) {
        if (wrappers.size() == 1) {
            return wrappers.get(0).getFlowFile().getAttribute(CoreAttributes.FILENAME.key());
        }
        FlowFile ff = wrappers.get(0).getFlowFile();
        String origFilename = ff.getAttribute(SEGMENT_ORIGINAL_FILENAME);
        if (origFilename != null) {
            return origFilename;
        }
        return String.valueOf(System.nanoTime());
    }

    private static interface AttributeStrategy {
        public Map<String, String> getMergedAttributes(List<FlowFileSessionWrapper> var1);
    }

    private static interface MergeBin {
        public FlowFile merge(ProcessContext var1, ProcessSession var2, List<FlowFileSessionWrapper> var3);

        public String getMergedContentType();
    }

    private static class FragmentComparator
    implements Comparator<FlowFileSessionWrapper> {
        private FragmentComparator() {
        }

        @Override
        public int compare(FlowFileSessionWrapper o1, FlowFileSessionWrapper o2) {
            int fragmentIndex1 = Integer.parseInt(o1.getFlowFile().getAttribute(MergeContent.FRAGMENT_INDEX_ATTRIBUTE));
            int fragmentIndex2 = Integer.parseInt(o2.getFlowFile().getAttribute(MergeContent.FRAGMENT_INDEX_ATTRIBUTE));
            return Integer.compare(fragmentIndex1, fragmentIndex2);
        }
    }

    private static class KeepCommonAttributeStrategy
    implements AttributeStrategy {
        private KeepCommonAttributeStrategy() {
        }

        @Override
        public Map<String, String> getMergedAttributes(List<FlowFileSessionWrapper> flowFiles) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (flowFiles == null || flowFiles.isEmpty()) {
                return result;
            }
            if (flowFiles.size() == 1) {
                result.putAll(flowFiles.iterator().next().getFlowFile().getAttributes());
            }
            Map firstMap = flowFiles.iterator().next().getFlowFile().getAttributes();
            block0: for (Map.Entry mapEntry : firstMap.entrySet()) {
                String key = (String)mapEntry.getKey();
                String value = (String)mapEntry.getValue();
                for (FlowFileSessionWrapper flowFileWrapper : flowFiles) {
                    Map currMap = flowFileWrapper.getFlowFile().getAttributes();
                    String curVal = (String)currMap.get(key);
                    if (curVal != null && curVal.equals(value)) continue;
                    continue block0;
                }
                result.put(key, value);
            }
            result.remove(CoreAttributes.UUID.key());
            return result;
        }
    }

    private static class KeepUniqueAttributeStrategy
    implements AttributeStrategy {
        private KeepUniqueAttributeStrategy() {
        }

        @Override
        public Map<String, String> getMergedAttributes(List<FlowFileSessionWrapper> flowFiles) {
            HashMap<String, String> newAttributes = new HashMap<String, String>();
            HashSet<String> conflicting = new HashSet<String>();
            for (FlowFileSessionWrapper wrapper : flowFiles) {
                FlowFile flowFile = wrapper.getFlowFile();
                for (Map.Entry attributeEntry : flowFile.getAttributes().entrySet()) {
                    String name = (String)attributeEntry.getKey();
                    String value = (String)attributeEntry.getValue();
                    String existingValue = (String)newAttributes.get(name);
                    if (existingValue != null && !existingValue.equals(value)) {
                        conflicting.add(name);
                        continue;
                    }
                    newAttributes.put(name, value);
                }
            }
            for (String attributeToRemove : conflicting) {
                newAttributes.remove(attributeToRemove);
            }
            newAttributes.remove(CoreAttributes.UUID.key());
            return newAttributes;
        }
    }

    private class ZipMerge
    implements MergeBin {
        private final int compressionLevel;

        public ZipMerge(int compressionLevel) {
            this.compressionLevel = compressionLevel;
        }

        @Override
        public FlowFile merge(ProcessContext context, ProcessSession session, final List<FlowFileSessionWrapper> wrappers) {
            final boolean keepPath = context.getProperty(KEEP_PATH).asBoolean();
            FlowFile bundle = session.create();
            bundle = session.putAttribute(bundle, CoreAttributes.FILENAME.key(), MergeContent.this.createFilename(wrappers) + ".zip");
            bundle = session.write(bundle, new OutputStreamCallback(){

                public void process(OutputStream rawOut) throws IOException {
                    try (BufferedOutputStream bufferedOut = new BufferedOutputStream(rawOut);
                         ZipOutputStream out = new ZipOutputStream((OutputStream)bufferedOut);){
                        out.setLevel(ZipMerge.this.compressionLevel);
                        for (FlowFileSessionWrapper wrapper : wrappers) {
                            FlowFile flowFile = wrapper.getFlowFile();
                            String path = keepPath ? MergeContent.this.getPath(flowFile) : "";
                            String entryName = path + flowFile.getAttribute(CoreAttributes.FILENAME.key());
                            ZipEntry zipEntry = new ZipEntry(entryName);
                            zipEntry.setSize(flowFile.getSize());
                            out.putNextEntry(zipEntry);
                            wrapper.getSession().exportTo(flowFile, (OutputStream)out);
                            out.closeEntry();
                        }
                        out.finish();
                        out.flush();
                    }
                }
            });
            session.getProvenanceReporter().join((Collection)MergeContent.this.getFlowFiles(wrappers), bundle);
            return bundle;
        }

        @Override
        public String getMergedContentType() {
            return "application/zip";
        }
    }

    private class FlowFileStreamMerger
    implements MergeBin {
        private final FlowFilePackager packager;
        private final String mimeType;

        public FlowFileStreamMerger(FlowFilePackager packager, String mimeType) {
            this.packager = packager;
            this.mimeType = mimeType;
        }

        @Override
        public FlowFile merge(ProcessContext context, ProcessSession session, final List<FlowFileSessionWrapper> wrappers) {
            FlowFile bundle = session.create();
            bundle = session.write(bundle, new OutputStreamCallback(){

                public void process(OutputStream rawOut) throws IOException {
                    try (BufferedOutputStream bufferedOut = new BufferedOutputStream(rawOut);){
                        NonCloseableOutputStream out = new NonCloseableOutputStream((OutputStream)bufferedOut);
                        for (FlowFileSessionWrapper wrapper : wrappers) {
                            final FlowFile flowFile = wrapper.getFlowFile();
                            wrapper.getSession().read(flowFile, new InputStreamCallback((OutputStream)out){
                                final /* synthetic */ OutputStream val$out;
                                {
                                    this.val$out = outputStream;
                                }

                                public void process(InputStream rawIn) throws IOException {
                                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                                        HashMap attributes = new HashMap(flowFile.getAttributes());
                                        attributes.put("nf.file.name", attributes.get(CoreAttributes.FILENAME.key()));
                                        attributes.put("nf.file.path", attributes.get(CoreAttributes.PATH.key()));
                                        if (attributes.containsKey(CoreAttributes.MIME_TYPE.key())) {
                                            attributes.put("content-type", attributes.get(CoreAttributes.MIME_TYPE.key()));
                                        }
                                        FlowFileStreamMerger.this.packager.packageFlowFile((InputStream)in, this.val$out, attributes, flowFile.getSize());
                                    }
                                }
                            });
                        }
                    }
                }
            });
            bundle = session.putAttribute(bundle, CoreAttributes.FILENAME.key(), MergeContent.this.createFilename(wrappers) + ".pkg");
            session.getProvenanceReporter().join((Collection)MergeContent.this.getFlowFiles(wrappers), bundle);
            return bundle;
        }

        @Override
        public String getMergedContentType() {
            return this.mimeType;
        }
    }

    private class TarMerge
    implements MergeBin {
        private TarMerge() {
        }

        @Override
        public FlowFile merge(ProcessContext context, ProcessSession session, final List<FlowFileSessionWrapper> wrappers) {
            final boolean keepPath = context.getProperty(KEEP_PATH).asBoolean();
            FlowFile bundle = session.create();
            bundle = session.putAttribute(bundle, CoreAttributes.FILENAME.key(), MergeContent.this.createFilename(wrappers) + ".tar");
            bundle = session.write(bundle, new OutputStreamCallback(){

                public void process(OutputStream rawOut) throws IOException {
                    try (BufferedOutputStream bufferedOut = new BufferedOutputStream(rawOut);
                         TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)bufferedOut);){
                        out.setLongFileMode(2);
                        for (FlowFileSessionWrapper wrapper : wrappers) {
                            FlowFile flowFile = wrapper.getFlowFile();
                            String path = keepPath ? MergeContent.this.getPath(flowFile) : "";
                            String entryName = path + flowFile.getAttribute(CoreAttributes.FILENAME.key());
                            TarArchiveEntry tarEntry = new TarArchiveEntry(entryName);
                            tarEntry.setSize(flowFile.getSize());
                            String permissionsVal = flowFile.getAttribute(MergeContent.TAR_PERMISSIONS_ATTRIBUTE);
                            if (permissionsVal != null) {
                                try {
                                    tarEntry.setMode(Integer.parseInt(permissionsVal));
                                }
                                catch (Exception e) {
                                    MergeContent.this.getLogger().debug("Attribute {} of {} is set to {}; expected 3 digits between 0-7, so ignoring", new Object[]{MergeContent.TAR_PERMISSIONS_ATTRIBUTE, flowFile, permissionsVal});
                                }
                            }
                            out.putArchiveEntry((ArchiveEntry)tarEntry);
                            wrapper.getSession().exportTo(flowFile, (OutputStream)out);
                            out.closeArchiveEntry();
                        }
                    }
                }
            });
            session.getProvenanceReporter().join((Collection)MergeContent.this.getFlowFiles(wrappers), bundle);
            return bundle;
        }

        @Override
        public String getMergedContentType() {
            return "application/tar";
        }
    }

    private class BinaryConcatenationMerge
    implements MergeBin {
        private String mimeType = "application/octet-stream";

        @Override
        public FlowFile merge(final ProcessContext context, ProcessSession session, final List<FlowFileSessionWrapper> wrappers) {
            HashSet<FlowFile> parentFlowFiles = new HashSet<FlowFile>();
            for (FlowFileSessionWrapper wrapper : wrappers) {
                parentFlowFiles.add(wrapper.getFlowFile());
            }
            FlowFile bundle = session.create(parentFlowFiles);
            final ObjectHolder bundleMimeTypeRef = new ObjectHolder(null);
            bundle = session.write(bundle, new OutputStreamCallback(){

                public void process(final OutputStream out) throws IOException {
                    byte[] header = BinaryConcatenationMerge.this.getDelimiterContent(context, wrappers, HEADER);
                    if (header != null) {
                        out.write(header);
                    }
                    boolean isFirst = true;
                    Iterator itr = wrappers.iterator();
                    while (itr.hasNext()) {
                        byte[] demarcator;
                        FlowFileSessionWrapper wrapper = (FlowFileSessionWrapper)itr.next();
                        wrapper.getSession().read(wrapper.getFlowFile(), new InputStreamCallback(){

                            public void process(InputStream in) throws IOException {
                                StreamUtils.copy((InputStream)in, (OutputStream)out);
                            }
                        });
                        if (itr.hasNext() && (demarcator = BinaryConcatenationMerge.this.getDelimiterContent(context, wrappers, DEMARCATOR)) != null) {
                            out.write(demarcator);
                        }
                        String flowFileMimeType = wrapper.getFlowFile().getAttribute(CoreAttributes.MIME_TYPE.key());
                        if (isFirst) {
                            bundleMimeTypeRef.set((Object)flowFileMimeType);
                            isFirst = false;
                            continue;
                        }
                        if (bundleMimeTypeRef.get() == null || ((String)bundleMimeTypeRef.get()).equals(flowFileMimeType)) continue;
                        bundleMimeTypeRef.set(null);
                    }
                    byte[] footer = BinaryConcatenationMerge.this.getDelimiterContent(context, wrappers, FOOTER);
                    if (footer != null) {
                        out.write(footer);
                    }
                }
            });
            session.getProvenanceReporter().join((Collection)MergeContent.this.getFlowFiles(wrappers), bundle);
            bundle = session.putAttribute(bundle, CoreAttributes.FILENAME.key(), MergeContent.this.createFilename(wrappers));
            if (bundleMimeTypeRef.get() != null) {
                this.mimeType = (String)bundleMimeTypeRef.get();
            }
            return bundle;
        }

        private byte[] getDelimiterContent(ProcessContext context, List<FlowFileSessionWrapper> wrappers, PropertyDescriptor descriptor) throws IOException {
            String delimiterStrategyValue = context.getProperty(DELIMITER_STRATEGY).getValue();
            if (DELIMITER_STRATEGY_FILENAME.equals((Object)delimiterStrategyValue)) {
                return this.getDelimiterFileContent(context, wrappers, descriptor);
            }
            return this.getDelimiterTextContent(context, wrappers, descriptor);
        }

        private byte[] getDelimiterFileContent(ProcessContext context, List<FlowFileSessionWrapper> wrappers, PropertyDescriptor descriptor) throws IOException {
            byte[] property = null;
            String descriptorValue = context.getProperty(descriptor).evaluateAttributeExpressions().getValue();
            if (descriptorValue != null && wrappers != null && wrappers.size() > 0) {
                FlowFile flowFile;
                String content = new String(MergeContent.this.readContent(descriptorValue));
                FlowFileSessionWrapper wrapper = wrappers.get(0);
                if (wrapper != null && content != null && (flowFile = wrapper.getFlowFile()) != null) {
                    PropertyValue propVal = context.newPropertyValue(content).evaluateAttributeExpressions(flowFile);
                    property = propVal.getValue().getBytes();
                }
            }
            return property;
        }

        private byte[] getDelimiterTextContent(ProcessContext context, List<FlowFileSessionWrapper> wrappers, PropertyDescriptor descriptor) throws IOException {
            FlowFile flowFile;
            FlowFileSessionWrapper wrapper;
            byte[] property = null;
            if (wrappers != null && wrappers.size() > 0 && (wrapper = wrappers.get(0)) != null && (flowFile = wrapper.getFlowFile()) != null) {
                property = context.getProperty(descriptor).evaluateAttributeExpressions(flowFile).getValue().getBytes();
            }
            return property;
        }

        @Override
        public String getMergedContentType() {
            return this.mimeType;
        }
    }
}

