/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;

public class JdbcCommon {
    public static long convertToAvroStream(ResultSet rs, OutputStream outStream) throws SQLException, IOException {
        Schema schema = JdbcCommon.createSchema(rs);
        GenericData.Record rec = new GenericData.Record(schema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, outStream);
            ResultSetMetaData meta = rs.getMetaData();
            int nrOfColumns = meta.getColumnCount();
            long nrOfRows = 0L;
            while (rs.next()) {
                for (int i = 1; i <= nrOfColumns; ++i) {
                    Object value = rs.getObject(i);
                    if (value == null) {
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (value instanceof Number || value instanceof Boolean) {
                        rec.put(i - 1, value);
                        continue;
                    }
                    rec.put(i - 1, (Object)value.toString());
                }
                dataFileWriter.append((Object)rec);
                ++nrOfRows;
            }
            long l = nrOfRows;
            return l;
        }
    }

    public static Schema createSchema(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int nrOfColumns = meta.getColumnCount();
        String tableName = meta.getTableName(1);
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)tableName).namespace("any.data")).fields();
        block11: for (int i = 1; i <= nrOfColumns; ++i) {
            switch (meta.getColumnType(i)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    builder.name(meta.getColumnName(i)).type().stringType().noDefault();
                    continue block11;
                }
                case 16: {
                    builder.name(meta.getColumnName(i)).type().booleanType().noDefault();
                    continue block11;
                }
                case -6: 
                case 4: 
                case 5: {
                    builder.name(meta.getColumnName(i)).type().intType().noDefault();
                    continue block11;
                }
                case -5: {
                    builder.name(meta.getColumnName(i)).type().longType().noDefault();
                    continue block11;
                }
                case -8: {
                    builder.name(meta.getColumnName(i)).type().stringType().noDefault();
                    continue block11;
                }
                case 6: 
                case 7: {
                    builder.name(meta.getColumnName(i)).type().floatType().noDefault();
                    continue block11;
                }
                case 8: {
                    builder.name(meta.getColumnName(i)).type().doubleType().noDefault();
                    continue block11;
                }
                case 2: 
                case 3: {
                    builder.name(meta.getColumnName(i)).type().stringType().noDefault();
                    continue block11;
                }
                case 91: 
                case 92: 
                case 93: {
                    builder.name(meta.getColumnName(i)).type().stringType().noDefault();
                    continue block11;
                }
            }
        }
        return (Schema)builder.endRecord();
    }
}

