/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.EncryptContent;
import org.apache.nifi.stream.io.StreamUtils;

public class PasswordBasedEncryptor
implements EncryptContent.Encryptor {
    private Cipher cipher;
    private int saltSize;
    private SecretKey secretKey;
    public static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    public static final int DEFAULT_SALT_SIZE = 8;

    public PasswordBasedEncryptor(String algorithm, String providerName, char[] password) {
        try {
            this.cipher = Cipher.getInstance(algorithm, providerName);
            int algorithmBlockSize = this.cipher.getBlockSize();
            this.saltSize = algorithmBlockSize > 0 ? algorithmBlockSize : 8;
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm, providerName);
            this.secretKey = factory.generateSecret(pbeKeySpec);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    @Override
    public StreamCallback getEncryptionCallback() throws ProcessException {
        try {
            byte[] salt = new byte[this.saltSize];
            SecureRandom secureRandom = SecureRandom.getInstance(SECURE_RANDOM_ALGORITHM);
            secureRandom.setSeed(System.currentTimeMillis());
            secureRandom.nextBytes(salt);
            return new EncryptCallback(salt);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    @Override
    public StreamCallback getDecryptionCallback() throws ProcessException {
        return new DecryptCallback();
    }

    private class EncryptCallback
    implements StreamCallback {
        private final byte[] salt;

        public EncryptCallback(byte[] salt) {
            this.salt = salt;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            int len;
            PBEParameterSpec parameterSpec = new PBEParameterSpec(this.salt, 1000);
            try {
                PasswordBasedEncryptor.this.cipher.init(1, (Key)PasswordBasedEncryptor.this.secretKey, parameterSpec);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            out.write(this.salt);
            byte[] buffer = new byte[65536];
            while ((len = in.read(buffer)) > 0) {
                byte[] encryptedBytes = PasswordBasedEncryptor.this.cipher.update(buffer, 0, len);
                if (encryptedBytes == null) continue;
                out.write(encryptedBytes);
            }
            try {
                out.write(PasswordBasedEncryptor.this.cipher.doFinal());
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }

    private class DecryptCallback
    implements StreamCallback {
        public void process(InputStream in, OutputStream out) throws IOException {
            int len;
            byte[] salt = new byte[PasswordBasedEncryptor.this.saltSize];
            try {
                StreamUtils.fillBuffer((InputStream)in, (byte[])salt);
            }
            catch (EOFException e) {
                throw new ProcessException("Cannot decrypt because file size is smaller than salt size", (Throwable)e);
            }
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 1000);
            try {
                PasswordBasedEncryptor.this.cipher.init(2, (Key)PasswordBasedEncryptor.this.secretKey, parameterSpec);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            byte[] buffer = new byte[65536];
            while ((len = in.read(buffer)) > 0) {
                byte[] decryptedBytes = PasswordBasedEncryptor.this.cipher.update(buffer, 0, len);
                if (decryptedBytes == null) continue;
                out.write(decryptedBytes);
            }
            try {
                out.write(PasswordBasedEncryptor.this.cipher.doFinal());
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }
}

