/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StopWatch;

@Tags(value={"get", "fetch", "poll", "http", "https", "ingest", "source", "input"})
@CapabilityDescription(value="Fetches a file via HTTP")
@WritesAttributes(value={@WritesAttribute(attribute="filename", description="The filename is set to the name of the file on the remote server"), @WritesAttribute(attribute="mime.type", description="The MIME Type of the FlowFile, as reported by the HTTP Content-Type header")})
public class GetHTTP
extends AbstractSessionFactoryProcessor {
    static final int PERSISTENCE_INTERVAL_MSEC = 10000;
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_ETAG = "ETag";
    public static final int NOT_MODIFIED = 304;
    public static final PropertyDescriptor URL = new PropertyDescriptor.Builder().name("URL").description("The URL to pull from").required(true).addValidator(StandardValidators.URL_VALIDATOR).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("https?\\://.*"))).build();
    public static final PropertyDescriptor FOLLOW_REDIRECTS = new PropertyDescriptor.Builder().name("Follow Redirects").description("If we receive a 3xx HTTP Status Code from the server, indicates whether or not we should follow the redirect that the server specifies").defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("Connection Timeout").description("How long to wait when attempting to connect to the remote server before giving up").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor ACCEPT_CONTENT_TYPE = new PropertyDescriptor.Builder().name("Accept Content-Type").description("If specified, requests will only accept the provided Content-Type").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DATA_TIMEOUT = new PropertyDescriptor.Builder().name("Data Timeout").description("How long to wait between receiving segments of data from the remote server before giving up and discarding the partial file").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor FILENAME = new PropertyDescriptor.Builder().name("Filename").description("The filename to assign to the file when pulled").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("Username required to access the URL").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("Password required to access the URL").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USER_AGENT = new PropertyDescriptor.Builder().name("User Agent").description("What to report as the User Agent when we connect to the remote server").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor PROXY_HOST = new PropertyDescriptor.Builder().name("Proxy Host").description("The fully qualified hostname or IP address of the proxy server").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_PORT = new PropertyDescriptor.Builder().name("Proxy Port").description("The port of the proxy server").required(false).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All files are transferred to the success relationship").build();
    public static final String LAST_MODIFIED_DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    static final String UNINITIALIZED_LAST_MODIFIED_VALUE;
    private static final String HTTP_CACHE_FILE_PREFIX = "conf/.httpCache-";
    static final String ETAG = "ETag";
    static final String LAST_MODIFIED = "LastModified";
    final AtomicReference<String> lastModifiedRef = new AtomicReference<String>(UNINITIALIZED_LAST_MODIFIED_VALUE);
    final AtomicReference<String> entityTagRef = new AtomicReference<String>("");
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private volatile long timeToPersist = 0L;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(URL);
        properties.add(FILENAME);
        properties.add(SSL_CONTEXT_SERVICE);
        properties.add(USERNAME);
        properties.add(PASSWORD);
        properties.add(CONNECTION_TIMEOUT);
        properties.add(DATA_TIMEOUT);
        properties.add(USER_AGENT);
        properties.add(ACCEPT_CONTENT_TYPE);
        properties.add(FOLLOW_REDIRECTS);
        properties.add(PROXY_HOST);
        properties.add(PROXY_PORT);
        this.properties = Collections.unmodifiableList(properties);
        File httpCache = new File(HTTP_CACHE_FILE_PREFIX + this.getIdentifier());
        try (FileInputStream fis = new FileInputStream(httpCache);){
            Properties props = new Properties();
            props.load(fis);
            this.entityTagRef.set(props.getProperty("ETag"));
            this.lastModifiedRef.set(props.getProperty(LAST_MODIFIED));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        this.entityTagRef.set("");
        this.lastModifiedRef.set(UNINITIALIZED_LAST_MODIFIED_VALUE);
    }

    @OnStopped
    public void onStopped() {
        File httpCache = new File(HTTP_CACHE_FILE_PREFIX + this.getIdentifier());
        try (FileOutputStream fos = new FileOutputStream(httpCache);){
            Properties props = new Properties();
            props.setProperty("ETag", this.entityTagRef.get());
            props.setProperty(LAST_MODIFIED, this.lastModifiedRef.get());
            props.store(fos, "GetHTTP file modification values");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @OnRemoved
    public void onRemoved() {
        File httpCache = new File(HTTP_CACHE_FILE_PREFIX + this.getIdentifier());
        if (httpCache.exists()) {
            httpCache.delete();
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (context.getProperty(URL).getValue().startsWith("https") && context.getProperty(SSL_CONTEXT_SERVICE).getValue() == null) {
            results.add(new ValidationResult.Builder().explanation("URL is set to HTTPS protocol but no SSLContext has been specified").valid(false).subject("SSL Context").build());
        }
        if (context.getProperty(PROXY_HOST).isSet() && !context.getProperty(PROXY_PORT).isSet()) {
            results.add(new ValidationResult.Builder().explanation("Proxy Host was set but no Proxy Port was specified").valid(false).subject("Proxy server configuration").build());
        }
        return results;
    }

    private SSLContext createSSLContext(SSLContextService service) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        KeyStore truststore = KeyStore.getInstance(service.getTrustStoreType());
        try (FileInputStream in = new FileInputStream(new File(service.getTrustStoreFile()));){
            truststore.load(in, service.getTrustStorePassword().toCharArray());
        }
        KeyStore keystore = KeyStore.getInstance(service.getKeyStoreType());
        try (FileInputStream in = new FileInputStream(new File(service.getKeyStoreFile()));){
            keystore.load(in, service.getKeyStorePassword().toCharArray());
        }
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(truststore, (TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(keystore, service.getKeyStorePassword().toCharArray()).build();
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        block48: {
            BasicHttpClientConnectionManager conMan;
            String url;
            ProcessorLog logger = this.getLogger();
            ProcessSession session = sessionFactory.createSession();
            FlowFile incomingFlowFile = session.get();
            if (incomingFlowFile != null) {
                session.transfer(incomingFlowFile, REL_SUCCESS);
                logger.warn("found FlowFile {} in input queue; transferring to success", new Object[]{incomingFlowFile});
            }
            String source = url = context.getProperty(URL).getValue();
            try {
                URI uri = new URI(url);
                source = uri.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
            if (sslContextService == null) {
                conMan = new BasicHttpClientConnectionManager();
            } else {
                SSLContext sslContext;
                try {
                    sslContext = this.createSSLContext(sslContextService);
                }
                catch (Exception e) {
                    throw new ProcessException((Throwable)e);
                }
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
                Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
                conMan = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
            }
            try {
                int statusCode;
                HttpResponse response;
                StopWatch stopWatch;
                block47: {
                    RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
                    requestConfigBuilder.setConnectionRequestTimeout(context.getProperty(DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
                    requestConfigBuilder.setConnectTimeout(context.getProperty(CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
                    requestConfigBuilder.setRedirectsEnabled(false);
                    requestConfigBuilder.setSocketTimeout(context.getProperty(DATA_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
                    requestConfigBuilder.setRedirectsEnabled(context.getProperty(FOLLOW_REDIRECTS).asBoolean().booleanValue());
                    HttpClientBuilder clientBuilder = HttpClientBuilder.create();
                    clientBuilder.setConnectionManager((HttpClientConnectionManager)conMan);
                    String userAgent = context.getProperty(USER_AGENT).getValue();
                    if (userAgent != null) {
                        clientBuilder.setUserAgent(userAgent);
                    }
                    if (sslContextService != null) {
                        clientBuilder.setSslcontext(sslContextService.createSSLContext(SSLContextService.ClientAuth.REQUIRED));
                    }
                    String username = context.getProperty(USERNAME).getValue();
                    String password = context.getProperty(PASSWORD).getValue();
                    if (username != null) {
                        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                        if (password == null) {
                            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username));
                        } else {
                            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                        }
                        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                    }
                    if (context.getProperty(PROXY_HOST).isSet() && context.getProperty(PROXY_PORT).isSet()) {
                        String host = context.getProperty(PROXY_HOST).getValue();
                        int port = context.getProperty(PROXY_PORT).asInteger();
                        clientBuilder.setProxy(new HttpHost(host, port));
                    }
                    CloseableHttpClient client = clientBuilder.build();
                    HttpGet get = new HttpGet(url);
                    get.setConfig(requestConfigBuilder.build());
                    get.addHeader(HEADER_IF_MODIFIED_SINCE, this.lastModifiedRef.get());
                    get.addHeader(HEADER_IF_NONE_MATCH, this.entityTagRef.get());
                    String accept = context.getProperty(ACCEPT_CONTENT_TYPE).getValue();
                    if (accept != null) {
                        get.addHeader(HEADER_ACCEPT, accept);
                    }
                    stopWatch = new StopWatch(true);
                    response = client.execute((HttpUriRequest)get);
                    statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 304) break block47;
                    logger.info("content not retrieved because server returned HTTP Status Code {}: Not Modified", new Object[]{304});
                    context.yield();
                    session.commit();
                    return;
                }
                String statusExplanation = response.getStatusLine().getReasonPhrase();
                if (statusCode >= 300) {
                    logger.error("received status code {}:{} from {}", new Object[]{statusCode, statusExplanation, url});
                    session.commit();
                    return;
                }
                try {
                    Header etag;
                    String contentType;
                    FlowFile flowFile = session.create();
                    flowFile = session.putAttribute(flowFile, CoreAttributes.FILENAME.key(), context.getProperty(FILENAME).getValue());
                    flowFile = session.putAttribute(flowFile, ((Object)((Object)this)).getClass().getSimpleName().toLowerCase() + ".remote.source", source);
                    flowFile = session.importFrom(response.getEntity().getContent(), flowFile);
                    Header contentTypeHeader = response.getFirstHeader("Content-Type");
                    if (contentTypeHeader != null && !(contentType = contentTypeHeader.getValue()).trim().isEmpty()) {
                        flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), contentType.trim());
                    }
                    long flowFileSize = flowFile.getSize();
                    stopWatch.stop();
                    String dataRate = stopWatch.calculateDataRate(flowFileSize);
                    session.getProvenanceReporter().receive(flowFile, url, stopWatch.getDuration(TimeUnit.MILLISECONDS));
                    session.transfer(flowFile, REL_SUCCESS);
                    logger.info("Successfully received {} from {} at a rate of {}; transferred to success", new Object[]{flowFile, url, dataRate});
                    session.commit();
                    Header lastModified = response.getFirstHeader(HEADER_LAST_MODIFIED);
                    if (lastModified != null) {
                        this.lastModifiedRef.set(lastModified.getValue());
                    }
                    if ((etag = response.getFirstHeader("ETag")) != null) {
                        this.entityTagRef.set(etag.getValue());
                    }
                    if (etag == null && lastModified == null || !this.readLock.tryLock()) break block48;
                    try {
                        if (this.timeToPersist >= System.currentTimeMillis()) break block48;
                        this.readLock.unlock();
                        this.writeLock.lock();
                        try {
                            if (this.timeToPersist >= System.currentTimeMillis()) break block48;
                            this.timeToPersist = System.currentTimeMillis() + 10000L;
                            File httpCache = new File(HTTP_CACHE_FILE_PREFIX + this.getIdentifier());
                            try (FileOutputStream fos = new FileOutputStream(httpCache);){
                                Properties props = new Properties();
                                props.setProperty("ETag", this.entityTagRef.get());
                                props.setProperty(LAST_MODIFIED, this.lastModifiedRef.get());
                                props.store(fos, "GetHTTP file modification values");
                            }
                            catch (IOException e) {
                                this.getLogger().error("Failed to persist ETag and LastMod due to " + e, (Throwable)e);
                            }
                        }
                        finally {
                            this.readLock.lock();
                            this.writeLock.unlock();
                        }
                    }
                    finally {
                        this.readLock.unlock();
                    }
                }
                catch (IOException e) {
                    context.yield();
                    session.rollback();
                    logger.error("Failed to retrieve file from {} due to {}; rolling back session", new Object[]{url, e.getMessage()}, (Throwable)e);
                    throw new ProcessException((Throwable)e);
                }
                catch (Throwable t) {
                    context.yield();
                    session.rollback();
                    logger.error("Failed to process due to {}; rolling back session", new Object[]{t.getMessage()}, t);
                    throw t;
                }
            }
            finally {
                conMan.shutdown();
            }
        }
    }

    static {
        SimpleDateFormat sdf = new SimpleDateFormat(LAST_MODIFIED_DATE_PATTERN_RFC1123, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        UNINITIALIZED_LAST_MODIFIED_VALUE = sdf.format(new Date(1L));
    }
}

