/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.FlowFileFilters;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.NLKBufferedReader;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"Text", "Regular Expression", "Update", "Change", "Replace", "Modify", "Regex"})
@CapabilityDescription(value="Updates the content of a FlowFile by evaluating a Regular Expression against it and replacing the section of the content that matches the Regular Expression with some alternate value.")
public class ReplaceText
extends AbstractProcessor {
    public static final String LINE_BY_LINE = "Line-by-Line";
    public static final String ENTIRE_TEXT = "Entire text";
    private final Pattern backReferencePattern = Pattern.compile("\\$(\\d+)");
    private static final byte[] ZERO_BYTE_BUFFER = new byte[0];
    private static final String DEFAULT_REGEX = "(?s:^.*$)";
    private static final String DEFAULT_REPLACEMENT_VALUE = "$1";
    public static final PropertyDescriptor REGEX = new PropertyDescriptor.Builder().name("Regular Expression").description("The Regular Expression to search for in the FlowFile content").required(true).addValidator(StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true)).expressionLanguageSupported(true).defaultValue("(?s:^.*$)").build();
    public static final PropertyDescriptor REPLACEMENT_VALUE = new PropertyDescriptor.Builder().name("Replacement Value").description("The value to replace the regular expression with. Back-references to Regular Expression capturing groups are supported, but back-references that reference capturing groups that do not exist in the regular expression will be treated as literal value.").required(true).defaultValue("$1").addValidator(Validator.VALID).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Set").description("The Character Set in which the file is encoded").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    public static final PropertyDescriptor MAX_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Maximum Buffer Size").description("Specifies the maximum amount of data to buffer (per file or per line, depending on the Evaluation Mode) in order to apply the regular expressions. If 'Entire Text' (in Evaluation Mode) is selected and the FlowFile is larger than this value, the FlowFile will be routed to 'failure'. In 'Line-by-Line' Mode, if a single line is larger than this value, the FlowFile will be routed to 'failure'. A default value of 1 MB is provided, primarily for 'Entire Text' mode. In 'Line-by-Line' Mode, a value such as 8 KB or 16 KB is suggested. This value is ignored and the buffer is not used if 'Regular Expression' is set to '.*'").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").build();
    public static final PropertyDescriptor EVALUATION_MODE = new PropertyDescriptor.Builder().name("Evaluation Mode").description("Evaluate the 'Regular Expression' against each line (Line-by-Line) or buffer the entire file into memory (Entire Text) and then evaluate the 'Regular Expression'.").allowableValues(new String[]{"Line-by-Line", "Entire text"}).defaultValue("Entire text").required(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that have been successfully updated are routed to this relationship, as well as FlowFiles whose content does not match the given Regular Expression").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that could not be updated are routed to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(REGEX);
        properties.add(REPLACEMENT_VALUE);
        properties.add(CHARACTER_SET);
        properties.add(MAX_BUFFER_SIZE);
        properties.add(EVALUATION_MODE);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        List flowFiles = session.get(FlowFileFilters.newSizeBasedFilter((double)1.0, (DataUnit)DataUnit.MB, (int)100));
        if (flowFiles.isEmpty()) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        String unsubstitutedRegex = context.getProperty(REGEX).getValue();
        String unsubstitutedReplacement = context.getProperty(REPLACEMENT_VALUE).getValue();
        if (unsubstitutedRegex.equals(DEFAULT_REGEX) && unsubstitutedReplacement.equals(DEFAULT_REPLACEMENT_VALUE)) {
            session.transfer((Collection)flowFiles, REL_SUCCESS);
            return;
        }
        AttributeValueDecorator quotedAttributeDecorator = new AttributeValueDecorator(){

            public String decorate(String attributeValue) {
                return Pattern.quote(attributeValue);
            }
        };
        AttributeValueDecorator escapeBackRefDecorator = new AttributeValueDecorator(){

            public String decorate(String attributeValue) {
                return attributeValue.replace("$", "\\$");
            }
        };
        String regexValue = context.getProperty(REGEX).evaluateAttributeExpressions().getValue();
        int numCapturingGroups = Pattern.compile(regexValue).matcher("").groupCount();
        boolean skipBuffer = ".*".equals(unsubstitutedRegex);
        final Charset charset = Charset.forName(context.getProperty(CHARACTER_SET).getValue());
        final int maxBufferSize = context.getProperty(MAX_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        final byte[] buffer = skipBuffer ? ZERO_BYTE_BUFFER : new byte[maxBufferSize];
        String evaluateMode = context.getProperty(EVALUATION_MODE).getValue();
        for (FlowFile flowFile : flowFiles) {
            StopWatch stopWatch;
            if (evaluateMode.equalsIgnoreCase(ENTIRE_TEXT) && flowFile.getSize() > (long)maxBufferSize && !skipBuffer) {
                session.transfer(flowFile, REL_FAILURE);
                continue;
            }
            String replacement = context.getProperty(REPLACEMENT_VALUE).evaluateAttributeExpressions(flowFile, escapeBackRefDecorator).getValue();
            Matcher backRefMatcher = this.backReferencePattern.matcher(replacement);
            while (backRefMatcher.find()) {
                int originalBackRefIndex;
                int backRefIndex;
                String backRefNum = backRefMatcher.group(1);
                if (backRefNum.startsWith("0")) continue;
                for (backRefIndex = originalBackRefIndex = Integer.parseInt(backRefNum); backRefIndex > numCapturingGroups && backRefIndex >= 10; backRefIndex /= 10) {
                }
                if (backRefIndex <= numCapturingGroups) continue;
                StringBuilder sb = new StringBuilder(replacement.length() + 1);
                int groupStart = backRefMatcher.start(1);
                sb.append(replacement.substring(0, groupStart - 1));
                sb.append("\\");
                sb.append(replacement.substring(groupStart - 1));
                replacement = sb.toString();
            }
            final String replacementValue = replacement = replacement.replaceAll("(\\$\\D)", "\\\\$1");
            if (skipBuffer) {
                stopWatch = new StopWatch(true);
                flowFile = evaluateMode.equalsIgnoreCase(ENTIRE_TEXT) ? session.write(flowFile, new OutputStreamCallback(){

                    public void process(OutputStream out) throws IOException {
                        out.write(replacementValue.getBytes(charset));
                    }
                }) : session.write(flowFile, new StreamCallback(){

                    public void process(InputStream in, OutputStream out) throws IOException {
                        try (NLKBufferedReader br = new NLKBufferedReader(new InputStreamReader(in, charset), maxBufferSize);
                             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, charset));){
                            while (null != br.readLine()) {
                                bw.write(replacementValue);
                            }
                        }
                    }
                });
                session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                session.transfer(flowFile, REL_SUCCESS);
                logger.info("Transferred {} to 'success'", new Object[]{flowFile});
                continue;
            }
            stopWatch = new StopWatch(true);
            final String regex = context.getProperty(REGEX).evaluateAttributeExpressions(flowFile, quotedAttributeDecorator).getValue();
            if (evaluateMode.equalsIgnoreCase(ENTIRE_TEXT)) {
                final int flowFileSize = (int)flowFile.getSize();
                flowFile = session.write(flowFile, new StreamCallback(){

                    public void process(InputStream in, OutputStream out) throws IOException {
                        StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)false);
                        String contentString = new String(buffer, 0, flowFileSize, charset);
                        String updatedValue = contentString.replaceAll(regex, replacementValue);
                        out.write(updatedValue.getBytes(charset));
                    }
                });
            } else {
                flowFile = session.write(flowFile, new StreamCallback(){

                    public void process(InputStream in, OutputStream out) throws IOException {
                        try (NLKBufferedReader br = new NLKBufferedReader(new InputStreamReader(in, charset), maxBufferSize);
                             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, charset));){
                            String oneLine;
                            while (null != (oneLine = br.readLine())) {
                                String updatedValue = oneLine.replaceAll(regex, replacementValue);
                                bw.write(updatedValue);
                            }
                        }
                    }
                });
            }
            logger.info("Transferred {} to 'success'", new Object[]{flowFile});
            session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
        }
    }
}

