/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.URISupport;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.standard.util.JmsProperties;
import org.apache.nifi.processors.standard.util.WrappedMessageConsumer;
import org.apache.nifi.processors.standard.util.WrappedMessageProducer;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.stream.io.ByteArrayOutputStream;

public class JmsFactory {
    public static final boolean DEFAULT_IS_TRANSACTED = false;
    public static final String ATTRIBUTE_PREFIX = "jms.";
    public static final String ATTRIBUTE_TYPE_SUFFIX = ".type";
    public static final String CLIENT_ID_FIXED_PREFIX = "NiFi-";
    public static final String JMS_MESSAGE_ID = "JMSMessageID";
    public static final String JMS_DESTINATION = "JMSDestination";
    public static final String JMS_REPLY_TO = "JMSReplyTo";
    public static final String JMS_DELIVERY_MODE = "JMSDeliveryMode";
    public static final String JMS_REDELIVERED = "JMSRedelivered";
    public static final String JMS_CORRELATION_ID = "JMSCorrelationID";
    public static final String JMS_TYPE = "JMSType";
    public static final String JMS_TIMESTAMP = "JMSTimestamp";
    public static final String JMS_EXPIRATION = "JMSExpiration";
    public static final String JMS_PRIORITY = "JMSPriority";
    public static final String PROP_TYPE_STRING = "string";
    public static final String PROP_TYPE_INTEGER = "integer";
    public static final String PROP_TYPE_OBJECT = "object";
    public static final String PROP_TYPE_BYTE = "byte";
    public static final String PROP_TYPE_DOUBLE = "double";
    public static final String PROP_TYPE_FLOAT = "float";
    public static final String PROP_TYPE_LONG = "long";
    public static final String PROP_TYPE_SHORT = "short";
    public static final String PROP_TYPE_BOOLEAN = "boolean";

    public static Connection createConnection(ProcessContext context) throws JMSException {
        return JmsFactory.createConnection(context, JmsFactory.createClientId(context));
    }

    public static Connection createConnection(ProcessContext context, String clientId) throws JMSException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(clientId);
        ConnectionFactory connectionFactory = JmsFactory.createConnectionFactory(context);
        String username = context.getProperty(JmsProperties.USERNAME).getValue();
        String password = context.getProperty(JmsProperties.PASSWORD).getValue();
        Connection connection = username == null && password == null ? connectionFactory.createConnection() : connectionFactory.createConnection(username, password);
        connection.setClientID(clientId);
        connection.start();
        return connection;
    }

    public static Connection createConnection(String url, String jmsProvider, String username, String password, int timeoutMillis) throws JMSException {
        ConnectionFactory connectionFactory = JmsFactory.createConnectionFactory(url, timeoutMillis, jmsProvider);
        return username == null && password == null ? connectionFactory.createConnection() : connectionFactory.createConnection(username, password);
    }

    public static String createClientId(ProcessContext context) {
        String clientIdPrefix = context.getProperty(JmsProperties.CLIENT_ID_PREFIX).getValue();
        return CLIENT_ID_FIXED_PREFIX + (clientIdPrefix == null ? "" : clientIdPrefix) + "-" + UUID.randomUUID().toString();
    }

    public static boolean clientIdPrefixEquals(String one, String two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        int uuidLen = UUID.randomUUID().toString().length();
        if (one.length() <= uuidLen || two.length() <= uuidLen) {
            return false;
        }
        return one.substring(0, one.length() - uuidLen).equals(two.substring(0, two.length() - uuidLen));
    }

    public static byte[] createByteArray(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            return JmsFactory.getMessageBytes((TextMessage)message);
        }
        if (message instanceof BytesMessage) {
            return JmsFactory.getMessageBytes((BytesMessage)message);
        }
        if (message instanceof StreamMessage) {
            return JmsFactory.getMessageBytes((StreamMessage)message);
        }
        if (message instanceof MapMessage) {
            return JmsFactory.getMessageBytes((MapMessage)message);
        }
        if (message instanceof ObjectMessage) {
            return JmsFactory.getMessageBytes((ObjectMessage)message);
        }
        return new byte[0];
    }

    private static byte[] getMessageBytes(TextMessage message) throws JMSException {
        return message.getText() == null ? new byte[]{} : message.getText().getBytes();
    }

    private static byte[] getMessageBytes(BytesMessage message) throws JMSException {
        long byteCount = message.getBodyLength();
        if (byteCount > Integer.MAX_VALUE) {
            throw new JMSException("Incoming message cannot be written to a FlowFile because its size is " + byteCount + " bytes, and the maximum size that this processor can handle is " + Integer.MAX_VALUE);
        }
        byte[] bytes = new byte[(int)byteCount];
        message.readBytes(bytes);
        return bytes;
    }

    private static byte[] getMessageBytes(StreamMessage message) throws JMSException {
        int byteCount;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] byteBuffer = new byte[4096];
        while ((byteCount = message.readBytes(byteBuffer)) != -1) {
            baos.write(byteBuffer, 0, byteCount);
        }
        baos.close();
        return baos.toByteArray();
    }

    private static byte[] getMessageBytes(MapMessage message) throws JMSException {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration elements = message.getMapNames();
        while (elements.hasMoreElements()) {
            String key = (String)elements.nextElement();
            map.put(key, message.getString(key));
        }
        return ((Object)map).toString().getBytes();
    }

    private static byte[] getMessageBytes(ObjectMessage message) throws JMSException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)baos);){
                oos.writeObject(message.getObject());
                oos.flush();
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public static Session createSession(ProcessContext context, Connection connection, boolean transacted) throws JMSException {
        String configuredAckMode = context.getProperty(JmsProperties.ACKNOWLEDGEMENT_MODE).getValue();
        return JmsFactory.createSession(connection, configuredAckMode, transacted);
    }

    public static Session createSession(Connection connection, String configuredAckMode, boolean transacted) throws JMSException {
        int ackMode = configuredAckMode == null ? 1 : (configuredAckMode.equalsIgnoreCase("Auto Acknowledge") ? 1 : 2);
        Session session = connection.createSession(transacted, ackMode);
        return session;
    }

    public static WrappedMessageConsumer createQueueMessageConsumer(ProcessContext context) throws JMSException {
        Connection connection = null;
        Session jmsSession = null;
        try {
            connection = JmsFactory.createConnection(context);
            jmsSession = JmsFactory.createSession(context, connection, false);
            String messageSelector = context.getProperty(JmsProperties.MESSAGE_SELECTOR).getValue();
            Destination destination = JmsFactory.createQueue(context);
            MessageConsumer messageConsumer = jmsSession.createConsumer(destination, messageSelector, false);
            return new WrappedMessageConsumer(connection, jmsSession, messageConsumer);
        }
        catch (JMSException e) {
            if (jmsSession != null) {
                jmsSession.close();
            }
            if (connection != null) {
                connection.close();
            }
            throw e;
        }
    }

    public static WrappedMessageConsumer createTopicMessageConsumer(ProcessContext context) throws JMSException {
        return JmsFactory.createTopicMessageConsumer(context, JmsFactory.createClientId(context));
    }

    public static WrappedMessageConsumer createTopicMessageConsumer(ProcessContext context, String clientId) throws JMSException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(clientId);
        Connection connection = null;
        Session jmsSession = null;
        try {
            connection = JmsFactory.createConnection(context, clientId);
            jmsSession = JmsFactory.createSession(context, connection, false);
            String messageSelector = context.getProperty(JmsProperties.MESSAGE_SELECTOR).getValue();
            Topic topic = JmsFactory.createTopic(context);
            Object messageConsumer = context.getProperty(JmsProperties.DURABLE_SUBSCRIPTION).asBoolean() != false ? jmsSession.createDurableSubscriber(topic, clientId, messageSelector, false) : jmsSession.createConsumer((Destination)topic, messageSelector, false);
            return new WrappedMessageConsumer(connection, jmsSession, (MessageConsumer)messageConsumer);
        }
        catch (JMSException e) {
            if (jmsSession != null) {
                jmsSession.close();
            }
            if (connection != null) {
                connection.close();
            }
            throw e;
        }
    }

    private static Destination getDestination(ProcessContext context) throws JMSException {
        String destinationType;
        switch (destinationType = context.getProperty(JmsProperties.DESTINATION_TYPE).getValue()) {
            case "Topic": {
                return JmsFactory.createTopic(context);
            }
        }
        return JmsFactory.createQueue(context);
    }

    public static WrappedMessageProducer createMessageProducer(ProcessContext context) throws JMSException {
        return JmsFactory.createMessageProducer(context, false);
    }

    public static WrappedMessageProducer createMessageProducer(ProcessContext context, boolean transacted) throws JMSException {
        Connection connection = null;
        Session jmsSession = null;
        try {
            connection = JmsFactory.createConnection(context);
            jmsSession = JmsFactory.createSession(context, connection, transacted);
            Destination destination = JmsFactory.getDestination(context);
            MessageProducer messageProducer = jmsSession.createProducer(destination);
            return new WrappedMessageProducer(connection, jmsSession, messageProducer);
        }
        catch (JMSException e) {
            if (connection != null) {
                connection.close();
            }
            if (jmsSession != null) {
                jmsSession.close();
            }
            throw e;
        }
    }

    public static Destination createQueue(ProcessContext context) {
        return JmsFactory.createQueue(context, context.getProperty(JmsProperties.DESTINATION_NAME).getValue());
    }

    public static Queue createQueue(ProcessContext context, String queueName) {
        return JmsFactory.createQueue(context.getProperty(JmsProperties.JMS_PROVIDER).getValue(), queueName);
    }

    public static Queue createQueue(String jmsProvider, String queueName) {
        switch (jmsProvider) {
            default: 
        }
        return new ActiveMQQueue(queueName);
    }

    private static Topic createTopic(ProcessContext context) {
        String topicName = context.getProperty(JmsProperties.DESTINATION_NAME).getValue();
        switch (context.getProperty(JmsProperties.JMS_PROVIDER).getValue()) {
            default: 
        }
        return new ActiveMQTopic(topicName);
    }

    private static ConnectionFactory createConnectionFactory(ProcessContext context) throws JMSException {
        URI uri;
        try {
            uri = new URI(context.getProperty(JmsProperties.URL).getValue());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Validated URI [" + context.getProperty(JmsProperties.URL) + "] was invalid", e);
        }
        int timeoutMillis = context.getProperty(JmsProperties.TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        String provider = context.getProperty(JmsProperties.JMS_PROVIDER).getValue();
        if (uri.getScheme().equals("ssl") || URISupport.isCompositeURI((URI)uri) && JmsFactory.compositeURIHasSSL(uri)) {
            SSLContextService sslContextService = (SSLContextService)context.getProperty(JmsProperties.SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
            if (sslContextService == null) {
                throw new IllegalArgumentException("Attempting to initiate SSL JMS connection and SSL Context is not set.");
            }
            return JmsFactory.createSslConnectionFactory(uri, timeoutMillis, provider, sslContextService.getKeyStoreFile(), sslContextService.getKeyStorePassword(), sslContextService.getTrustStoreFile(), sslContextService.getTrustStorePassword());
        }
        return JmsFactory.createConnectionFactory(uri, timeoutMillis, provider);
    }

    private static boolean compositeURIHasSSL(URI uri) {
        try {
            URISupport.CompositeData compositeData = URISupport.parseComposite((URI)uri);
            for (URI component : compositeData.getComponents()) {
                if (!component.getScheme().equals("ssl")) continue;
                return true;
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Attempting to initiate JMS with invalid composite URI [" + uri + "]", e);
        }
        return false;
    }

    public static ConnectionFactory createConnectionFactory(URI uri, int timeoutMillis, String jmsProvider) throws JMSException {
        return JmsFactory.createConnectionFactory(uri.toString(), timeoutMillis, jmsProvider);
    }

    public static ConnectionFactory createConnectionFactory(String url, int timeoutMillis, String jmsProvider) throws JMSException {
        switch (jmsProvider) {
            case "ActiveMQ": {
                ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(url);
                factory.setSendTimeout(timeoutMillis);
                return factory;
            }
        }
        throw new IllegalArgumentException("Unknown JMS Provider: " + jmsProvider);
    }

    public static ConnectionFactory createSslConnectionFactory(URI uri, int timeoutMillis, String jmsProvider, String keystore, String keystorePassword, String truststore, String truststorePassword) throws JMSException {
        return JmsFactory.createSslConnectionFactory(uri.toString(), timeoutMillis, jmsProvider, keystore, keystorePassword, truststore, truststorePassword);
    }

    public static ConnectionFactory createSslConnectionFactory(String url, int timeoutMillis, String jmsProvider, String keystore, String keystorePassword, String truststore, String truststorePassword) throws JMSException {
        switch (jmsProvider) {
            case "ActiveMQ": {
                ActiveMQSslConnectionFactory factory = new ActiveMQSslConnectionFactory(url);
                try {
                    factory.setKeyStore(keystore);
                }
                catch (Exception e) {
                    throw new JMSException("Problem Setting the KeyStore: " + e.getMessage());
                }
                factory.setKeyStorePassword(keystorePassword);
                try {
                    factory.setTrustStore(truststore);
                }
                catch (Exception e) {
                    throw new JMSException("Problem Setting the TrustStore: " + e.getMessage());
                }
                factory.setTrustStorePassword(truststorePassword);
                factory.setSendTimeout(timeoutMillis);
                return factory;
            }
        }
        throw new IllegalArgumentException("Unknown JMS Provider: " + jmsProvider);
    }

    public static Map<String, String> createAttributeMap(Message message) throws JMSException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            Object value = message.getObjectProperty(propName);
            if (value == null) {
                attributes.put(ATTRIBUTE_PREFIX + propName, "");
                attributes.put(ATTRIBUTE_PREFIX + propName + ATTRIBUTE_TYPE_SUFFIX, "Unknown");
                continue;
            }
            String valueString = value.toString();
            attributes.put(ATTRIBUTE_PREFIX + propName, valueString);
            String propType = value instanceof String ? PROP_TYPE_STRING : (value instanceof Double ? PROP_TYPE_DOUBLE : (value instanceof Float ? PROP_TYPE_FLOAT : (value instanceof Long ? PROP_TYPE_LONG : (value instanceof Integer ? PROP_TYPE_INTEGER : (value instanceof Short ? PROP_TYPE_SHORT : (value instanceof Byte ? PROP_TYPE_BYTE : (value instanceof Boolean ? PROP_TYPE_BOOLEAN : PROP_TYPE_OBJECT)))))));
            attributes.put(ATTRIBUTE_PREFIX + propName + ATTRIBUTE_TYPE_SUFFIX, propType);
        }
        if (message.getJMSCorrelationID() != null) {
            attributes.put("jms.JMSCorrelationID", message.getJMSCorrelationID());
        }
        if (message.getJMSDestination() != null) {
            String destinationName = message.getJMSDestination() instanceof Queue ? ((Queue)message.getJMSDestination()).getQueueName() : ((Topic)message.getJMSDestination()).getTopicName();
            attributes.put("jms.JMSDestination", destinationName);
        }
        if (message.getJMSMessageID() != null) {
            attributes.put("jms.JMSMessageID", message.getJMSMessageID());
        }
        if (message.getJMSReplyTo() != null) {
            attributes.put("jms.JMSReplyTo", message.getJMSReplyTo().toString());
        }
        if (message.getJMSType() != null) {
            attributes.put("jms.JMSType", message.getJMSType());
        }
        attributes.put("jms.JMSDeliveryMode", String.valueOf(message.getJMSDeliveryMode()));
        attributes.put("jms.JMSExpiration", String.valueOf(message.getJMSExpiration()));
        attributes.put("jms.JMSPriority", String.valueOf(message.getJMSPriority()));
        attributes.put("jms.JMSRedelivered", String.valueOf(message.getJMSRedelivered()));
        attributes.put("jms.JMSTimestamp", String.valueOf(message.getJMSTimestamp()));
        return attributes;
    }
}

