/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.EncryptContent;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;

public class OpenPGPPasswordBasedEncryptor
implements EncryptContent.Encryptor {
    private String algorithm;
    private String provider;
    private char[] password;
    private String filename;
    public static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";

    public OpenPGPPasswordBasedEncryptor(String algorithm, String provider, char[] passphrase, String filename) {
        this.algorithm = algorithm;
        this.provider = provider;
        this.password = passphrase;
        this.filename = filename;
    }

    @Override
    public StreamCallback getEncryptionCallback() throws Exception {
        return new OpenPGPEncryptCallback(this.algorithm, this.provider, this.password, this.filename);
    }

    @Override
    public StreamCallback getDecryptionCallback() throws Exception {
        return new OpenPGPDecryptCallback(this.provider, this.password);
    }

    private static class OpenPGPEncryptCallback
    implements StreamCallback {
        private String algorithm;
        private String provider;
        private char[] password;
        private String filename;

        OpenPGPEncryptCallback(String algorithm, String provider, char[] password, String filename) {
            this.algorithm = algorithm;
            this.provider = provider;
            this.password = password;
            this.filename = filename;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            try {
                int len;
                SecureRandom secureRandom = SecureRandom.getInstance(OpenPGPPasswordBasedEncryptor.SECURE_RANDOM_ALGORITHM);
                OutputStream output = out;
                if (EncryptContent.isPGPArmoredAlgorithm(this.algorithm)) {
                    output = new ArmoredOutputStream(out);
                }
                PGPEncryptedDataGenerator encGenerator = new PGPEncryptedDataGenerator(3, false, secureRandom, this.provider);
                encGenerator.addMethod(this.password);
                OutputStream encOut = encGenerator.open(output, new byte[65536]);
                PGPCompressedDataGenerator compData = new PGPCompressedDataGenerator(1, 1);
                OutputStream compOut = compData.open(encOut, new byte[65536]);
                PGPLiteralDataGenerator literal = new PGPLiteralDataGenerator();
                OutputStream literalOut = literal.open(compOut, 'b', this.filename, new Date(), new byte[65536]);
                byte[] buffer = new byte[4096];
                while ((len = in.read(buffer)) >= 0) {
                    literalOut.write(buffer, 0, len);
                }
                literalOut.close();
                compOut.close();
                encOut.close();
                output.close();
            }
            catch (Exception e) {
                throw new ProcessException(e.getMessage());
            }
        }
    }

    private static class OpenPGPDecryptCallback
    implements StreamCallback {
        private String provider;
        private char[] password;

        OpenPGPDecryptCallback(String provider, char[] password) {
            this.provider = provider;
            this.password = password;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            InputStream pgpin = PGPUtil.getDecoderStream((InputStream)in);
            PGPObjectFactory pgpFactory = new PGPObjectFactory(pgpin);
            Object obj = pgpFactory.nextObject();
            if (!(obj instanceof PGPEncryptedDataList) && !((obj = pgpFactory.nextObject()) instanceof PGPEncryptedDataList)) {
                throw new ProcessException("Invalid OpenPGP data");
            }
            PGPEncryptedDataList encList = (PGPEncryptedDataList)obj;
            if (!((obj = encList.get(0)) instanceof PGPPBEEncryptedData)) {
                throw new ProcessException("Invalid OpenPGP data");
            }
            PGPPBEEncryptedData encData = (PGPPBEEncryptedData)obj;
            try {
                int len;
                InputStream clearData = encData.getDataStream(this.password, this.provider);
                PGPObjectFactory clearFactory = new PGPObjectFactory(clearData);
                obj = clearFactory.nextObject();
                if (obj instanceof PGPCompressedData) {
                    PGPCompressedData compData = (PGPCompressedData)obj;
                    clearFactory = new PGPObjectFactory(compData.getDataStream());
                    obj = clearFactory.nextObject();
                }
                PGPLiteralData literal = (PGPLiteralData)obj;
                InputStream lis = literal.getInputStream();
                byte[] buffer = new byte[4096];
                while ((len = lis.read(buffer)) >= 0) {
                    out.write(buffer, 0, len);
                }
            }
            catch (Exception e) {
                throw new ProcessException(e.getMessage());
            }
        }
    }
}

