/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.EncryptContent;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.apache.nifi.stream.io.StreamUtils;

public class PasswordBasedEncryptor
implements EncryptContent.Encryptor {
    private Cipher cipher;
    private int saltSize;
    private SecretKey secretKey;
    private KeyDerivationFunction kdf;
    private int iterationsCount = 1000;
    @Deprecated
    private static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final int LEGACY_KDF_ITERATIONS = 1000;
    private static final int OPENSSL_EVP_HEADER_SIZE = 8;
    private static final int OPENSSL_EVP_SALT_SIZE = 8;
    private static final String OPENSSL_EVP_HEADER_MARKER = "Salted__";
    private static final int OPENSSL_EVP_KDF_ITERATIONS = 0;
    private static final int DEFAULT_MAX_ALLOWED_KEY_LENGTH = 128;
    private static boolean isUnlimitedStrengthCryptographyEnabled;

    public PasswordBasedEncryptor(String algorithm, String providerName, char[] password, KeyDerivationFunction kdf) {
        try {
            this.cipher = Cipher.getInstance(algorithm, providerName);
            this.kdf = kdf;
            if (this.isOpenSSLKDF()) {
                this.saltSize = 8;
                this.iterationsCount = 0;
            } else {
                int algorithmBlockSize = this.cipher.getBlockSize();
                this.saltSize = algorithmBlockSize > 0 ? algorithmBlockSize : 8;
            }
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm, providerName);
            this.secretKey = factory.generateSecret(pbeKeySpec);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public static int getMaxAllowedKeyLength(String algorithm) {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            return 128;
        }
        String parsedCipher = PasswordBasedEncryptor.parseCipherFromAlgorithm(algorithm);
        try {
            return Cipher.getMaxAllowedKeyLength(parsedCipher);
        }
        catch (NoSuchAlgorithmException e) {
            return 128;
        }
    }

    private static String parseCipherFromAlgorithm(String algorithm) {
        String AES = "AES";
        String TDES = "TRIPLEDES";
        String DES = "DES";
        String RC4 = "RC4";
        String RC2 = "RC2";
        String TWOFISH = "TWOFISH";
        List<String> SYMMETRIC_CIPHERS = Arrays.asList("AES", "TRIPLEDES", "DES", "RC4", "RC2", "TWOFISH");
        String ACTUAL_TDES_CIPHER = "DESede";
        for (String cipher : SYMMETRIC_CIPHERS) {
            if (!algorithm.contains(cipher)) continue;
            if (cipher.equals("TRIPLEDES")) {
                return "DESede";
            }
            return cipher;
        }
        return algorithm;
    }

    public static boolean supportsUnlimitedStrength() {
        return isUnlimitedStrengthCryptographyEnabled;
    }

    @Override
    public StreamCallback getEncryptionCallback() throws ProcessException {
        try {
            byte[] salt = new byte[this.saltSize];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(salt);
            return new EncryptCallback(salt);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    @Override
    public StreamCallback getDecryptionCallback() throws ProcessException {
        return new DecryptCallback();
    }

    private int getIterationsCount() {
        return this.iterationsCount;
    }

    private boolean isOpenSSLKDF() {
        return KeyDerivationFunction.OPENSSL_EVP_BYTES_TO_KEY.equals((Object)this.kdf);
    }

    static {
        try {
            isUnlimitedStrengthCryptographyEnabled = Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            isUnlimitedStrengthCryptographyEnabled = false;
        }
    }

    private class EncryptCallback
    implements StreamCallback {
        private final byte[] salt;

        public EncryptCallback(byte[] salt) {
            this.salt = salt;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            int len;
            PBEParameterSpec parameterSpec = new PBEParameterSpec(this.salt, PasswordBasedEncryptor.this.getIterationsCount());
            try {
                PasswordBasedEncryptor.this.cipher.init(1, (Key)PasswordBasedEncryptor.this.secretKey, parameterSpec);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            if (PasswordBasedEncryptor.this.isOpenSSLKDF()) {
                out.write(PasswordBasedEncryptor.OPENSSL_EVP_HEADER_MARKER.getBytes(StandardCharsets.US_ASCII));
            }
            out.write(this.salt);
            byte[] buffer = new byte[65536];
            while ((len = in.read(buffer)) > 0) {
                byte[] encryptedBytes = PasswordBasedEncryptor.this.cipher.update(buffer, 0, len);
                if (encryptedBytes == null) continue;
                out.write(encryptedBytes);
            }
            try {
                out.write(PasswordBasedEncryptor.this.cipher.doFinal());
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }

    private class DecryptCallback
    implements StreamCallback {
        public void process(InputStream in, OutputStream out) throws IOException {
            int len;
            byte[] salt = new byte[PasswordBasedEncryptor.this.saltSize];
            try {
                if (PasswordBasedEncryptor.this.isOpenSSLKDF()) {
                    byte[] header = new byte[8];
                    in.mark(9);
                    StreamUtils.fillBuffer((InputStream)in, (byte[])header);
                    byte[] headerMarkerBytes = PasswordBasedEncryptor.OPENSSL_EVP_HEADER_MARKER.getBytes(StandardCharsets.US_ASCII);
                    if (!Arrays.equals(headerMarkerBytes, header)) {
                        salt = new byte[]{};
                        in.reset();
                    }
                }
                StreamUtils.fillBuffer((InputStream)in, (byte[])salt);
            }
            catch (EOFException e) {
                throw new ProcessException("Cannot decrypt because file size is smaller than salt size", (Throwable)e);
            }
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, PasswordBasedEncryptor.this.getIterationsCount());
            try {
                PasswordBasedEncryptor.this.cipher.init(2, (Key)PasswordBasedEncryptor.this.secretKey, parameterSpec);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            byte[] buffer = new byte[65536];
            while ((len = in.read(buffer)) > 0) {
                byte[] decryptedBytes = PasswordBasedEncryptor.this.cipher.update(buffer, 0, len);
                if (decryptedBytes == null) continue;
                out.write(decryptedBytes);
            }
            try {
                out.write(PasswordBasedEncryptor.this.cipher.doFinal());
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }
}

