/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArgumentUtils {
    private static final char QUOTE = '\"';
    private static final List<Character> DELIMITING_CHARACTERS = new ArrayList<Character>(3);

    public static List<String> splitArgs(String input, char definedDelimiter) {
        if (input == null) {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        String trimmed = input.trim();
        boolean inQuotes = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < trimmed.length(); ++i) {
            char c = trimmed.charAt(i);
            if (DELIMITING_CHARACTERS.contains(Character.valueOf(c)) || c == definedDelimiter) {
                if (inQuotes) {
                    sb.append(c);
                    continue;
                }
                String arg = sb.toString().trim();
                if (!arg.isEmpty()) {
                    args.add(arg);
                }
                sb.setLength(0);
                continue;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            sb.append(c);
        }
        String finalArg = sb.toString().trim();
        if (!finalArg.isEmpty()) {
            args.add(finalArg);
        }
        return args;
    }

    static {
        DELIMITING_CHARACTERS.add(Character.valueOf('\t'));
        DELIMITING_CHARACTERS.add(Character.valueOf('\r'));
        DELIMITING_CHARACTERS.add(Character.valueOf('\n'));
    }
}

