/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.Serializable;
import org.apache.nifi.processors.standard.util.ListableEntity;

public class FileInfo
implements Comparable<FileInfo>,
Serializable,
ListableEntity {
    private static final long serialVersionUID = 1L;
    private final boolean directory;
    private final long size;
    private final long lastModifiedTime;
    private final String fileName;
    private final String fullPathFileName;
    private final String permissions;
    private final String owner;
    private final String group;

    public String getFileName() {
        return this.fileName;
    }

    public String getFullPathFileName() {
        return this.fullPathFileName;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fullPathFileName == null ? 0 : this.fullPathFileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileInfo other = (FileInfo)obj;
        return !(this.fullPathFileName == null ? other.fullPathFileName != null : !this.fullPathFileName.equals(other.fullPathFileName));
    }

    @Override
    public int compareTo(FileInfo o) {
        return this.fullPathFileName.compareTo(o.fullPathFileName);
    }

    protected FileInfo(Builder builder) {
        this.directory = builder.directory;
        this.size = builder.size;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.fileName = builder.fileName;
        this.fullPathFileName = builder.fullPathFileName;
        this.permissions = builder.permissions;
        this.owner = builder.owner;
        this.group = builder.group;
    }

    @Override
    public String getName() {
        return this.getFileName();
    }

    @Override
    public String getIdentifier() {
        String fullPathName = this.getFullPathFileName();
        return fullPathName == null ? this.getName() : fullPathName;
    }

    @Override
    public long getTimestamp() {
        return this.getLastModifiedTime();
    }

    public static final class Builder {
        private boolean directory;
        private long size;
        private long lastModifiedTime;
        private String fileName;
        private String fullPathFileName;
        private String permissions;
        private String owner;
        private String group;

        public FileInfo build() {
            return new FileInfo(this);
        }

        public Builder directory(boolean directory) {
            this.directory = directory;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder lastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public Builder filename(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder fullPathFileName(String pathFileName) {
            this.fullPathFileName = pathFileName;
            return this;
        }

        public Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }
    }
}

