/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util.crypto;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.util.crypto.AESKeyedCipherProvider;
import org.apache.nifi.processors.standard.util.crypto.BcryptCipherProvider;
import org.apache.nifi.processors.standard.util.crypto.CipherProvider;
import org.apache.nifi.processors.standard.util.crypto.NiFiLegacyCipherProvider;
import org.apache.nifi.processors.standard.util.crypto.OpenSSLPKCS5CipherProvider;
import org.apache.nifi.processors.standard.util.crypto.PBKDF2CipherProvider;
import org.apache.nifi.processors.standard.util.crypto.ScryptCipherProvider;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(CipherProviderFactory.class);
    private static final Map<KeyDerivationFunction, Class<? extends CipherProvider>> REGISTERED_CIPHER_PROVIDERS = new HashMap<KeyDerivationFunction, Class<? extends CipherProvider>>();

    public static CipherProvider getCipherProvider(KeyDerivationFunction kdf) {
        logger.debug("{} KDFs registered", (Object)REGISTERED_CIPHER_PROVIDERS.size());
        if (REGISTERED_CIPHER_PROVIDERS.containsKey(kdf)) {
            Class<? extends CipherProvider> clazz = REGISTERED_CIPHER_PROVIDERS.get(kdf);
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                logger.error("Error instantiating new {} with default parameters for {}", (Object)clazz.getName(), (Object)kdf.getName());
                throw new ProcessException("Error instantiating cipher provider");
            }
        }
        throw new IllegalArgumentException("No cipher provider registered for " + kdf.getName());
    }

    static {
        REGISTERED_CIPHER_PROVIDERS.put(KeyDerivationFunction.NIFI_LEGACY, NiFiLegacyCipherProvider.class);
        REGISTERED_CIPHER_PROVIDERS.put(KeyDerivationFunction.OPENSSL_EVP_BYTES_TO_KEY, OpenSSLPKCS5CipherProvider.class);
        REGISTERED_CIPHER_PROVIDERS.put(KeyDerivationFunction.PBKDF2, PBKDF2CipherProvider.class);
        REGISTERED_CIPHER_PROVIDERS.put(KeyDerivationFunction.BCRYPT, BcryptCipherProvider.class);
        REGISTERED_CIPHER_PROVIDERS.put(KeyDerivationFunction.SCRYPT, ScryptCipherProvider.class);
        REGISTERED_CIPHER_PROVIDERS.put(KeyDerivationFunction.NONE, AESKeyedCipherProvider.class);
    }
}

