/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.BufferedOutputStream;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"json", "attributes", "flowfile"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Generates a JSON representation of the input FlowFile Attributes. The resulting JSON can be written to either a new Attribute 'JSONAttributes' or written to the FlowFile as content.")
@WritesAttribute(attribute="JSONAttributes", description="JSON representation of Attributes")
public class AttributesToJSON
extends AbstractProcessor {
    public static final String JSON_ATTRIBUTE_NAME = "JSONAttributes";
    private static final String AT_LIST_SEPARATOR = ",";
    public static final String DESTINATION_ATTRIBUTE = "flowfile-attribute";
    public static final String DESTINATION_CONTENT = "flowfile-content";
    private static final String APPLICATION_JSON = "application/json";
    public static final PropertyDescriptor ATTRIBUTES_LIST = new PropertyDescriptor.Builder().name("Attributes List").description("Comma separated list of attributes to be included in the resulting JSON. If this value is left empty then all existing Attributes will be included. This list of attributes is case sensitive. If an attribute specified in the list is not found it will be be emitted to the resulting JSON with an empty string or NULL value.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DESTINATION = new PropertyDescriptor.Builder().name("Destination").description("Control if JSON value is written as a new flowfile attribute 'JSONAttributes' or written in the flowfile content. Writing to flowfile content will overwrite any existing flowfile content.").required(true).allowableValues(new String[]{"flowfile-attribute", "flowfile-content"}).defaultValue("flowfile-attribute").build();
    public static final PropertyDescriptor INCLUDE_CORE_ATTRIBUTES = new PropertyDescriptor.Builder().name("Include Core Attributes").description("Determines if the FlowFile org.apache.nifi.flowfile.attributes.CoreAttributes which are contained in every FlowFile should be included in the final JSON value generated.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor NULL_VALUE_FOR_EMPTY_STRING = new PropertyDescriptor.Builder().name("Null Value").description("If true a non existing or empty attribute will be NULL in the resulting JSON. If false an empty string will be placed in the JSON").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully converted attributes to JSON").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Failed to convert attributes to JSON").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(ATTRIBUTES_LIST);
        properties.add(DESTINATION);
        properties.add(INCLUDE_CORE_ATTRIBUTES);
        properties.add(NULL_VALUE_FOR_EMPTY_STRING);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected Map<String, String> buildAttributesMapForFlowFile(FlowFile ff, String atrList, boolean includeCoreAttributes, boolean nullValForEmptyString) {
        Map<String, String> atsToWrite = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)atrList)) {
            String[] ats = StringUtils.split((String)atrList, (String)AT_LIST_SEPARATOR);
            if (ats != null) {
                for (String str : ats) {
                    String cleanStr = str.trim();
                    String val = ff.getAttribute(cleanStr);
                    if (val != null) {
                        atsToWrite.put(cleanStr, val);
                        continue;
                    }
                    if (nullValForEmptyString) {
                        atsToWrite.put(cleanStr, null);
                        continue;
                    }
                    atsToWrite.put(cleanStr, "");
                }
            }
        } else {
            atsToWrite.putAll(ff.getAttributes());
        }
        if (!includeCoreAttributes) {
            atsToWrite = this.removeCoreAttributes(atsToWrite);
        }
        return atsToWrite;
    }

    protected Map<String, String> removeCoreAttributes(Map<String, String> atsToWrite) {
        for (CoreAttributes c : CoreAttributes.values()) {
            atsToWrite.remove(c.key());
        }
        return atsToWrite;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        final Map<String, String> atrList = this.buildAttributesMapForFlowFile(original, context.getProperty(ATTRIBUTES_LIST).getValue(), context.getProperty(INCLUDE_CORE_ATTRIBUTES).asBoolean(), context.getProperty(NULL_VALUE_FOR_EMPTY_STRING).asBoolean());
        try {
            switch (context.getProperty(DESTINATION).getValue()) {
                case "flowfile-attribute": {
                    FlowFile atFlowfile = session.putAttribute(original, JSON_ATTRIBUTE_NAME, objectMapper.writeValueAsString(atrList));
                    session.transfer(atFlowfile, REL_SUCCESS);
                    break;
                }
                case "flowfile-content": {
                    FlowFile conFlowfile = session.write(original, new StreamCallback(){

                        public void process(InputStream in, OutputStream out) throws IOException {
                            try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                                outputStream.write(objectMapper.writeValueAsBytes((Object)atrList));
                            }
                        }
                    });
                    conFlowfile = session.putAttribute(conFlowfile, CoreAttributes.MIME_TYPE.key(), APPLICATION_JSON);
                    session.transfer(conFlowfile, REL_SUCCESS);
                }
            }
        }
        catch (JsonProcessingException e) {
            this.getLogger().error(e.getMessage());
            session.transfer(original, REL_FAILURE);
        }
    }
}

