/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.AbstractDatabaseFetchProcessor;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.util.JdbcCommon;
import org.apache.nifi.util.StopWatch;

@EventDriven
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"sql", "select", "jdbc", "query", "database"})
@CapabilityDescription(value="Execute provided SQL select query. Query result will be converted to Avro format. Streaming is used so arbitrarily large result sets are supported. This processor can be scheduled to run on a timer, or cron expression, using the standard scheduling methods, or it can be triggered by an incoming FlowFile. If it is triggered by an incoming FlowFile, then attributes of that FlowFile will be available when evaluating the select query. FlowFile attribute 'querydbtable.row.count' indicates how many rows were selected.")
@Stateful(scopes={Scope.CLUSTER}, description="After performing a query on the specified table, the maximum values for the specified column(s) will be retained for use in future executions of the query. This allows the Processor to fetch only those records that have max values greater than the retained values. This can be used for incremental fetching, fetching of newly added rows, etc. To clear the maximum values, clear the state of the processor per the State Management documentation")
@WritesAttribute(attribute="querydbtable.row.count")
public class QueryDatabaseTable
extends AbstractDatabaseFetchProcessor {
    public static final String RESULT_ROW_COUNT = "querydbtable.row.count";
    public static final PropertyDescriptor FETCH_SIZE = new PropertyDescriptor.Builder().name("Fetch Size").description("The number of result rows to be fetched from the result set at a time. This is a hint to the driver and may not be honored and/or exact. If the value specified is zero, then the hint is ignored.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();

    public QueryDatabaseTable() {
        HashSet<Relationship> r = new HashSet<Relationship>();
        r.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(r);
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(DBCP_SERVICE);
        pds.add(DB_TYPE);
        pds.add(TABLE_NAME);
        pds.add(COLUMN_NAMES);
        pds.add(MAX_VALUE_COLUMN_NAMES);
        pds.add(QUERY_TIMEOUT);
        pds.add(FETCH_SIZE);
        this.propDescriptors = Collections.unmodifiableList(pds);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propDescriptors;
    }

    @Override
    @OnScheduled
    public void setup(ProcessContext context) {
        super.setup(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        block45: {
            String selectQuery;
            HashMap statePropertyMap;
            StateManager stateManager;
            ComponentLog logger;
            FlowFile fileToProcess;
            ProcessSession session;
            block44: {
                StateMap stateMap;
                session = sessionFactory.createSession();
                fileToProcess = null;
                logger = this.getLogger();
                DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
                DatabaseAdapter dbAdapter = (DatabaseAdapter)dbAdapters.get(context.getProperty(DB_TYPE).getValue());
                String tableName = context.getProperty(TABLE_NAME).getValue();
                String columnNames = context.getProperty(COLUMN_NAMES).getValue();
                String maxValueColumnNames = context.getProperty(MAX_VALUE_COLUMN_NAMES).getValue();
                Integer fetchSize = context.getProperty(FETCH_SIZE).asInteger();
                stateManager = context.getStateManager();
                try {
                    stateMap = stateManager.getState(Scope.CLUSTER);
                }
                catch (IOException ioe) {
                    this.getLogger().error("Failed to retrieve observed maximum values from the State Manager. Will not perform query until this is accomplished.", (Throwable)ioe);
                    context.yield();
                    return;
                }
                statePropertyMap = new HashMap(stateMap.toMap());
                List<String> maxValueColumnNameList = StringUtils.isEmpty((CharSequence)maxValueColumnNames) ? null : Arrays.asList(maxValueColumnNames.split("\\s*,\\s*"));
                selectQuery = this.getQuery(dbAdapter, tableName, columnNames, maxValueColumnNameList, stateMap);
                StopWatch stopWatch = new StopWatch(true);
                try (Connection con = dbcpService.getConnection();
                     Statement st = con.createStatement();){
                    if (fetchSize != null && fetchSize > 0) {
                        try {
                            st.setFetchSize(fetchSize);
                        }
                        catch (SQLException se) {
                            logger.debug("Cannot set fetch size to {} due to {}", new Object[]{fetchSize, se.getLocalizedMessage()}, (Throwable)se);
                        }
                    }
                    Integer queryTimeout = context.getProperty(QUERY_TIMEOUT).asTimePeriod(TimeUnit.SECONDS).intValue();
                    st.setQueryTimeout(queryTimeout);
                    AtomicLong nrOfRows = new AtomicLong(0L);
                    fileToProcess = session.create();
                    fileToProcess = session.write(fileToProcess, out -> {
                        try {
                            logger.debug("Executing query {}", new Object[]{selectQuery});
                            ResultSet resultSet = st.executeQuery(selectQuery);
                            MaxValueResultSetRowCollector maxValCollector = new MaxValueResultSetRowCollector(statePropertyMap, dbAdapter);
                            nrOfRows.set(JdbcCommon.convertToAvroStream(resultSet, out, tableName, maxValCollector));
                        }
                        catch (SQLException e) {
                            throw new ProcessException("Error during database query or conversion of records to Avro", (Throwable)e);
                        }
                    });
                    if (nrOfRows.get() > 0L) {
                        fileToProcess = session.putAttribute(fileToProcess, RESULT_ROW_COUNT, String.valueOf(nrOfRows.get()));
                        logger.info("{} contains {} Avro records; transferring to 'success'", new Object[]{fileToProcess, nrOfRows.get()});
                        String jdbcURL = "DBCPService";
                        try {
                            DatabaseMetaData databaseMetaData = con.getMetaData();
                            if (databaseMetaData != null) {
                                jdbcURL = databaseMetaData.getURL();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        session.getProvenanceReporter().receive(fileToProcess, jdbcURL, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                        session.transfer(fileToProcess, REL_SUCCESS);
                        break block44;
                    }
                    session.remove(fileToProcess);
                    context.yield();
                }
            }
            session.commit();
            try {
                stateManager.setState(statePropertyMap, Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
            }
            break block45;
            catch (SQLException | ProcessException e) {
                try {
                    logger.error("Unable to execute SQL select query {} due to {}", new Object[]{selectQuery, e});
                    if (fileToProcess != null) {
                        session.remove(fileToProcess);
                    }
                    context.yield();
                }
                catch (Throwable throwable) {
                    session.commit();
                    try {
                        stateManager.setState(statePropertyMap, Scope.CLUSTER);
                    }
                    catch (IOException ioe) {
                        this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                    }
                    throw throwable;
                }
                session.commit();
                try {
                    stateManager.setState(statePropertyMap, Scope.CLUSTER);
                }
                catch (IOException ioe) {
                    this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                }
            }
        }
    }

    protected String getQuery(DatabaseAdapter dbAdapter, String tableName, String columnNames, List<String> maxValColumnNames, StateMap stateMap) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name must be specified");
        }
        StringBuilder query = new StringBuilder(dbAdapter.getSelectStatement(tableName, columnNames, null, null, null, null));
        if (stateMap != null && stateMap.getVersion() != -1L && maxValColumnNames != null) {
            Map stateProperties = stateMap.toMap();
            ArrayList<String> whereClauses = new ArrayList<String>(maxValColumnNames.size());
            for (String colName : maxValColumnNames) {
                String maxValue = (String)stateProperties.get(colName.toLowerCase());
                if (StringUtils.isEmpty((CharSequence)maxValue)) continue;
                Integer type = (Integer)this.columnTypeMap.get(colName.toLowerCase());
                if (type == null) {
                    throw new IllegalArgumentException("No column type found for: " + colName);
                }
                whereClauses.add(colName + " > " + QueryDatabaseTable.getLiteralByType(type, maxValue, dbAdapter.getName()));
            }
            if (!whereClauses.isEmpty()) {
                query.append(" WHERE ");
                query.append(StringUtils.join(whereClauses, (String)" AND "));
            }
        }
        return query.toString();
    }

    protected class MaxValueResultSetRowCollector
    implements JdbcCommon.ResultSetRowCallback {
        DatabaseAdapter dbAdapter;
        Map<String, String> newColMap;

        public MaxValueResultSetRowCollector(Map<String, String> stateMap, DatabaseAdapter dbAdapter) {
            this.dbAdapter = dbAdapter;
            this.newColMap = stateMap;
        }

        @Override
        public void processRow(ResultSet resultSet) throws IOException {
            if (resultSet == null) {
                return;
            }
            try {
                ResultSetMetaData meta = resultSet.getMetaData();
                int nrOfColumns = meta.getColumnCount();
                if (nrOfColumns > 0) {
                    for (int i = 1; i <= nrOfColumns; ++i) {
                        String maxValueString;
                        String newMaxValueString;
                        String colName = meta.getColumnName(i).toLowerCase();
                        Integer type = (Integer)QueryDatabaseTable.this.columnTypeMap.get(colName);
                        if (type == null || resultSet.getObject(i) == null || (newMaxValueString = AbstractDatabaseFetchProcessor.getMaxValueFromRow(resultSet, i, type, maxValueString = this.newColMap.get(colName), this.dbAdapter.getName())) == null) continue;
                        this.newColMap.put(colName, newMaxValueString);
                    }
                }
            }
            catch (SQLException | ParseException e) {
                throw new IOException(e);
            }
        }
    }
}

