/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import java.nio.charset.Charset;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.frame.RELPFrameException;
import org.apache.nifi.processors.standard.relp.frame.RELPState;
import org.apache.nifi.stream.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RELPDecoder {
    static final Logger logger = LoggerFactory.getLogger(RELPDecoder.class);
    private RELPFrame.Builder frameBuilder;
    private RELPState currState = RELPState.TXNR;
    private final Charset charset;
    private final ByteArrayOutputStream currBytes;

    public RELPDecoder(Charset charset) {
        this(charset, new ByteArrayOutputStream(4096));
    }

    public RELPDecoder(Charset charset, ByteArrayOutputStream buffer) {
        this.charset = charset;
        this.currBytes = buffer;
        this.frameBuilder = new RELPFrame.Builder();
    }

    public void reset() {
        this.frameBuilder = new RELPFrame.Builder();
        this.currState = RELPState.TXNR;
        this.currBytes.reset();
    }

    public boolean process(byte currByte) throws RELPFrameException {
        try {
            switch (this.currState) {
                case TXNR: {
                    this.processTXNR(currByte);
                    break;
                }
                case COMMAND: {
                    this.processCOMMAND(currByte);
                    break;
                }
                case LENGTH: {
                    this.processLENGTH(currByte);
                    if (this.currState != RELPState.TRAILER) break;
                    return true;
                }
                case DATA: {
                    this.processDATA(currByte);
                    break;
                }
                case TRAILER: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new RELPFrameException("Error decoding RELP frame: " + e.getMessage(), e);
        }
    }

    public RELPFrame getFrame() throws RELPFrameException {
        if (this.currState != RELPState.TRAILER) {
            throw new RELPFrameException("Must be at the trailer of a frame");
        }
        try {
            RELPFrame frame = this.frameBuilder.build();
            this.processTRAILER((byte)10);
            return frame;
        }
        catch (Exception e) {
            throw new RELPFrameException("Error decoding RELP frame: " + e.getMessage(), e);
        }
    }

    private void processTXNR(byte b) {
        if (b == 32) {
            if (this.currBytes.size() > 0) {
                long txnr = Long.parseLong(new String(this.currBytes.toByteArray(), this.charset));
                this.frameBuilder.txnr(txnr);
                logger.debug("Transaction number is {}", new Object[]{txnr});
                this.currBytes.reset();
                this.currState = RELPState.COMMAND;
            }
        } else {
            this.currBytes.write((int)b);
        }
    }

    private void processCOMMAND(byte b) {
        if (b == 32) {
            String command = new String(this.currBytes.toByteArray(), this.charset);
            this.frameBuilder.command(command);
            logger.debug("Command is {}", new Object[]{command});
            this.currBytes.reset();
            this.currState = RELPState.LENGTH;
        } else {
            this.currBytes.write((int)b);
        }
    }

    private void processLENGTH(byte b) {
        if (b == 32 || this.currBytes.size() > 0 && b == 10) {
            int dataLength = Integer.parseInt(new String(this.currBytes.toByteArray(), this.charset));
            this.frameBuilder.dataLength(dataLength);
            logger.debug("Length is {}", new Object[]{dataLength});
            this.currBytes.reset();
            if (b == 32) {
                this.currState = RELPState.DATA;
            } else {
                this.frameBuilder.data(new byte[0]);
                this.currState = RELPState.TRAILER;
            }
        } else {
            this.currBytes.write((int)b);
        }
    }

    private void processDATA(byte b) {
        this.currBytes.write((int)b);
        logger.trace("Data size is {}", new Object[]{this.currBytes.size()});
        if (this.currBytes.size() >= this.frameBuilder.dataLength) {
            byte[] data = this.currBytes.toByteArray();
            this.frameBuilder.data(data);
            logger.debug("Reached expected data size of {}", new Object[]{this.frameBuilder.dataLength});
            this.currBytes.reset();
            this.currState = RELPState.TRAILER;
        }
    }

    private void processTRAILER(byte b) {
        if (b != 10) {
            logger.warn("Expected RELP trailing LF, but found another byte");
        }
        this.currBytes.reset();
        this.frameBuilder.reset();
        this.currState = RELPState.TXNR;
    }
}

