/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.nifi.processor.Processor;

public class FTPUtils {
    private static final Log logger = LogFactory.getLog(FTPUtils.class);
    public static final String CONNECTION_MODE_KEY = "connection.mode";
    public static final String ACTIVE_LOCAL_CONNECTION_MODE = "active_local";
    public static final String PASSIVE_LOCAL_CONNECTION_MODE = "passive_local";
    public static final String TRANSFER_MODE_KEY = "transfer.mode";
    public static final String BINARY_TRANSFER_MODE = "binary";
    public static final String ASCII_TRANSFER_MODE = "ascii";
    public static final String REMOTE_HOST_KEY = "remote.host";
    public static final String REMOTE_USER_KEY = "remote.user";
    public static final String REMOTE_PASSWORD_KEY = "remote.password";
    public static final String REMOTE_PORT_KEY = "remote.port";
    public static final String NETWORK_DATA_TIMEOUT_KEY = "network.data.timeout";
    public static final String NETWORK_SOCKET_TIMEOUT_KEY = "network.socket.timeout";

    public static FTPClient connect(FTPConfiguration conf, ProtocolCommandListener monitor) throws IOException {
        boolean loggedIn;
        if (null == conf) {
            throw new NullPointerException();
        }
        String portVal = conf.port;
        int portNum = null == portVal ? -1 : Integer.parseInt(portVal);
        String connectionModeVal = conf.connectionMode;
        String connectionMode = null == connectionModeVal ? ACTIVE_LOCAL_CONNECTION_MODE : connectionModeVal;
        String transferModeVal = conf.transferMode;
        String transferMode = null == transferModeVal ? BINARY_TRANSFER_MODE : transferModeVal;
        String networkDataTimeoutVal = conf.dataTimeout;
        int networkDataTimeout = null == networkDataTimeoutVal ? 0 : Integer.parseInt(networkDataTimeoutVal);
        String networkSocketTimeoutVal = conf.connectionTimeout;
        int networkSocketTimeout = null == networkSocketTimeoutVal ? 0 : Integer.parseInt(networkSocketTimeoutVal);
        FTPClient client = new FTPClient();
        if (networkDataTimeout > 0) {
            client.setDataTimeout(networkDataTimeout);
        }
        if (networkSocketTimeout > 0) {
            client.setDefaultTimeout(networkSocketTimeout);
        }
        client.setRemoteVerificationEnabled(false);
        if (null != monitor) {
            client.addProtocolCommandListener(monitor);
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByAddress(conf.remoteHostname, null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (inetAddress == null) {
            inetAddress = InetAddress.getByName(conf.remoteHostname);
        }
        if (portNum < 0) {
            client.connect(inetAddress);
        } else {
            client.connect(inetAddress, portNum);
        }
        if (networkDataTimeout > 0) {
            client.setDataTimeout(networkDataTimeout);
        }
        if (networkSocketTimeout > 0) {
            client.setSoTimeout(networkSocketTimeout);
        }
        if (!(loggedIn = client.login(conf.username, conf.password))) {
            throw new IOException("Could not login for user '" + conf.username + "'");
        }
        if (connectionMode.equals(ACTIVE_LOCAL_CONNECTION_MODE)) {
            client.enterLocalActiveMode();
        } else if (connectionMode.equals(PASSIVE_LOCAL_CONNECTION_MODE)) {
            client.enterLocalPassiveMode();
        }
        boolean transferModeSet = false;
        transferModeSet = transferMode.equals(ASCII_TRANSFER_MODE) ? client.setFileType(0) : client.setFileType(2);
        if (!transferModeSet) {
            throw new IOException("Unable to set transfer mode to type " + transferMode);
        }
        return client;
    }

    public static void changeWorkingDirectory(FTPClient client, String dirPath, boolean createDirs, Processor processor) throws IOException {
        String currentWorkingDirectory = client.printWorkingDirectory();
        File dir = new File(dirPath);
        logger.debug((Object)(processor + " attempting to change directory from " + currentWorkingDirectory + " to " + dir.getPath()));
        boolean dirExists = false;
        String forwardPaths = dir.getPath().replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("/"));
        try {
            dirExists = client.changeWorkingDirectory(forwardPaths);
            if (dirExists) {
                logger.debug((Object)(processor + " changed working directory to '" + forwardPaths + "' from '" + currentWorkingDirectory + "'"));
            } else {
                logger.debug((Object)(processor + " could not change directory to '" + forwardPaths + "' from '" + currentWorkingDirectory + "' so trying the hard way."));
            }
        }
        catch (IOException ioe) {
            logger.debug((Object)(processor + " could not change directory to '" + forwardPaths + "' from '" + currentWorkingDirectory + "' so trying the hard way."));
        }
        if (!dirExists) {
            LinkedList<String> stack = new LinkedList<String>();
            File fakeFile = new File(dir.getPath());
            do {
                stack.push(fakeFile.getName());
            } while ((fakeFile = fakeFile.getParentFile()) != null);
            String dirName = null;
            while ((dirName = (String)stack.peek()) != null) {
                stack.pop();
                dirName = "".equals(dirName.trim()) ? "/" : dirName;
                boolean exists = false;
                try {
                    exists = client.changeWorkingDirectory(dirName);
                }
                catch (IOException ioe) {
                    exists = false;
                }
                if (!exists && createDirs) {
                    logger.debug((Object)(processor + " creating new directory and changing to it " + dirName));
                    client.makeDirectory(dirName);
                    if (!client.makeDirectory(dirName) && !client.changeWorkingDirectory(dirName)) {
                        throw new IOException(processor + " could not create and change to newly created directory " + dirName);
                    }
                    logger.debug((Object)(processor + " successfully changed working directory to " + dirName));
                    continue;
                }
                if (exists) continue;
                throw new IOException(processor + " could not change directory to '" + dirName + "' from '" + currentWorkingDirectory + "'");
            }
        }
    }

    public static class FTPConfiguration {
        private String remoteHostname;
        private String username;
        private String port;
        private String connectionTimeout;
        private String dataTimeout;
        private String password;
        private String connectionMode;
        private String transferMode;

        public void setRemoteHostname(String val) {
            this.remoteHostname = val;
        }

        public String getRemoteHostname() {
            return this.remoteHostname;
        }

        public void setUsername(String val) {
            this.username = val;
        }

        public String getUsername() {
            return this.username;
        }

        public void setPort(String val) {
            this.port = val;
        }

        public String getPort() {
            return this.port;
        }

        public void setConnectionTimeout(String val) {
            this.connectionTimeout = val;
        }

        public void setDataTimeout(String val) {
            this.dataTimeout = val;
        }

        public void setPassword(String val) {
            this.password = val;
        }

        public void setConnectionMode(String val) {
            this.connectionMode = val;
        }

        public void setTransferMode(String val) {
            this.transferMode = val;
        }
    }

    public static class FTPCommandMonitor
    implements ProtocolCommandListener {
        final Processor processor;

        public FTPCommandMonitor(Processor _processor) {
            this.processor = _processor;
        }

        public void protocolCommandSent(ProtocolCommandEvent event) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.processor + " : " + event.getMessage().trim()));
            }
        }

        public void protocolReplyReceived(ProtocolCommandEvent event) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.processor + " : " + event.getMessage().trim()));
            }
        }
    }
}

