/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.io.nio.BufferPool;
import org.apache.nifi.io.nio.consumer.StreamConsumer;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.stream.io.BufferedOutputStream;

public class UDPStreamConsumer
implements StreamConsumer {
    private final ComponentLog logger;
    final List<FlowFile> newFlowFileQueue;
    private final String uniqueId;
    private BufferPool bufferPool = null;
    private final BlockingQueue<ByteBuffer> filledBuffers = new LinkedBlockingQueue<ByteBuffer>();
    private final AtomicBoolean streamEnded = new AtomicBoolean(false);
    private final AtomicBoolean consumerDone = new AtomicBoolean(false);
    private ProcessSession session;
    private final UDPConsumerCallback udpCallback;

    public UDPStreamConsumer(String streamId, List<FlowFile> newFlowFiles, long fileSizeTrigger, ComponentLog logger, boolean flowFilePerDatagram) {
        this.uniqueId = streamId;
        this.newFlowFileQueue = newFlowFiles;
        this.logger = logger;
        this.udpCallback = new UDPConsumerCallback(this.filledBuffers, fileSizeTrigger, flowFilePerDatagram);
    }

    public void setReturnBufferQueue(BufferPool pool) {
        this.bufferPool = pool;
        this.udpCallback.setBufferPool(pool);
    }

    public void addFilledBuffer(ByteBuffer buffer) {
        if (this.isConsumerFinished()) {
            this.bufferPool.returnBuffer(buffer, 0);
        } else {
            this.filledBuffers.add(buffer);
        }
    }

    private void close() {
        if (this.isConsumerFinished()) {
            return;
        }
        this.consumerDone.set(true);
        ByteBuffer buf = null;
        while ((buf = (ByteBuffer)this.filledBuffers.poll()) != null) {
            this.bufferPool.returnBuffer(buf, 0);
        }
    }

    public void setSession(ProcessSession session) {
        this.session = session;
    }

    public void process() throws IOException {
        if (this.isConsumerFinished()) {
            return;
        }
        FlowFile newFlowFile = null;
        try {
            if (this.streamEnded.get() && this.filledBuffers.isEmpty()) {
                this.close();
                return;
            }
            if (this.filledBuffers.isEmpty()) {
                return;
            }
            newFlowFile = this.session.create();
            newFlowFile = this.session.putAttribute(newFlowFile, "source.stream.identifier", this.uniqueId);
            if ((newFlowFile = this.session.write(newFlowFile, (OutputStreamCallback)this.udpCallback)).getSize() == 0L) {
                this.session.remove(newFlowFile);
                return;
            }
            this.newFlowFileQueue.add(newFlowFile);
        }
        catch (Exception ex) {
            this.close();
            if (newFlowFile != null) {
                try {
                    this.session.remove(newFlowFile);
                }
                catch (Exception ex2) {
                    this.logger.warn("Unable to delete partial flow file due to: ", (Throwable)ex2);
                }
            }
            throw new IOException("Problem while processing data stream", ex);
        }
    }

    public void signalEndOfStream() {
        this.streamEnded.set(true);
    }

    public boolean isConsumerFinished() {
        return this.consumerDone.get();
    }

    public String getId() {
        return this.uniqueId;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        UDPStreamConsumer rhs = (UDPStreamConsumer)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.uniqueId, (Object)rhs.uniqueId).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.uniqueId).toHashCode();
    }

    public final String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.uniqueId).toString();
    }

    public static final class UDPConsumerCallback
    implements OutputStreamCallback {
        BufferPool bufferPool;
        final BlockingQueue<ByteBuffer> filledBuffers;
        final long fileSizeTrigger;
        final boolean flowFilePerDatagram;

        public UDPConsumerCallback(BlockingQueue<ByteBuffer> filledBuffers, long fileSizeTrigger, boolean flowFilePerDatagram) {
            this.filledBuffers = filledBuffers;
            this.fileSizeTrigger = fileSizeTrigger;
            this.flowFilePerDatagram = flowFilePerDatagram;
        }

        public void setBufferPool(BufferPool pool) {
            this.bufferPool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(OutputStream out) throws IOException {
            try {
                long totalBytes = 0L;
                try (WritableByteChannel wbc = Channels.newChannel((OutputStream)new BufferedOutputStream(out));){
                    ByteBuffer buffer = null;
                    while ((buffer = this.filledBuffers.poll(50L, TimeUnit.MILLISECONDS)) != null) {
                        int bytesWrittenThisPass = 0;
                        try {
                            while (buffer.hasRemaining()) {
                                bytesWrittenThisPass += wbc.write(buffer);
                            }
                            if ((totalBytes += (long)bytesWrittenThisPass) <= this.fileSizeTrigger && !this.flowFilePerDatagram) continue;
                            break;
                        }
                        finally {
                            this.bufferPool.returnBuffer(buffer, bytesWrittenThisPass);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

