/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang3.StringUtils;

public class JdbcCommon {
    private static final int MAX_DIGITS_IN_BIGINT = 19;

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream) throws SQLException, IOException {
        return JdbcCommon.convertToAvroStream(rs, outStream, null, null);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName) throws SQLException, IOException {
        return JdbcCommon.convertToAvroStream(rs, outStream, recordName, null);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, ResultSetRowCallback callback) throws IOException, SQLException {
        return JdbcCommon.convertToAvroStream(rs, outStream, recordName, callback, 0);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, ResultSetRowCallback callback, int maxRows) throws SQLException, IOException {
        Schema schema = JdbcCommon.createSchema(rs, recordName);
        GenericData.Record rec = new GenericData.Record(schema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, outStream);
            ResultSetMetaData meta = rs.getMetaData();
            int nrOfColumns = meta.getColumnCount();
            long nrOfRows = 0L;
            while (rs.next()) {
                if (callback != null) {
                    callback.processRow(rs);
                }
                for (int i = 1; i <= nrOfColumns; ++i) {
                    int javaSqlType = meta.getColumnType(i);
                    Object value = rs.getObject(i);
                    if (value == null) {
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == -2 || javaSqlType == -3 || javaSqlType == -4 || javaSqlType == 2003 || javaSqlType == 2004 || javaSqlType == 2005) {
                        byte[] bytes = rs.getBytes(i);
                        ByteBuffer bb = ByteBuffer.wrap(bytes);
                        rec.put(i - 1, (Object)bb);
                        continue;
                    }
                    if (value instanceof Byte) {
                        rec.put(i - 1, (Object)((Byte)value).intValue());
                        continue;
                    }
                    if (value instanceof BigDecimal) {
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof BigInteger) {
                        int precision = meta.getPrecision(i);
                        if (javaSqlType == -5) {
                            if (precision < 0 || precision > 19) {
                                rec.put(i - 1, (Object)value.toString());
                                continue;
                            }
                            try {
                                rec.put(i - 1, (Object)((BigInteger)value).longValueExact());
                            }
                            catch (ArithmeticException ae) {
                                rec.put(i - 1, (Object)value.toString());
                            }
                            continue;
                        }
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof Number || value instanceof Boolean) {
                        rec.put(i - 1, value);
                        continue;
                    }
                    rec.put(i - 1, (Object)value.toString());
                }
                dataFileWriter.append((Object)rec);
                if (maxRows <= 0 || ++nrOfRows != (long)maxRows) continue;
            }
            long l = nrOfRows;
            return l;
        }
    }

    public static Schema createSchema(ResultSet rs) throws SQLException {
        return JdbcCommon.createSchema(rs, null);
    }

    public static Schema createSchema(ResultSet rs, String recordName) throws SQLException {
        String tableNameFromMeta;
        String tableName;
        ResultSetMetaData meta = rs.getMetaData();
        int nrOfColumns = meta.getColumnCount();
        String string = tableName = StringUtils.isEmpty((CharSequence)recordName) ? "NiFi_ExecuteSQL_Record" : recordName;
        if (nrOfColumns > 0 && !StringUtils.isBlank((CharSequence)(tableNameFromMeta = meta.getTableName(1)))) {
            tableName = tableNameFromMeta;
        }
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)tableName).namespace("any.data")).fields();
        block13: for (int i = 1; i <= nrOfColumns; ++i) {
            switch (meta.getColumnType(i)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block13;
                }
                case -7: 
                case 16: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().booleanType()).endUnion()).noDefault();
                    continue block13;
                }
                case 4: {
                    if (meta.isSigned(i)) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                        continue block13;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block13;
                }
                case -6: 
                case 5: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                    continue block13;
                }
                case -5: {
                    int precision = meta.getPrecision(i);
                    if (precision < 0 || precision > 19) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                        continue block13;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block13;
                }
                case -8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block13;
                }
                case 6: 
                case 7: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().floatType()).endUnion()).noDefault();
                    continue block13;
                }
                case 8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().doubleType()).endUnion()).noDefault();
                    continue block13;
                }
                case 2: 
                case 3: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block13;
                }
                case 91: 
                case 92: 
                case 93: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block13;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2003: 
                case 2004: 
                case 2005: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().bytesType()).endUnion()).noDefault();
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException("createSchema: Unknown SQL type " + meta.getColumnType(i) + " cannot be converted to Avro type");
                }
            }
        }
        return (Schema)builder.endRecord();
    }

    public static interface ResultSetRowCallback {
        public void processRow(ResultSet var1) throws IOException;
    }
}

