/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.MergeContent;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.stream.io.ByteArrayOutputStream;
import org.apache.nifi.stream.io.ByteCountingInputStream;
import org.apache.nifi.stream.io.ByteCountingOutputStream;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"split", "text"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Splits a text file into multiple smaller text files on line boundaries limited by maximum number of lines or total size of fragment. Each output split file will contain no more than the configured number of lines or bytes. If both Line Split Count and Maximum Fragment Size are specified, the split occurs at whichever limit is reached first. If the first line of a fragment exceeds the Maximum Fragment Size, that line will be output in a single split file which  exceeds the configured maximum size limit.")
@WritesAttributes(value={@WritesAttribute(attribute="text.line.count", description="The number of lines of text from the original FlowFile that were copied to this FlowFile"), @WritesAttribute(attribute="fragment.size", description="The number of bytes from the original FlowFile that were copied to this FlowFile, including header, if applicable, which is duplicated in each split FlowFile"), @WritesAttribute(attribute="fragment.identifier", description="All split FlowFiles produced from the same parent FlowFile will have the same randomly generated UUID added for this attribute"), @WritesAttribute(attribute="fragment.index", description="A one-up number that indicates the ordering of the split FlowFiles that were created from a single parent FlowFile"), @WritesAttribute(attribute="fragment.count", description="The number of split FlowFiles generated from the parent FlowFile"), @WritesAttribute(attribute="segment.original.filename ", description="The filename of the parent FlowFile")})
@SeeAlso(value={MergeContent.class})
public class SplitText
extends AbstractProcessor {
    public static final String SPLIT_LINE_COUNT = "text.line.count";
    public static final String FRAGMENT_SIZE = "fragment.size";
    public static final String FRAGMENT_ID = "fragment.identifier";
    public static final String FRAGMENT_INDEX = "fragment.index";
    public static final String FRAGMENT_COUNT = "fragment.count";
    public static final String SEGMENT_ORIGINAL_FILENAME = "segment.original.filename";
    public static final PropertyDescriptor LINE_SPLIT_COUNT = new PropertyDescriptor.Builder().name("Line Split Count").description("The number of lines that will be added to each split file, excluding header lines. A value of zero requires Maximum Fragment Size to be set, and line count will not be considered in determining splits.").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor FRAGMENT_MAX_SIZE = new PropertyDescriptor.Builder().name("Maximum Fragment Size").description("The maximum size of each split file, including header lines. NOTE: in the case where a single line exceeds this property (including headers, if applicable), that line will be output in a split of its own which exceeds this Maximum Fragment Size setting.").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor HEADER_LINE_COUNT = new PropertyDescriptor.Builder().name("Header Line Count").description("The number of lines that should be considered part of the header; the header lines will be duplicated to all split files").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("0").build();
    public static final PropertyDescriptor HEADER_MARKER = new PropertyDescriptor.Builder().name("Header Line Marker Characters").description("The first character(s) on the line of the datafile which signifies a header line. This value is ignored when Header Line Count is non-zero. The first line not containing the Header Line Marker Characters and all subsequent lines are considered non-header").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor REMOVE_TRAILING_NEWLINES = new PropertyDescriptor.Builder().name("Remove Trailing Newlines").description("Whether to remove newlines at the end of each split file. This should be false if you intend to merge the split files later. If this is set to 'true' and a FlowFile is generated that contains only 'empty lines' (i.e., consists only of \r and \n characters), the FlowFile will not be emitted. Note, however, that if header lines are specified, the resultant FlowFile will never be empty as it will consist of the header lines, so a FlowFile may be emitted that contains only the header lines.").required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original input file will be routed to this destination when it has been successfully split into 1 or more files").build();
    public static final Relationship REL_SPLITS = new Relationship.Builder().name("splits").description("The split files will be routed to this destination when an input file is successfully split into 1 or more split files").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a file cannot be split for some reason, the original file will be routed to this destination and nothing will be routed elsewhere").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(LINE_SPLIT_COUNT);
        properties.add(FRAGMENT_MAX_SIZE);
        properties.add(HEADER_LINE_COUNT);
        properties.add(HEADER_MARKER);
        properties.add(REMOVE_TRAILING_NEWLINES);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_SPLITS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean invalidState = validationContext.getProperty(LINE_SPLIT_COUNT).asInteger() == 0 && !validationContext.getProperty(FRAGMENT_MAX_SIZE).isSet();
        results.add(new ValidationResult.Builder().subject("Maximum Fragment Size").valid(!invalidState).explanation("Property must be specified when Line Split Count is 0").build());
        return results;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    private int readLines(InputStream in, int maxNumLines, long maxByteCount, OutputStream out, boolean includeLineDelimiter, byte[] leadingNewLineBytes) throws IOException {
        EndOfLineBuffer eolBuffer = new EndOfLineBuffer();
        byte[] leadingBytes = leadingNewLineBytes;
        int numLines = 0;
        long totalBytes = 0L;
        for (int i = 0; i < maxNumLines; ++i) {
            EndOfLineMarker eolMarker = this.countBytesToSplitPoint(in, out, totalBytes, maxByteCount, includeLineDelimiter, eolBuffer, leadingBytes);
            long bytes = eolMarker.getBytesConsumed();
            leadingBytes = eolMarker.getLeadingNewLineBytes();
            if (includeLineDelimiter && out != null) {
                if (leadingBytes != null) {
                    out.write(leadingBytes);
                    leadingBytes = null;
                }
                eolBuffer.drainTo(out);
            }
            totalBytes += bytes;
            if (bytes <= 0L) {
                return numLines;
            }
            ++numLines;
            if (totalBytes >= maxByteCount) break;
        }
        return numLines;
    }

    private EndOfLineMarker countBytesToSplitPoint(InputStream in, OutputStream out, long bytesReadSoFar, long maxSize, boolean includeLineDelimiter, EndOfLineBuffer eolBuffer, byte[] leadingNewLineBytes) throws IOException {
        int nextByte;
        long bytesRead = 0L;
        ByteArrayOutputStream buffer = out != null ? new ByteArrayOutputStream() : null;
        byte[] bytesToWriteFirst = leadingNewLineBytes;
        in.mark(Integer.MAX_VALUE);
        do {
            if ((nextByte = in.read()) == -1) {
                if (buffer != null) {
                    buffer.writeTo(out);
                    buffer.close();
                }
                return new EndOfLineMarker(bytesRead, eolBuffer, true, bytesToWriteFirst);
            }
            if (bytesToWriteFirst != null && (long)bytesToWriteFirst.length + bytesRead > maxSize - bytesReadSoFar && includeLineDelimiter) {
                return new EndOfLineMarker(-1L, eolBuffer, false, leadingNewLineBytes);
            }
            if (buffer != null && includeLineDelimiter && bytesToWriteFirst != null) {
                bytesRead += (long)bytesToWriteFirst.length;
                buffer.write(bytesToWriteFirst);
                bytesToWriteFirst = null;
            }
            ++bytesRead;
            if (buffer != null && nextByte != 10 && nextByte != 13) {
                if (bytesToWriteFirst != null) {
                    buffer.write(bytesToWriteFirst);
                }
                bytesToWriteFirst = null;
                eolBuffer.drainTo((OutputStream)buffer);
                eolBuffer.clear();
                buffer.write(nextByte);
            }
            if (bytesRead > maxSize - bytesReadSoFar && bytesReadSoFar > 0L) {
                in.reset();
                if (buffer != null) {
                    buffer.close();
                }
                return new EndOfLineMarker(-1L, eolBuffer, false, leadingNewLineBytes);
            }
            if (nextByte != 10) continue;
            if (buffer != null) {
                buffer.writeTo(out);
                buffer.close();
                eolBuffer.addEndOfLine(false, true);
            }
            return new EndOfLineMarker(bytesRead, eolBuffer, false, bytesToWriteFirst);
        } while (nextByte != 13);
        if (buffer != null) {
            buffer.writeTo(out);
            buffer.close();
        }
        in.mark(1);
        int lookAheadByte = in.read();
        if (lookAheadByte == 10) {
            eolBuffer.addEndOfLine(true, true);
            return new EndOfLineMarker(bytesRead + 1L, eolBuffer, false, bytesToWriteFirst);
        }
        in.reset();
        eolBuffer.addEndOfLine(true, false);
        return new EndOfLineMarker(bytesRead, eolBuffer, false, bytesToWriteFirst);
    }

    private SplitInfo locateSplitPoint(InputStream in, int numLines, boolean keepAllNewLines, long maxSize, long bufferedBytes) throws IOException {
        SplitInfo info = new SplitInfo();
        EndOfLineBuffer eolBuffer = new EndOfLineBuffer();
        int lastByte = -1;
        info.lengthBytes = bufferedBytes;
        long lastEolBufferLength = 0L;
        while ((info.lengthLines < (long)numLines || info.lengthLines == (long)numLines && lastByte == 13) && (info.lengthBytes + (long)eolBuffer.length() < maxSize || info.lengthLines == 0L) && (long)eolBuffer.length() < maxSize) {
            in.mark(1);
            int nextByte = in.read();
            if (info.lengthLines == (long)numLines && lastByte == 13 && nextByte != 10) {
                in.reset();
                break;
            }
            switch (nextByte) {
                case -1: {
                    info.endOfStream = true;
                    if (keepAllNewLines) {
                        info.lengthBytes += (long)eolBuffer.length();
                    }
                    if (lastByte != 13) {
                        ++info.lengthLines;
                    }
                    info.bufferedBytes = 0L;
                    return info;
                }
                case 13: {
                    eolBuffer.addEndOfLine(true, false);
                    ++info.lengthLines;
                    info.bufferedBytes = 0L;
                    break;
                }
                case 10: {
                    eolBuffer.addEndOfLine(false, true);
                    if (lastByte != 13) {
                        ++info.lengthLines;
                    }
                    info.bufferedBytes = 0L;
                    break;
                }
                default: {
                    if (eolBuffer.length() > 0) {
                        info.lengthBytes += (long)eolBuffer.length();
                        lastEolBufferLength = eolBuffer.length();
                        eolBuffer.clear();
                    }
                    ++info.lengthBytes;
                    ++info.bufferedBytes;
                }
            }
            lastByte = nextByte;
        }
        if (info.lengthBytes + (long)eolBuffer.length() >= maxSize && !keepAllNewLines) {
            info.lengthBytes -= lastEolBufferLength;
        }
        if (keepAllNewLines) {
            info.lengthBytes += (long)eolBuffer.length();
        }
        return info;
    }

    private int countHeaderLines(ByteCountingInputStream in, String headerMarker) throws IOException {
        int headerInfo = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in));
        in.mark(Integer.MAX_VALUE);
        String line = br.readLine();
        while (line != null) {
            if (!line.startsWith(headerMarker)) {
                in.reset();
                return headerInfo;
            }
            ++headerInfo;
            line = br.readLine();
        }
        in.reset();
        return headerInfo;
    }

    public void onTrigger(final ProcessContext context, final ProcessSession session) {
        final FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        final ComponentLog logger = this.getLogger();
        final int headerCount = context.getProperty(HEADER_LINE_COUNT).asInteger();
        final int maxLineCount = context.getProperty(LINE_SPLIT_COUNT).asInteger() == 0 ? Integer.MAX_VALUE : context.getProperty(LINE_SPLIT_COUNT).asInteger();
        final long maxFragmentSize = context.getProperty(FRAGMENT_MAX_SIZE).isSet() ? context.getProperty(FRAGMENT_MAX_SIZE).asDataSize(DataUnit.B).longValue() : Long.MAX_VALUE;
        final String headerMarker = context.getProperty(HEADER_MARKER).getValue();
        final boolean includeLineDelimiter = context.getProperty(REMOVE_TRAILING_NEWLINES).asBoolean() == false;
        final AtomicReference<Object> errorMessage = new AtomicReference<Object>(null);
        final ArrayList splitInfos = new ArrayList();
        final long startNanos = System.nanoTime();
        final ArrayList<FlowFile> splits = new ArrayList<FlowFile>();
        session.read(flowFile, new InputStreamCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(InputStream rawIn) throws IOException {
                try (BufferedInputStream bufferedIn = new BufferedInputStream(rawIn);
                     final ByteCountingInputStream in = new ByteCountingInputStream((InputStream)bufferedIn);){
                    byte[] headerBytesWithoutTrailingNewLines;
                    byte[] headerNewLineBytes;
                    long bufferedPartialLine = 0L;
                    ByteArrayOutputStream headerStream = new ByteArrayOutputStream();
                    int headerInfoLineCount = 0;
                    if (headerCount > 0) {
                        headerInfoLineCount = headerCount;
                    } else if (headerMarker != null) {
                        headerInfoLineCount = SplitText.this.countHeaderLines(in, headerMarker);
                    }
                    if (headerInfoLineCount > 0) {
                        byte headerByte;
                        int headerLinesCopied = SplitText.this.readLines((InputStream)in, headerInfoLineCount, Long.MAX_VALUE, (OutputStream)headerStream, true, null);
                        if (headerLinesCopied < headerInfoLineCount) {
                            errorMessage.set("Header Line Count is set to " + headerInfoLineCount + " but file had only " + headerLinesCopied + " lines");
                            return;
                        }
                        byte[] headerBytes = headerStream.toByteArray();
                        int headerNewLineByteCount = 0;
                        for (int i = headerBytes.length - 1; i >= 0 && ((headerByte = headerBytes[i]) == 13 || headerByte == 10); --i) {
                            ++headerNewLineByteCount;
                        }
                        if (headerNewLineByteCount == 0) {
                            headerNewLineBytes = null;
                            headerBytesWithoutTrailingNewLines = headerBytes;
                        } else {
                            headerNewLineBytes = new byte[headerNewLineByteCount];
                            System.arraycopy(headerBytes, headerBytes.length - headerNewLineByteCount, headerNewLineBytes, 0, headerNewLineByteCount);
                            headerBytesWithoutTrailingNewLines = new byte[headerBytes.length - headerNewLineByteCount];
                            System.arraycopy(headerBytes, 0, headerBytesWithoutTrailingNewLines, 0, headerBytes.length - headerNewLineByteCount);
                        }
                    } else {
                        headerBytesWithoutTrailingNewLines = null;
                        headerNewLineBytes = null;
                    }
                    while (true) {
                        long procMillis;
                        if (headerInfoLineCount > 0) {
                            final AtomicInteger linesCopied = new AtomicInteger(0);
                            final AtomicLong bytesCopied = new AtomicLong(0L);
                            FlowFile splitFile = session.create(flowFile);
                            try {
                                splitFile = session.write(splitFile, new OutputStreamCallback(){

                                    public void process(OutputStream rawOut) throws IOException {
                                        try (BufferedOutputStream out = new BufferedOutputStream(rawOut);
                                             ByteCountingOutputStream countingOut = new ByteCountingOutputStream((OutputStream)out);){
                                            countingOut.write(headerBytesWithoutTrailingNewLines);
                                            linesCopied.set(SplitText.this.readLines((InputStream)in, maxLineCount, maxFragmentSize - countingOut.getBytesWritten(), (OutputStream)countingOut, includeLineDelimiter, headerNewLineBytes));
                                            bytesCopied.set(countingOut.getBytesWritten());
                                        }
                                    }
                                });
                                splitFile = session.putAttribute(splitFile, SplitText.SPLIT_LINE_COUNT, String.valueOf(linesCopied.get()));
                                splitFile = session.putAttribute(splitFile, SplitText.FRAGMENT_SIZE, String.valueOf(bytesCopied.get()));
                                logger.debug("Created Split File {} with {} lines, {} bytes", new Object[]{splitFile, linesCopied.get(), bytesCopied.get()});
                            }
                            finally {
                                if (linesCopied.get() > 0) {
                                    splits.add(splitFile);
                                } else {
                                    session.remove(splitFile);
                                }
                            }
                            in.mark(1);
                            if (in.read() == -1) {
                                break;
                            }
                            in.reset();
                            continue;
                        }
                        long beforeReadingLines = in.getBytesConsumed() - bufferedPartialLine;
                        SplitInfo info = SplitText.this.locateSplitPoint((InputStream)in, maxLineCount, includeLineDelimiter, maxFragmentSize, bufferedPartialLine);
                        if (context.getProperty(FRAGMENT_MAX_SIZE).isSet()) {
                            bufferedPartialLine = info.bufferedBytes;
                        }
                        if (info.endOfStream) {
                            if (info.lengthBytes > 0L) {
                                info.offsetBytes = beforeReadingLines;
                                splitInfos.add(info);
                                long procNanos = System.nanoTime() - startNanos;
                                procMillis = TimeUnit.MILLISECONDS.convert(procNanos, TimeUnit.NANOSECONDS);
                                logger.debug("Detected start of Split File in {} at byte offset {} with a length of {} bytes; total splits = {}; total processing time = {} ms", new Object[]{flowFile, beforeReadingLines, info.lengthBytes, splitInfos.size(), procMillis});
                            }
                            break;
                        }
                        if (info.lengthBytes == 0L) continue;
                        info.offsetBytes = beforeReadingLines;
                        info.lengthBytes -= bufferedPartialLine;
                        splitInfos.add(info);
                        long procNanos = System.nanoTime() - startNanos;
                        procMillis = TimeUnit.MILLISECONDS.convert(procNanos, TimeUnit.NANOSECONDS);
                        logger.debug("Detected start of Split File in {} at byte offset {} with a length of {} bytes; total splits = {}; total processing time = {} ms", new Object[]{flowFile, beforeReadingLines, info.lengthBytes, splitInfos.size(), procMillis});
                    }
                }
            }
        });
        if (errorMessage.get() != null) {
            logger.error("Unable to split {} due to {}; routing to failure", new Object[]{flowFile, errorMessage.get()});
            session.transfer(flowFile, REL_FAILURE);
            if (!splits.isEmpty()) {
                session.remove(splits);
            }
            return;
        }
        if (!splitInfos.isEmpty()) {
            for (SplitInfo info : splitInfos) {
                FlowFile split = session.clone(flowFile, info.offsetBytes, info.lengthBytes);
                split = session.putAttribute(split, SPLIT_LINE_COUNT, String.valueOf(info.lengthLines));
                split = session.putAttribute(split, FRAGMENT_SIZE, String.valueOf(info.lengthBytes));
                splits.add(split);
            }
        }
        this.finishFragmentAttributes(session, flowFile, splits);
        if (splits.size() > 10) {
            logger.info("Split {} into {} files", new Object[]{flowFile, splits.size()});
        } else {
            logger.info("Split {} into {} files: {}", new Object[]{flowFile, splits.size(), splits});
        }
        session.transfer(flowFile, REL_ORIGINAL);
        session.transfer(splits, REL_SPLITS);
    }

    private void finishFragmentAttributes(ProcessSession session, FlowFile source, List<FlowFile> splits) {
        String originalFilename = source.getAttribute(CoreAttributes.FILENAME.key());
        String fragmentId = UUID.randomUUID().toString();
        ArrayList<FlowFile> newList = new ArrayList<FlowFile>(splits);
        splits.clear();
        for (int i = 1; i <= newList.size(); ++i) {
            FlowFile ff = newList.get(i - 1);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(FRAGMENT_ID, fragmentId);
            attributes.put(FRAGMENT_INDEX, String.valueOf(i));
            attributes.put(FRAGMENT_COUNT, String.valueOf(newList.size()));
            attributes.put(SEGMENT_ORIGINAL_FILENAME, originalFilename);
            FlowFile newFF = session.putAllAttributes(ff, attributes);
            splits.add(newFF);
        }
    }

    public static class EndOfLineMarker {
        private final long bytesConsumed;
        private final EndOfLineBuffer eolBuffer;
        private final boolean streamEnded;
        private final byte[] leadingNewLineBytes;

        public EndOfLineMarker(long bytesCounted, EndOfLineBuffer eolBuffer, boolean streamEnded, byte[] leadingNewLineBytes) {
            this.bytesConsumed = bytesCounted;
            this.eolBuffer = eolBuffer;
            this.streamEnded = streamEnded;
            this.leadingNewLineBytes = leadingNewLineBytes;
        }

        public long getBytesConsumed() {
            return this.bytesConsumed;
        }

        public EndOfLineBuffer getEndOfLineBuffer() {
            return this.eolBuffer;
        }

        public boolean isStreamEnded() {
            return this.streamEnded;
        }

        public byte[] getLeadingNewLineBytes() {
            return this.leadingNewLineBytes;
        }
    }

    public static class EndOfLineBuffer {
        private static final byte CARRIAGE_RETURN = 13;
        private static final byte NEWLINE = 10;
        private final BitSet buffer = new BitSet();
        private int index = 0;

        public void clear() {
            this.index = 0;
        }

        public void addEndOfLine(boolean carriageReturn, boolean newLine) {
            this.buffer.set(this.index++, carriageReturn);
            this.buffer.set(this.index++, newLine);
        }

        private void drainTo(OutputStream out) throws IOException {
            for (int i = 0; i < this.index; i += 2) {
                boolean cr = this.buffer.get(i);
                boolean nl = this.buffer.get(i + 1);
                if (!cr && !nl) {
                    return;
                }
                if (cr) {
                    out.write(13);
                }
                if (!nl) continue;
                out.write(10);
            }
            this.clear();
        }

        public int length() {
            return this.index / 2;
        }
    }

    private static class SplitInfo {
        public long offsetBytes = 0L;
        public long lengthBytes = 0L;
        public long lengthLines = 0L;
        public long bufferedBytes = 0L;
        public boolean endOfStream = false;
    }
}

