/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.FetchFile;
import org.apache.nifi.processors.standard.GetFile;
import org.apache.nifi.util.StopWatch;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"put", "local", "copy", "archive", "files", "filesystem", "restricted"})
@CapabilityDescription(value="Writes the contents of a FlowFile to the local file system")
@SeeAlso(value={FetchFile.class, GetFile.class})
@ReadsAttribute(attribute="filename", description="The filename to use when writing the FlowFile to disk.")
@Restricted(value="Provides operator the ability to write to any file that NiFi has access to.")
public class PutFile
extends AbstractProcessor {
    public static final String REPLACE_RESOLUTION = "replace";
    public static final String IGNORE_RESOLUTION = "ignore";
    public static final String FAIL_RESOLUTION = "fail";
    public static final String FILE_MODIFY_DATE_ATTRIBUTE = "file.lastModifiedTime";
    public static final String FILE_MODIFY_DATE_ATTR_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final PropertyDescriptor DIRECTORY = new PropertyDescriptor.Builder().name("Directory").description("The directory to which files should be written. You may use expression language such as /aa/bb/${path}").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor MAX_DESTINATION_FILES = new PropertyDescriptor.Builder().name("Maximum File Count").description("Specifies the maximum number of files that can exist in the output directory").required(false).addValidator(StandardValidators.INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor CONFLICT_RESOLUTION = new PropertyDescriptor.Builder().name("Conflict Resolution Strategy").description("Indicates what should happen when a file with the same name already exists in the output directory").required(true).defaultValue("fail").allowableValues(new String[]{"replace", "ignore", "fail"}).build();
    public static final PropertyDescriptor CHANGE_LAST_MODIFIED_TIME = new PropertyDescriptor.Builder().name("Last Modified Time").description("Sets the lastModifiedTime on the output file to the value of this attribute.  Format must be yyyy-MM-dd'T'HH:mm:ssZ.  You may also use expression language such as ${file.lastModifiedTime}.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor CHANGE_PERMISSIONS = new PropertyDescriptor.Builder().name("Permissions").description("Sets the permissions on the output file to the value of this attribute.  Format must be either UNIX rwxrwxrwx with a - in place of denied permissions (e.g. rw-r--r--) or an octal number (e.g. 644).  You may also use expression language such as ${file.permissions}.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor CHANGE_OWNER = new PropertyDescriptor.Builder().name("Owner").description("Sets the owner on the output file to the value of this attribute.  You may also use expression language such as ${file.owner}.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor CHANGE_GROUP = new PropertyDescriptor.Builder().name("Group").description("Sets the group on the output file to the value of this attribute.  You may also use expression language such as ${file.group}.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor CREATE_DIRS = new PropertyDescriptor.Builder().name("Create Missing Directories").description("If true, then missing destination directories will be created. If false, flowfiles are penalized and sent to failure.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final int MAX_FILE_LOCK_ATTEMPTS = 10;
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Files that have been successfully written to the output directory are transferred to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Files that could not be written to the output directory for some reason are transferred to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> procRels = new HashSet<Relationship>();
        procRels.add(REL_SUCCESS);
        procRels.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(procRels);
        ArrayList<PropertyDescriptor> supDescriptors = new ArrayList<PropertyDescriptor>();
        supDescriptors.add(DIRECTORY);
        supDescriptors.add(CONFLICT_RESOLUTION);
        supDescriptors.add(CREATE_DIRS);
        supDescriptors.add(MAX_DESTINATION_FILES);
        supDescriptors.add(CHANGE_LAST_MODIFIED_TIME);
        supDescriptors.add(CHANGE_PERMISSIONS);
        supDescriptors.add(CHANGE_OWNER);
        supDescriptors.add(CHANGE_GROUP);
        this.properties = Collections.unmodifiableList(supDescriptors);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch(true);
        Path configuredRootDirPath = Paths.get(context.getProperty(DIRECTORY).evaluateAttributeExpressions(flowFile).getValue(), new String[0]);
        String conflictResponse = context.getProperty(CONFLICT_RESOLUTION).getValue();
        Integer maxDestinationFiles = context.getProperty(MAX_DESTINATION_FILES).asInteger();
        ComponentLog logger = this.getLogger();
        Path tempDotCopyFile = null;
        try {
            String group;
            String owner;
            String permissions;
            int numFiles;
            Path dotCopyFile;
            Path rootDirPath = configuredRootDirPath;
            Path tempCopyFile = rootDirPath.resolve("." + flowFile.getAttribute(CoreAttributes.FILENAME.key()));
            Path copyFile = rootDirPath.resolve(flowFile.getAttribute(CoreAttributes.FILENAME.key()));
            if (!Files.exists(rootDirPath, new LinkOption[0])) {
                if (context.getProperty(CREATE_DIRS).asBoolean().booleanValue()) {
                    Files.createDirectories(rootDirPath, new FileAttribute[0]);
                } else {
                    flowFile = session.penalize(flowFile);
                    session.transfer(flowFile, REL_FAILURE);
                    logger.error("Penalizing {} and routing to 'failure' because the output directory {} does not exist and Processor is configured not to create missing directories", new Object[]{flowFile, rootDirPath});
                    return;
                }
            }
            tempDotCopyFile = dotCopyFile = tempCopyFile;
            Path finalCopyFile = copyFile;
            Path finalCopyFileDir = finalCopyFile.getParent();
            if (Files.exists(finalCopyFileDir, new LinkOption[0]) && maxDestinationFiles != null && (numFiles = finalCopyFileDir.toFile().list().length) >= maxDestinationFiles) {
                flowFile = session.penalize(flowFile);
                logger.warn("Penalizing {} and routing to 'failure' because the output directory {} has {} files, which exceeds the configured maximum number of files", new Object[]{flowFile, finalCopyFileDir, numFiles});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            if (Files.exists(finalCopyFile, new LinkOption[0])) {
                switch (conflictResponse) {
                    case "replace": {
                        Files.delete(finalCopyFile);
                        logger.info("Deleted {} as configured in order to replace with the contents of {}", new Object[]{finalCopyFile, flowFile});
                        break;
                    }
                    case "ignore": {
                        session.transfer(flowFile, REL_SUCCESS);
                        logger.info("Transferring {} to success because file with same name already exists", new Object[]{flowFile});
                        return;
                    }
                    case "fail": {
                        flowFile = session.penalize(flowFile);
                        logger.warn("Penalizing {} and routing to failure as configured because file with the same name already exists", new Object[]{flowFile});
                        session.transfer(flowFile, REL_FAILURE);
                        return;
                    }
                }
            }
            session.exportTo(flowFile, dotCopyFile, false);
            String lastModifiedTime = context.getProperty(CHANGE_LAST_MODIFIED_TIME).evaluateAttributeExpressions(flowFile).getValue();
            if (lastModifiedTime != null && !lastModifiedTime.trim().isEmpty()) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat(FILE_MODIFY_DATE_ATTR_FORMAT, Locale.US);
                    Date fileModifyTime = formatter.parse(lastModifiedTime);
                    dotCopyFile.toFile().setLastModified(fileModifyTime.getTime());
                }
                catch (Exception e) {
                    logger.warn("Could not set file lastModifiedTime to {} because {}", new Object[]{lastModifiedTime, e});
                }
            }
            if ((permissions = context.getProperty(CHANGE_PERMISSIONS).evaluateAttributeExpressions(flowFile).getValue()) != null && !permissions.trim().isEmpty()) {
                try {
                    String perms = this.stringPermissions(permissions);
                    if (!perms.isEmpty()) {
                        Files.setPosixFilePermissions(dotCopyFile, PosixFilePermissions.fromString(perms));
                    }
                }
                catch (Exception e) {
                    logger.warn("Could not set file permissions to {} because {}", new Object[]{permissions, e});
                }
            }
            if ((owner = context.getProperty(CHANGE_OWNER).evaluateAttributeExpressions(flowFile).getValue()) != null && !owner.trim().isEmpty()) {
                try {
                    UserPrincipalLookupService lookupService = dotCopyFile.getFileSystem().getUserPrincipalLookupService();
                    Files.setOwner(dotCopyFile, lookupService.lookupPrincipalByName(owner));
                }
                catch (Exception e) {
                    logger.warn("Could not set file owner to {} because {}", new Object[]{owner, e});
                }
            }
            if ((group = context.getProperty(CHANGE_GROUP).evaluateAttributeExpressions(flowFile).getValue()) != null && !group.trim().isEmpty()) {
                try {
                    UserPrincipalLookupService lookupService = dotCopyFile.getFileSystem().getUserPrincipalLookupService();
                    PosixFileAttributeView view = Files.getFileAttributeView(dotCopyFile, PosixFileAttributeView.class, new LinkOption[0]);
                    view.setGroup(lookupService.lookupPrincipalByGroupName(group));
                }
                catch (Exception e) {
                    logger.warn("Could not set file group to {} because {}", new Object[]{group, e});
                }
            }
            boolean renamed = false;
            for (int i = 0; i < 10; ++i) {
                if (dotCopyFile.toFile().renameTo(finalCopyFile.toFile())) {
                    renamed = true;
                    break;
                }
                Thread.sleep(100L);
            }
            if (!renamed) {
                if (Files.exists(dotCopyFile, new LinkOption[0]) && dotCopyFile.toFile().delete()) {
                    logger.debug("Deleted dot copy file {}", new Object[]{dotCopyFile});
                }
                throw new ProcessException("Could not rename: " + dotCopyFile);
            }
            logger.info("Produced copy of {} at location {}", new Object[]{flowFile, finalCopyFile});
            session.getProvenanceReporter().send(flowFile, finalCopyFile.toFile().toURI().toString(), stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Throwable t) {
            if (tempDotCopyFile != null) {
                try {
                    Files.deleteIfExists(tempDotCopyFile);
                }
                catch (Exception e) {
                    logger.error("Unable to remove temporary file {} due to {}", new Object[]{tempDotCopyFile, e});
                }
            }
            flowFile = session.penalize(flowFile);
            logger.error("Penalizing {} and transferring to failure due to {}", new Object[]{flowFile, t});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected String stringPermissions(String perms) {
        String permissions = "";
        Pattern rwxPattern = Pattern.compile("^[rwx-]{9}$");
        Pattern numPattern = Pattern.compile("\\d+");
        if (rwxPattern.matcher(perms).matches()) {
            permissions = perms;
        } else if (numPattern.matcher(perms).matches()) {
            try {
                int number = Integer.parseInt(perms, 8);
                StringBuilder permBuilder = new StringBuilder();
                if ((number & 0x100) > 0) {
                    permBuilder.append('r');
                } else {
                    permBuilder.append('-');
                }
                if ((number & 0x80) > 0) {
                    permBuilder.append('w');
                } else {
                    permBuilder.append('-');
                }
                if ((number & 0x40) > 0) {
                    permBuilder.append('x');
                } else {
                    permBuilder.append('-');
                }
                if ((number & 0x20) > 0) {
                    permBuilder.append('r');
                } else {
                    permBuilder.append('-');
                }
                if ((number & 0x10) > 0) {
                    permBuilder.append('w');
                } else {
                    permBuilder.append('-');
                }
                if ((number & 8) > 0) {
                    permBuilder.append('x');
                } else {
                    permBuilder.append('-');
                }
                if ((number & 4) > 0) {
                    permBuilder.append('r');
                } else {
                    permBuilder.append('-');
                }
                if ((number & 2) > 0) {
                    permBuilder.append('w');
                } else {
                    permBuilder.append('-');
                }
                if ((number & 8) > 0) {
                    permBuilder.append('x');
                } else {
                    permBuilder.append('-');
                }
                permissions = permBuilder.toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return permissions;
    }
}

