/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base32;

public class ValidatingBase32InputStream
extends FilterInputStream {
    private final Base32 b32 = new Base32();

    public ValidatingBase32InputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        int numRead = super.read(b, offset, len);
        if (numRead > 0) {
            byte[] copy = b;
            if (numRead < b.length) {
                copy = Arrays.copyOf(b, numRead);
            }
            if (!this.b32.isInAlphabet(copy, true)) {
                throw new IOException("Data is not base32 encoded.");
            }
        }
        return numRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int numRead = super.read(b);
        if (numRead > 0) {
            byte[] copy = b;
            if (numRead < b.length) {
                copy = Arrays.copyOf(b, numRead);
            }
            if (!this.b32.isInAlphabet(copy, true)) {
                throw new IOException("Data is not base32 encoded.");
            }
        }
        return numRead;
    }

    @Override
    public int read() throws IOException {
        int data = super.read();
        if (!this.b32.isInAlphabet((byte)data)) {
            throw new IOException("Data is not base32 encoded.");
        }
        return super.read();
    }
}

