/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.AbstractRouteRecord;
import org.apache.nifi.processors.standard.ConvertRecord;
import org.apache.nifi.processors.standard.SplitRecord;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.record.path.util.RecordPathCache;
import org.apache.nifi.record.path.validation.RecordPathValidator;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.util.Tuple;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="Sets the mime.type attribute to the MIME Type specified by the Record Writer"), @WritesAttribute(attribute="record.count", description="The number of records in the FlowFile")})
@Tags(value={"lookup", "enrichment", "route", "record", "csv", "json", "avro", "database", "db", "logs", "convert", "filter"})
@CapabilityDescription(value="Extracts one or more fields from a Record and looks up a value for those fields in a LookupService. If a result is returned by the LookupService, that result is optionally added to the Record. In this case, the processor functions as an Enrichment processor. Regardless, the Record is then routed to either the 'matched' relationship or 'unmatched' relationship (if the 'Routing Strategy' property is configured to do so), indicating whether or not a result was returned by the LookupService, allowing the processor to also function as a Routing processor. The \"coordinates\" to use for looking up a value in the Lookup Service are defined by adding a user-defined property. Each property that is added will have an entry added to a Map, where the name of the property becomes the Map Key and the value returned by the RecordPath becomes the value for that key. If multiple values are returned by the RecordPath, then the Record will be routed to the 'unmatched' relationship (or 'success', depending on the 'Routing Strategy' property's configuration). If one or more fields match the Result RecordPath, all fields that match will be updated. If there is no match in the configured LookupService, then no fields will be updated. I.e., it will not overwrite an existing value in the Record with a null value. Please note, however, that if the results returned by the LookupService are not accounted for in your schema (specifically, the schema that is configured for your Record Writer) then the fields will not be written out to the FlowFile.")
@DynamicProperty(name="Value To Lookup", value="Valid Record Path", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="A RecordPath that points to the field whose value will be looked up in the configured Lookup Service")
@SeeAlso(value={ConvertRecord.class, SplitRecord.class}, classNames={"org.apache.nifi.lookup.SimpleKeyValueLookupService", "org.apache.nifi.lookup.maxmind.IPLookupService", "org.apache.nifi.lookup.db.DatabaseRecordLookupService"})
public class LookupRecord
extends AbstractRouteRecord<Tuple<Map<String, RecordPath>, RecordPath>> {
    private volatile RecordPathCache recordPathCache = new RecordPathCache(25);
    private volatile LookupService<?> lookupService;
    static final AllowableValue ROUTE_TO_SUCCESS = new AllowableValue("route-to-success", "Route to 'success'", "Records will be routed to a 'success' Relationship regardless of whether or not there is a match in the configured Lookup Service");
    static final AllowableValue ROUTE_TO_MATCHED_UNMATCHED = new AllowableValue("route-to-matched-unmatched", "Route to 'matched' or 'unmatched'", "Records will be routed to either a 'matched' or an 'unmatched' Relationship depending on whether or not there was a match in the configured Lookup Service. A single input FlowFile may result in two different output FlowFiles.");
    static final AllowableValue RESULT_ENTIRE_RECORD = new AllowableValue("insert-entire-record", "Insert Entire Record", "The entire Record that is retrieved from the Lookup Service will be inserted into the destination path.");
    static final AllowableValue RESULT_RECORD_FIELDS = new AllowableValue("record-fields", "Insert Record Fields", "All of the fields in the Record that is retrieved from the Lookup Service will be inserted into the destination path.");
    static final AllowableValue USE_PROPERTY = new AllowableValue("use-property", "Use Property", "The \"Result RecordPath\" property will be used to determine which part of the record should be updated with the value returned by the Lookup Service");
    static final AllowableValue REPLACE_EXISTING_VALUES = new AllowableValue("replace-existing-values", "Replace Existing Values", "The \"Result RecordPath\" property will be ignored and the lookup service must be a single simple key lookup service. Every dynamic property value should be a record path. For each dynamic property, the value contained in the field corresponding to the record path will be used as the key in the Lookup Service and the value returned by the Lookup Service will be used to replace the existing value. It is possible to configure multiple dynamic properties to replace multiple values in one execution. This strategy only supports simple types replacements (strings, integers, etc).");
    static final PropertyDescriptor LOOKUP_SERVICE = new PropertyDescriptor.Builder().name("lookup-service").displayName("Lookup Service").description("The Lookup Service to use in order to lookup a value in each Record").identifiesControllerService(LookupService.class).required(true).build();
    static final PropertyDescriptor RESULT_RECORD_PATH = new PropertyDescriptor.Builder().name("result-record-path").displayName("Result RecordPath").description("A RecordPath that points to the field whose value should be updated with whatever value is returned from the Lookup Service. If not specified, the value that is returned from the Lookup Service will be ignored, except for determining whether the FlowFile should be routed to the 'matched' or 'unmatched' Relationship.").addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    static final PropertyDescriptor RESULT_CONTENTS = new PropertyDescriptor.Builder().name("result-contents").displayName("Record Result Contents").description("When a result is obtained that contains a Record, this property determines whether the Record itself is inserted at the configured path or if the contents of the Record (i.e., the sub-fields) will be inserted at the configured path.").allowableValues(new AllowableValue[]{RESULT_ENTIRE_RECORD, RESULT_RECORD_FIELDS}).defaultValue(RESULT_ENTIRE_RECORD.getValue()).required(true).build();
    static final PropertyDescriptor ROUTING_STRATEGY = new PropertyDescriptor.Builder().name("routing-strategy").displayName("Routing Strategy").description("Specifies how to route records after a Lookup has completed").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new AllowableValue[]{ROUTE_TO_SUCCESS, ROUTE_TO_MATCHED_UNMATCHED}).defaultValue(ROUTE_TO_SUCCESS.getValue()).required(true).build();
    static final PropertyDescriptor REPLACEMENT_STRATEGY = new PropertyDescriptor.Builder().name("record-update-strategy").displayName("Record Update Strategy").description("This property defines the strategy to use when updating the record with the value returned by the Lookup Service.").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new AllowableValue[]{REPLACE_EXISTING_VALUES, USE_PROPERTY}).defaultValue(USE_PROPERTY.getValue()).required(true).build();
    static final Relationship REL_MATCHED = new Relationship.Builder().name("matched").description("All records for which the lookup returns a value will be routed to this relationship").build();
    static final Relationship REL_UNMATCHED = new Relationship.Builder().name("unmatched").description("All records for which the lookup does not have a matching value will be routed to this relationship").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All records will be sent to this Relationship if configured to do so, unless a failure occurs").build();
    private static final Set<Relationship> MATCHED_COLLECTION = Collections.singleton(REL_MATCHED);
    private static final Set<Relationship> UNMATCHED_COLLECTION = Collections.singleton(REL_UNMATCHED);
    private static final Set<Relationship> SUCCESS_COLLECTION = Collections.singleton(REL_SUCCESS);
    private volatile Set<Relationship> relationships = new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE));
    private volatile boolean routeToMatchedUnmatched = false;

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.lookupService = (LookupService)context.getProperty(LOOKUP_SERVICE).asControllerService(LookupService.class);
    }

    @Override
    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.addAll(super.getSupportedPropertyDescriptors());
        properties.add(LOOKUP_SERVICE);
        properties.add(RESULT_RECORD_PATH);
        properties.add(ROUTING_STRATEGY);
        properties.add(RESULT_CONTENTS);
        properties.add(REPLACEMENT_STRATEGY);
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("A RecordPath that points to the field whose value will be looked up in the configured Lookup Service").addValidator((Validator)new RecordPathValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Set dynamicPropNames = validationContext.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).map(PropertyDescriptor::getName).collect(Collectors.toSet());
        if (dynamicPropNames.isEmpty()) {
            return Collections.singleton(new ValidationResult.Builder().subject("User-Defined Properties").valid(false).explanation("At least one user-defined property must be specified.").build());
        }
        Set requiredKeys = ((LookupService)validationContext.getProperty(LOOKUP_SERVICE).asControllerService(LookupService.class)).getRequiredKeys();
        if (validationContext.getProperty(REPLACEMENT_STRATEGY).getValue().equals(REPLACE_EXISTING_VALUES.getValue())) {
            if (requiredKeys.size() != 1) {
                return Collections.singleton(new ValidationResult.Builder().subject(LOOKUP_SERVICE.getDisplayName()).valid(false).explanation("When using \"" + REPLACE_EXISTING_VALUES.getDisplayName() + "\" as Record Update Strategy, only a Lookup Service requiring a single key can be used.").build());
            }
        } else {
            Set missingKeys = requiredKeys.stream().filter(key -> !dynamicPropNames.contains(key)).collect(Collectors.toSet());
            if (!missingKeys.isEmpty()) {
                ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
                for (String missingKey : missingKeys) {
                    ValidationResult result = new ValidationResult.Builder().subject(missingKey).valid(false).explanation("The configured Lookup Services requires that a key be provided with the name '" + missingKey + "'. Please add a new property to this Processor with a name '" + missingKey + "' and provide a RecordPath that can be used to retrieve the appropriate value.").build();
                    validationResults.add(result);
                }
                return validationResults;
            }
        }
        return Collections.emptyList();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (ROUTING_STRATEGY.equals((Object)descriptor)) {
            if (ROUTE_TO_MATCHED_UNMATCHED.getValue().equalsIgnoreCase(newValue)) {
                HashSet<Relationship> matchedUnmatchedRels = new HashSet<Relationship>();
                matchedUnmatchedRels.add(REL_MATCHED);
                matchedUnmatchedRels.add(REL_UNMATCHED);
                matchedUnmatchedRels.add(REL_FAILURE);
                this.relationships = matchedUnmatchedRels;
                this.routeToMatchedUnmatched = true;
            } else {
                HashSet<Relationship> successRels = new HashSet<Relationship>();
                successRels.add(REL_SUCCESS);
                successRels.add(REL_FAILURE);
                this.relationships = successRels;
                this.routeToMatchedUnmatched = false;
            }
        }
    }

    @Override
    protected Set<Relationship> route(Record record, RecordSchema writeSchema, FlowFile flowFile, ProcessContext context, Tuple<Map<String, RecordPath>, RecordPath> flowFileContext) {
        boolean isInPlaceReplacement = context.getProperty(REPLACEMENT_STRATEGY).getValue().equals(REPLACE_EXISTING_VALUES.getValue());
        if (isInPlaceReplacement) {
            return this.doInPlaceReplacement(record, flowFile, context, flowFileContext);
        }
        return this.doResultPathReplacement(record, flowFile, context, flowFileContext);
    }

    private Set<Relationship> doInPlaceReplacement(Record record, FlowFile flowFile, ProcessContext context, Tuple<Map<String, RecordPath>, RecordPath> flowFileContext) {
        String lookupKey = (String)((LookupService)context.getProperty(LOOKUP_SERVICE).asControllerService(LookupService.class)).getRequiredKeys().iterator().next();
        Map recordPaths = (Map)flowFileContext.getKey();
        HashMap<String, Object> lookupCoordinates = new HashMap<String, Object>(recordPaths.size());
        for (Map.Entry entry : recordPaths.entrySet()) {
            String coordinateKey = (String)entry.getKey();
            RecordPath recordPath = (RecordPath)entry.getValue();
            RecordPathResult pathResult = recordPath.evaluate(record);
            List lookupFieldValues = pathResult.getSelectedFields().filter(fieldVal -> fieldVal.getValue() != null).collect(Collectors.toList());
            if (lookupFieldValues.isEmpty()) {
                Set<Relationship> rels = this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                this.getLogger().debug("RecordPath for property '{}' did not match any fields in a record for {}; routing record to {}", new Object[]{coordinateKey, flowFile, rels});
                return rels;
            }
            for (FieldValue fieldValue : lookupFieldValues) {
                Optional lookupValueOption;
                Object coordinateValue = fieldValue.getValue() instanceof Number || fieldValue.getValue() instanceof Boolean ? fieldValue.getValue() : DataTypeUtils.toString((Object)fieldValue.getValue(), (String)null);
                lookupCoordinates.put(lookupKey, coordinateValue);
                try {
                    lookupValueOption = this.lookupService.lookup(lookupCoordinates, flowFile.getAttributes());
                }
                catch (Exception e) {
                    throw new ProcessException("Failed to lookup coordinates " + lookupCoordinates + " in Lookup Service", (Throwable)e);
                }
                if (!lookupValueOption.isPresent()) {
                    Set<Relationship> rels = this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                    return rels;
                }
                Object lookupValue = lookupValueOption.get();
                DataType inferredDataType = DataTypeUtils.inferDataType(lookupValue, (DataType)RecordFieldType.STRING.getDataType());
                fieldValue.updateValue(lookupValue, inferredDataType);
            }
        }
        Set<Relationship> rels = this.routeToMatchedUnmatched ? MATCHED_COLLECTION : SUCCESS_COLLECTION;
        return rels;
    }

    private Set<Relationship> doResultPathReplacement(Record record, FlowFile flowFile, ProcessContext context, Tuple<Map<String, RecordPath>, RecordPath> flowFileContext) {
        Optional lookupValueOption;
        Map recordPaths = (Map)flowFileContext.getKey();
        HashMap<String, Object> lookupCoordinates = new HashMap<String, Object>(recordPaths.size());
        for (Map.Entry entry : recordPaths.entrySet()) {
            Set<Relationship> rels;
            String coordinateKey = (String)entry.getKey();
            RecordPath recordPath = (RecordPath)entry.getValue();
            RecordPathResult pathResult = recordPath.evaluate(record);
            List lookupFieldValues = pathResult.getSelectedFields().filter(fieldVal -> fieldVal.getValue() != null).collect(Collectors.toList());
            if (lookupFieldValues.isEmpty()) {
                rels = this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                this.getLogger().debug("RecordPath for property '{}' did not match any fields in a record for {}; routing record to {}", new Object[]{coordinateKey, flowFile, rels});
                return rels;
            }
            if (lookupFieldValues.size() > 1) {
                rels = this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
                this.getLogger().debug("RecordPath for property '{}' matched {} fields in a record for {}; routing record to {}", new Object[]{coordinateKey, lookupFieldValues.size(), flowFile, rels});
                return rels;
            }
            FieldValue fieldValue = (FieldValue)lookupFieldValues.get(0);
            Object coordinateValue = fieldValue.getValue() instanceof Number || fieldValue.getValue() instanceof Boolean ? fieldValue.getValue() : DataTypeUtils.toString((Object)fieldValue.getValue(), (String)null);
            lookupCoordinates.put(coordinateKey, coordinateValue);
        }
        try {
            lookupValueOption = this.lookupService.lookup(lookupCoordinates, flowFile.getAttributes());
        }
        catch (Exception e) {
            throw new ProcessException("Failed to lookup coordinates " + lookupCoordinates + " in Lookup Service", (Throwable)e);
        }
        if (!lookupValueOption.isPresent()) {
            Set<Relationship> rels = this.routeToMatchedUnmatched ? UNMATCHED_COLLECTION : SUCCESS_COLLECTION;
            return rels;
        }
        RecordPath resultPath = (RecordPath)flowFileContext.getValue();
        if (resultPath != null) {
            Object lookupValue = lookupValueOption.get();
            RecordPathResult resultPathResult = ((RecordPath)flowFileContext.getValue()).evaluate(record);
            String resultContentsValue = context.getProperty(RESULT_CONTENTS).getValue();
            if (RESULT_RECORD_FIELDS.getValue().equals(resultContentsValue) && lookupValue instanceof Record) {
                Record lookupRecord = (Record)lookupValue;
                resultPathResult.getSelectedFields().forEach(fieldVal -> {
                    Object destinationValue = fieldVal.getValue();
                    if (destinationValue instanceof Record) {
                        Record destinationRecord = (Record)destinationValue;
                        for (String fieldName : lookupRecord.getRawFieldNames()) {
                            Object value = lookupRecord.getValue(fieldName);
                            Optional recordFieldOption = lookupRecord.getSchema().getField(fieldName);
                            if (recordFieldOption.isPresent()) {
                                RecordField field = (RecordField)recordFieldOption.get();
                                if (!this.routeToMatchedUnmatched && !field.isNullable()) {
                                    field = new RecordField(field.getFieldName(), field.getDataType(), field.getDefaultValue(), field.getAliases(), true);
                                }
                                destinationRecord.setValue(field, value);
                                continue;
                            }
                            destinationRecord.setValue(fieldName, value);
                        }
                    } else {
                        Optional parentOption = fieldVal.getParentRecord();
                        parentOption.ifPresent(parent -> parent.setValue(fieldVal.getField(), (Object)lookupRecord));
                    }
                });
            } else {
                DataType inferredDataType = DataTypeUtils.inferDataType(lookupValue, (DataType)RecordFieldType.STRING.getDataType());
                resultPathResult.getSelectedFields().forEach(fieldVal -> fieldVal.updateValue(lookupValue, inferredDataType));
            }
            record.incorporateInactiveFields();
        }
        Set<Relationship> rels = this.routeToMatchedUnmatched ? MATCHED_COLLECTION : SUCCESS_COLLECTION;
        return rels;
    }

    @Override
    protected boolean isRouteOriginal() {
        return false;
    }

    @Override
    protected Tuple<Map<String, RecordPath>, RecordPath> getFlowFileContext(FlowFile flowFile, ProcessContext context) {
        RecordPath resultRecordPath;
        HashMap<String, RecordPath> recordPaths = new HashMap<String, RecordPath>();
        for (PropertyDescriptor prop : context.getProperties().keySet()) {
            if (!prop.isDynamic()) continue;
            String pathText = context.getProperty(prop).evaluateAttributeExpressions(flowFile).getValue();
            RecordPath lookupRecordPath = this.recordPathCache.getCompiled(pathText);
            recordPaths.put(prop.getName(), lookupRecordPath);
        }
        if (context.getProperty(RESULT_RECORD_PATH).isSet()) {
            String resultPathText = context.getProperty(RESULT_RECORD_PATH).evaluateAttributeExpressions(flowFile).getValue();
            resultRecordPath = this.recordPathCache.getCompiled(resultPathText);
        } else {
            resultRecordPath = null;
        }
        return new Tuple(recordPaths, resultRecordPath);
    }
}

